/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.packageview.NamespaceGroup;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;

public class StandardJavaScriptElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardJavaScriptElementContentProvider() {
        this(false);
    }

    public StandardJavaScriptElementContentProvider(boolean provideMembers) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideMembers;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof IJavaScriptModel) {
                return this.getJavaProjects((IJavaScriptModel)element);
            }
            if (element instanceof IJavaScriptProject) {
                return this.getPackageFragmentRoots((IJavaScriptProject)element);
            }
            if (element instanceof IPackageFragmentRoot) {
                return this.getPackageFragmentRootContent((IPackageFragmentRoot)element);
            }
            if (element instanceof IPackageFragment) {
                return this.getPackageContent((IPackageFragment)element);
            }
            if (element instanceof IFolder) {
                return this.getFolderContent((IFolder)element);
            }
            if (element instanceof IJarEntryResource) {
                return ((IJarEntryResource)element).getChildren();
            }
            if (this.getProvideMembers() && element instanceof ISourceReference && element instanceof IParent) {
                if (element instanceof ITypeRoot) {
                    return this.filter(((IParent)element).getChildren());
                }
                return ((IParent)element).getChildren();
            }
        }
        catch (CoreException e) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    protected boolean matches(IJavaScriptElement element) {
        if (element.getElementType() == 7 && (element.getParent().getElementType() == 5 || element.getParent().getElementType() == 6)) {
            IType type = (IType)element;
            try {
                return type.isAnonymous();
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected IJavaScriptElement[] filter(IJavaScriptElement[] children) {
        boolean initializers = false;
        int i = 0;
        while (i < children.length) {
            if (this.matches(children[i])) {
                initializers = true;
                break;
            }
            ++i;
        }
        if (!initializers) {
            return children;
        }
        Vector<IJavaScriptElement> v = new Vector<IJavaScriptElement>();
        int i2 = 0;
        while (i2 < children.length) {
            if (!this.matches(children[i2])) {
                v.addElement(children[i2]);
            }
            ++i2;
        }
        Object[] result = new IJavaScriptElement[v.size()];
        v.copyInto(result);
        return result;
    }

    public boolean hasChildren(Object element) {
        IJavaScriptProject jp;
        if (this.getProvideMembers()) {
            if (element instanceof IJavaScriptUnit || element instanceof IClassFile) {
                try {
                    if (element instanceof IJavaScriptUnit) {
                        IJavaScriptUnit cu = (IJavaScriptUnit)element;
                        return cu.hasChildren();
                    }
                    if (element instanceof IClassFile) {
                        IClassFile cf = (IClassFile)element;
                        return cf.hasChildren();
                    }
                }
                catch (JavaScriptModelException ex) {
                    return false;
                }
                return true;
            }
        } else if (element instanceof IJavaScriptUnit || element instanceof IClassFile || element instanceof IFile) {
            return false;
        }
        if (element instanceof IJavaScriptProject && !(jp = (IJavaScriptProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (JavaScriptModelException e) {
                return true;
            }
        }
        if (element instanceof NamespaceGroup || element instanceof PackageFragmentRootContainer) {
            return true;
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot root) throws JavaScriptModelException {
        Object[] fragments = root.getChildren();
        if (this.isProjectPackageFragmentRoot(root)) {
            return fragments;
        }
        Object[] nonJavaResources = root.getNonJavaScriptResources();
        if (nonJavaResources == null) {
            return fragments;
        }
        return StandardJavaScriptElementContentProvider.concatenate(fragments, nonJavaResources);
    }

    protected Object[] getPackageFragmentRoots(IJavaScriptProject project) throws JavaScriptModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (this.isProjectPackageFragmentRoot(root)) {
                Object[] fragments = this.getPackageFragmentRootContent(root);
                int j = 0;
                while (j < fragments.length) {
                    list.add(fragments[j]);
                    ++j;
                }
            } else {
                list.add(root);
            }
            ++i;
        }
        Object[] resources = project.getNonJavaScriptResources();
        int i2 = 0;
        while (i2 < resources.length) {
            list.add(resources[i2]);
            ++i2;
        }
        return list.toArray();
    }

    protected Object[] getJavaProjects(IJavaScriptModel jm) throws JavaScriptModelException {
        return jm.getJavaScriptProjects();
    }

    protected Object[] getPackageContent(IPackageFragment fragment) throws JavaScriptModelException {
        if (fragment.getKind() == 1) {
            return StandardJavaScriptElementContentProvider.concatenate(fragment.getJavaScriptUnits(), fragment.getNonJavaScriptResources());
        }
        return StandardJavaScriptElementContentProvider.concatenate(fragment.getClassFiles(), fragment.getNonJavaScriptResources());
    }

    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        Object[] members = folder.members();
        IJavaScriptProject javaProject = JavaScriptCore.create((IProject)folder.getProject());
        if (javaProject == null || !javaProject.exists()) {
            return members;
        }
        boolean isFolderOnClasspath = javaProject.isOnIncludepath((IResource)folder);
        ArrayList<Object> nonJavaResources = new ArrayList<Object>();
        int i = 0;
        while (i < members.length) {
            Object member = members[i];
            if (isFolderOnClasspath) {
                if (javaProject.findPackageFragmentRoot(member.getFullPath()) == null) {
                    nonJavaResources.add(member);
                }
            } else if (!javaProject.isOnIncludepath((IResource)member)) {
                nonJavaResources.add(member);
            }
            ++i;
        }
        return nonJavaResources.toArray();
    }

    protected boolean isClassPathChange(IJavaScriptElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        if (this.isProjectPackageFragmentRoot(root)) {
            return root.getParent();
        }
        return root;
    }

    protected boolean isPackageFragmentEmpty(IJavaScriptElement element) throws JavaScriptModelException {
        IPackageFragment fragment;
        return element instanceof IPackageFragment && (fragment = (IPackageFragment)element).exists() && !fragment.hasChildren() && fragment.getNonJavaScriptResources().length <= 0 && fragment.hasSubpackages();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        IJavaScriptProject javaProject = root.getJavaScriptProject();
        return javaProject != null && javaProject.getPath().equals((Object)root.getPath());
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaScriptElement jParent = JavaScriptCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IJavaScriptElement) {
            IJavaScriptElement parent = ((IJavaScriptElement)element).getParent();
            if (element instanceof IPackageFragment) {
                return this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)parent);
            }
            return parent;
        }
        if (element instanceof IJarEntryResource) {
            return ((IJarEntryResource)element).getParent();
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        if (a1Len == 0) {
            return a2;
        }
        if (a2Len == 0) {
            return a1;
        }
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

