/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

class StorageSizeFieldEditor
extends StringFieldEditor {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;
    private final int minValidValue;
    private final int maxValidValue;

    StorageSizeFieldEditor(String name, String labelText, Composite parent, int min, int max) {
        Assert.isTrue((min > 0 && min < max ? 1 : 0) != 0);
        this.init(name, labelText);
        this.setTextLimit(10);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{min, max}));
        this.createControl(parent);
        this.minValidValue = min;
        this.maxValidValue = max;
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        String numberString = text.getText();
        int number = this.parse(numberString);
        if (this.checkValue(number)) {
            this.clearErrorMessage();
            return true;
        }
        this.showErrorMessage();
        return false;
    }

    protected boolean checkValue(int number) {
        return number >= this.minValidValue && number <= this.maxValidValue;
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            text.setText(this.format(value));
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            text.setText(this.format(value));
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            int v = this.parse(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), v);
        }
    }

    private String format(int value) {
        if (value > 0x40000000 && value / 0x40000000 * 0x40000000 == value) {
            return String.valueOf(String.valueOf(value / 0x40000000)) + " g";
        }
        if (value > 0x100000 && value / 0x100000 * 0x100000 == value) {
            return String.valueOf(String.valueOf(value / 0x100000)) + " m";
        }
        if (value > 1024 && value / 1024 * 1024 == value) {
            return String.valueOf(String.valueOf(value / 1024)) + " k";
        }
        return String.valueOf(value);
    }

    private int parse(String str) {
        String n = str.trim();
        if (n.length() == 0) {
            return 0;
        }
        int mul = 1;
        char lastChar = n.charAt(n.length() - 1);
        switch (Character.toLowerCase(lastChar)) {
            case 'g': {
                mul = 0x40000000;
                break;
            }
            case 'm': {
                mul = 0x100000;
                break;
            }
            case 'k': {
                mul = 1024;
                break;
            }
            default: {
                if (Character.isDigit(lastChar)) break;
                return 0;
            }
        }
        if (mul > 1) {
            n = n.substring(0, n.length() - 1).trim();
        }
        if (n.length() == 0) {
            return 0;
        }
        try {
            return mul * Integer.parseInt(n);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

