/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.TerminateToggleValue;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.ToggleBreakpointsTargetManager;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPropertiesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.memory.MemoryRenderingManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIUtils;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManager;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class DebugUITools {
    private static ObjectUndoContext fgBreakpointsUndoContext;
    private static HashMap<Object, Object> fgLaunchToggleTerminateMap;
    private static Set<ILaunch> fgLaunchList;
    private static Runnable fgLaunchTerminate;

    static {
        fgLaunchToggleTerminateMap = new HashMap();
        fgLaunchList = new LinkedHashSet<ILaunch>();
        fgLaunchTerminate = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String launchConfigName = null;
                try {
                    LinkedHashSet launchList;
                    Set set = fgLaunchList;
                    synchronized (set) {
                        launchList = new LinkedHashSet(fgLaunchList);
                        fgLaunchList.clear();
                    }
                    for (ILaunch iLaunch : launchList) {
                        launchConfigName = iLaunch.getLaunchConfiguration().getName();
                        iLaunch.terminate();
                    }
                }
                catch (DebugException e) {
                    DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), NLS.bind((String)ActionMessages.TerminateAndLaunchFailure, launchConfigName), (Throwable)e));
                }
            }
        };
    }

    public static Image getImage(String key) {
        return DebugPluginImages.getImage(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return DebugPluginImages.getImageDescriptor(key);
    }

    public static ImageDescriptor getDefaultImageDescriptor(Object element) {
        String imageKey = DebugUITools.getDefaultImageKey(element);
        if (imageKey == null) {
            return null;
        }
        return DebugPluginImages.getImageDescriptor(imageKey);
    }

    private static String getDefaultImageKey(Object element) {
        return ((DefaultLabelProvider)DebugUIPlugin.getDefaultLabelProvider()).getImageKey(element);
    }

    public static IPreferenceStore getPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public static IDebugModelPresentation newDebugModelPresentation() {
        return new DelegatingModelPresentation();
    }

    public static IDebugModelPresentation newDebugModelPresentation(String identifier) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "debugModelPresentations");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement elt = configElements[j];
                    String id = elt.getAttribute("id");
                    if (id != null && id.equals(identifier)) {
                        return new LazyModelPresentation(elt);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static IAdaptable getDebugContext() {
        IWorkbenchWindow activeWindow = SelectedResourceManager.getDefault().getActiveWindow();
        if (activeWindow != null) {
            ISelection activeContext = DebugUITools.getDebugContextManager().getContextService(activeWindow).getActiveContext();
            return DebugUITools.getDebugContextElementForSelection(activeContext);
        }
        return null;
    }

    public static ISelection getDebugContextForPart(IWorkbenchPart part) {
        IWorkbenchPartSite site = part.getSite();
        IWorkbenchWindow partWindow = site.getWorkbenchWindow();
        if (partWindow != null) {
            IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(partWindow);
            if (site instanceof IViewSite) {
                return contextService.getActiveContext(site.getId(), ((IViewSite)site).getSecondaryId());
            }
            return contextService.getActiveContext(site.getId());
        }
        return null;
    }

    public static synchronized IUndoContext getBreakpointsUndoContext() {
        if (fgBreakpointsUndoContext == null) {
            fgBreakpointsUndoContext = new ObjectUndoContext(new Object(), "Breakpoints Context");
            fgBreakpointsUndoContext.addMatch(WorkspaceUndoUtil.getWorkspaceUndoContext());
        }
        return fgBreakpointsUndoContext;
    }

    public static void deleteBreakpoints(IBreakpoint[] breakpoints, final Shell shell, IProgressMonitor progressMonitor) throws CoreException {
        IMarker[] markers = new IMarker[breakpoints.length];
        int markerCount = 0;
        while (markerCount < breakpoints.length) {
            if (!breakpoints[markerCount].isRegistered()) break;
            markers[markerCount] = breakpoints[markerCount].getMarker();
            if (markers[markerCount] == null) break;
            ++markerCount;
        }
        boolean allowUndo = markerCount == breakpoints.length;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints(breakpoints, !allowUndo);
        if (allowUndo) {
            int i = 0;
            while (i < markers.length) {
                markers[i].setAttribute("org.eclipse.debug.core.breakpointIsDeleted", true);
                ++i;
            }
            IAdaptable context = null;
            if (shell != null) {
                context = new IAdaptable(){

                    public <T> T getAdapter(Class<T> adapter) {
                        if (adapter == Shell.class) {
                            return (T)shell;
                        }
                        return null;
                    }
                };
            }
            String operationName = markers.length == 1 ? ActionMessages.DeleteBreakpointOperationName : ActionMessages.DeleteBreakpointsOperationName;
            DeleteMarkersOperation deleteMarkerOperation = new DeleteMarkersOperation(markers, operationName);
            deleteMarkerOperation.removeContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
            deleteMarkerOperation.addContext(DebugUITools.getBreakpointsUndoContext());
            IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            try {
                operationHistory.execute((IUndoableOperation)deleteMarkerOperation, progressMonitor, context);
            }
            catch (ExecutionException e) {
                throw new CoreException(DebugUIPlugin.newErrorStatus("Exception while deleting breakpoint markers", e));
            }
        }
    }

    public static IAdaptable getPartDebugContext(IWorkbenchPartSite site) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        String id = null;
        String secondaryId = null;
        id = site.getId();
        if (site instanceof IViewSite) {
            secondaryId = ((IViewSite)site).getSecondaryId();
        }
        ISelection activeContext = service.getActiveContext(id, secondaryId);
        return DebugUITools.getDebugContextElementForSelection(activeContext);
    }

    public static void addPartDebugContextListener(IWorkbenchPartSite site, IDebugContextListener listener) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        String id = site.getId();
        String secondaryId = null;
        if (site instanceof IViewSite) {
            secondaryId = ((IViewSite)site).getSecondaryId();
        }
        service.addDebugContextListener(listener, id, secondaryId);
    }

    public static void removePartDebugContextListener(IWorkbenchPartSite site, IDebugContextListener listener) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        String id = site.getId();
        String secondaryId = null;
        if (site instanceof IViewSite) {
            secondaryId = ((IViewSite)site).getSecondaryId();
        }
        service.removeDebugContextListener(listener, id, secondaryId);
    }

    private static IAdaptable getDebugContextElementForSelection(ISelection activeContext) {
        Object firstElement;
        IStructuredSelection selection;
        if (activeContext instanceof IStructuredSelection && !(selection = (IStructuredSelection)activeContext).isEmpty() && (firstElement = selection.getFirstElement()) instanceof IAdaptable) {
            return (IAdaptable)firstElement;
        }
        return null;
    }

    public static IResource getSelectedResource() {
        return SelectedResourceManager.getDefault().getSelectedResource();
    }

    public static IProcess getCurrentProcess() {
        ILaunch[] launches;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null && (launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()).length > 0) {
            context = launches[launches.length - 1];
        }
        if (context instanceof IDebugElement) {
            return ((IDebugElement)context).getDebugTarget().getProcess();
        }
        if (context instanceof IProcess) {
            return (IProcess)context;
        }
        if (context instanceof ILaunch) {
            IProcess process;
            ILaunch launch = (ILaunch)context;
            IDebugTarget target = launch.getDebugTarget();
            if (target != null && (process = target.getProcess()) != null) {
                return process;
            }
            IProcess[] ps = launch.getProcesses();
            if (ps.length > 0) {
                return ps[ps.length - 1];
            }
        }
        if (context != null) {
            return (IProcess)context.getAdapter(IProcess.class);
        }
        return null;
    }

    @Deprecated
    public static int openLaunchConfigurationDialog(Shell shell, IStructuredSelection selection, String mode) {
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        int i = 0;
        while (i < groups.length) {
            ILaunchGroup group = groups[i];
            if (group.getMode().equals(mode) && group.getCategory() == null) {
                return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, group.getIdentifier());
            }
            ++i;
        }
        return 1;
    }

    public static int openLaunchConfigurationDialogOnGroup(Shell shell, IStructuredSelection selection, String groupIdentifier) {
        return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, groupIdentifier, null);
    }

    public static int openLaunchConfigurationDialogOnGroup(final Shell shell, final IStructuredSelection selection, final String groupIdentifier, final IStatus status) {
        final int[] result = new int[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LaunchConfigurationsDialog dialog = (LaunchConfigurationsDialog)LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
                if (dialog != null) {
                    dialog.setInitialSelection(selection);
                    dialog.doInitialTreeSelection();
                    if (status != null) {
                        dialog.handleStatus(status);
                    }
                    result[0] = 0;
                } else {
                    LaunchGroupExtension ext = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
                    if (ext != null) {
                        dialog = new LaunchConfigurationsDialog(shell, ext);
                        dialog.setOpenMode(3);
                        dialog.setInitialSelection(selection);
                        dialog.setInitialStatus(status);
                        result[0] = dialog.open();
                    } else {
                        result[0] = 1;
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return result[0];
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier) {
        return DebugUITools.openLaunchConfigurationPropertiesDialog(shell, configuration, groupIdentifier, null);
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationPropertiesDialog dialog = new LaunchConfigurationPropertiesDialog(shell, configuration, group);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    public static int openLaunchConfigurationDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationDialog dialog = new LaunchConfigurationDialog(shell, configuration, group);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    @Deprecated
    public static boolean saveAndBuildBeforeLaunch() {
        return DebugUIPlugin.saveAndBuild();
    }

    @Deprecated
    public static boolean saveBeforeLaunch() {
        return DebugUIPlugin.preLaunchSave();
    }

    public static void launch(ILaunchConfiguration configuration, String mode) {
        DebugUITools.launch(configuration, mode, DebugUITools.findToggleLaunchForConfig(configuration, mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeLaunchToggleTerminate(Object data, Object isShift) {
        HashMap<Object, Object> hashMap = fgLaunchToggleTerminateMap;
        synchronized (hashMap) {
            fgLaunchToggleTerminateMap.put(data, isShift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLaunchToggleTerminate(Object data) {
        HashMap<Object, Object> hashMap = fgLaunchToggleTerminateMap;
        synchronized (hashMap) {
            if (fgLaunchToggleTerminateMap.containsKey(data)) {
                fgLaunchToggleTerminateMap.remove(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isShiftTerminateLaunch(Object data) {
        Object value;
        HashMap<Object, Object> hashMap = fgLaunchToggleTerminateMap;
        synchronized (hashMap) {
            value = fgLaunchToggleTerminateMap.get(data);
        }
        if (value instanceof TerminateToggleValue) {
            return ((TerminateToggleValue)value).isShift();
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getToggleTerminateValue(Object data) {
        Object value;
        HashMap<Object, Object> hashMap = fgLaunchToggleTerminateMap;
        synchronized (hashMap) {
            value = fgLaunchToggleTerminateMap.get(data);
        }
        return value;
    }

    private static boolean findToggleLaunchForConfig(ILaunchConfiguration configuration, String mode) {
        ILaunch[] launches;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch iLaunch = iLaunchArray[n2];
            if (configuration.contentsEqual(iLaunch.getLaunchConfiguration())) {
                try {
                    IResource[] configResource = iLaunch.getLaunchConfiguration().getMappedResources();
                    if (configResource != null && configResource.length == 1) {
                        for (Object key : fgLaunchToggleTerminateMap.keySet()) {
                            Object lastSegmentObj;
                            IResource selectedResource;
                            TreeSelection selection;
                            TreePath[] treePath;
                            IEditorInput input;
                            if (!(key instanceof IEditorPart ? ((IResource)(input = ((IEditorPart)key).getEditorInput()).getAdapter(IResource.class)).equals((Object)configResource[0]) : key instanceof TreeSelection && (treePath = (selection = (TreeSelection)key).getPaths()) != null && treePath.length == 1 && (selectedResource = (IResource)((IAdaptable)(lastSegmentObj = treePath[0].getLastSegment())).getAdapter(IResource.class)) != null && selectedResource.equals((Object)configResource[0]))) continue;
                            return DebugUITools.isShiftTerminateLaunch(key);
                        }
                    } else {
                        for (Object key : fgLaunchToggleTerminateMap.keySet()) {
                            List<ILaunchConfiguration> configs;
                            Object toggleValue;
                            if (!(key instanceof IStructuredSelection) || !((toggleValue = DebugUITools.getToggleTerminateValue(key)) instanceof TerminateToggleValue)) continue;
                            LaunchingResourceManager lrm = DebugUIPlugin.getDefault().getLaunchingResourceManager();
                            ArrayList<LaunchShortcutExtension> shortcuts = new ArrayList<LaunchShortcutExtension>();
                            LaunchShortcutExtension shortcut = ((TerminateToggleValue)toggleValue).getShortcut();
                            shortcuts.add(shortcut);
                            IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
                            if (resource == null) {
                                resource = lrm.getLaunchableResource(shortcuts, (IStructuredSelection)key);
                            }
                            if (!(configs = lrm.getParticipatingLaunchConfigurations((IStructuredSelection)key, resource, shortcuts, mode)).contains(configuration)) continue;
                            return ((TerminateToggleValue)toggleValue).isShift();
                        }
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
            ++n2;
        }
        return false;
    }

    public static void reLaunch(ILaunchConfiguration configuration, String mode) {
        boolean launchInBackground = true;
        try {
            launchInBackground = configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        if (launchInBackground) {
            DebugUIPlugin.launchInBackground(configuration, mode);
        } else {
            DebugUIPlugin.launchInForeground(configuration, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(ILaunchConfiguration configuration, String mode, boolean isShift) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.RelaunchAndTerminateLaunchAction") != isShift) {
            ILaunch[] launches;
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch iLaunch = iLaunchArray[n2];
                if (configuration.contentsEqual(iLaunch.getLaunchConfiguration())) {
                    Set<ILaunch> set = fgLaunchList;
                    synchronized (set) {
                        fgLaunchList.add(iLaunch);
                    }
                }
                ++n2;
            }
        }
        if (!fgLaunchList.isEmpty()) {
            Thread t = new Thread(fgLaunchTerminate);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e1) {
                DebugUIPlugin.log(e1);
                return;
            }
        }
        boolean launchInBackground = true;
        try {
            launchInBackground = configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        if (launchInBackground) {
            DebugUIPlugin.launchInBackground(configuration, mode);
        } else {
            DebugUIPlugin.launchInForeground(configuration, mode);
        }
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
    }

    public static String getLaunchPerspective(ILaunchConfigurationType type, String mode) {
        return DebugUIPlugin.getDefault().getPerspectiveManager().getLaunchPerspective(type, mode);
    }

    public static String getLaunchPerspective(ILaunchConfigurationType type, ILaunchDelegate delegate, Set<String> modes) {
        return DebugUIPlugin.getDefault().getPerspectiveManager().getLaunchPerspective(type, modes, delegate);
    }

    public static void setLaunchPerspective(ILaunchConfigurationType type, String mode, String perspective) {
        DebugUIPlugin.getDefault().getPerspectiveManager().setLaunchPerspective(type, mode, perspective);
    }

    public static void setLaunchPerspective(ILaunchConfigurationType type, ILaunchDelegate delegate, Set<String> modes, String perspectiveid) {
        DebugUIPlugin.getDefault().getPerspectiveManager().setLaunchPerspective(type, modes, delegate, perspectiveid);
    }

    public static boolean isPrivate(ILaunchConfiguration configuration) {
        return !LaunchConfigurationManager.isVisible(configuration);
    }

    public static void setUseStepFilters(boolean useStepFilters) {
        DebugPlugin.setUseStepFilters((boolean)useStepFilters);
    }

    public static boolean isUseStepFilters() {
        return DebugPlugin.isUseStepFilters();
    }

    public static IConsole getConsole(IProcess process) {
        return DebugUIPlugin.getDefault().getProcessConsoleManager().getConsole(process);
    }

    public static IConsole getConsole(IDebugElement element) {
        IProcess process = element.getDebugTarget().getProcess();
        if (process != null) {
            return DebugUITools.getConsole(process);
        }
        return null;
    }

    public static ILaunchGroup[] getLaunchGroups() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroups();
    }

    public static ILaunchConfiguration getLastLaunch(String groupId) {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch(groupId);
    }

    public static ILaunchGroup getLaunchGroup(ILaunchConfiguration configuration, String mode) {
        try {
            return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configuration.getType(), mode);
        }
        catch (CoreException ce) {
            return null;
        }
    }

    public static ISourceLookupResult lookupSource(Object artifact, ISourceLocator locator) {
        return SourceLookupFacility.getDefault().lookup(artifact, locator, false);
    }

    public static void displaySource(ISourceLookupResult result, IWorkbenchPage page) {
        SourceLookupFacility.getDefault().display(result, page);
    }

    public static IMemoryRenderingManager getMemoryRenderingManager() {
        return MemoryRenderingManager.getDefault();
    }

    public static Image getSourceContainerImage(String id) {
        return SourceLookupUIUtils.getSourceContainerImage(id);
    }

    public static ISourceContainerBrowser getSourceContainerBrowser(String id) {
        return SourceLookupUIUtils.getSourceContainerBrowser(id);
    }

    public static Color getPreferenceColor(String id) {
        return DebugUIPlugin.getPreferenceColor(id);
    }

    public static IDebugContextManager getDebugContextManager() {
        return DebugContextManager.getDefault();
    }

    public static ISelection getDebugContextForEvent(ExecutionEvent event) {
        Object o = HandlerUtil.getVariable((ExecutionEvent)event, (String)"debugContext");
        if (o instanceof ISelection) {
            return (ISelection)o;
        }
        return null;
    }

    public static ISelection getDebugContextForEventChecked(ExecutionEvent event) throws ExecutionException {
        Object o = HandlerUtil.getVariableChecked((ExecutionEvent)event, (String)"debugContext");
        if (!(o instanceof ISelection)) {
            throw new ExecutionException("Incorrect type for debugContext found while executing " + event.getCommand().getId() + ", expected " + ISelection.class.getName() + " found " + o.getClass().getName());
        }
        return (ISelection)o;
    }

    public static IToggleBreakpointsTargetManager getToggleBreakpointsTargetManager() {
        return ToggleBreakpointsTargetManager.getDefault();
    }
}

