/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;

public class QualificationHelpers {
    public static final int QULIFIERS_INDEX = 0;
    public static final int SIMPLE_NAMES_INDEX = 1;

    public static char[] createFullyQualifiedName(char[] qualification, char[] simpleName) {
        char[] fullTypeName = null;
        if (simpleName != null && simpleName.length > 0) {
            fullTypeName = qualification != null && qualification.length > 0 ? CharOperation.concat(qualification, simpleName, '.') : simpleName;
        }
        return fullTypeName;
    }

    public static char[][] createFullyQualifiedNames(char[][] qualifications, char[][] simpleNames) {
        char[][] fullTypeNames = null;
        if (simpleNames != null) {
            fullTypeNames = new char[simpleNames.length][];
            int i = 0;
            while (i < fullTypeNames.length) {
                fullTypeNames[i] = qualifications != null && qualifications.length > i ? QualificationHelpers.createFullyQualifiedName(qualifications[i], simpleNames[i]) : simpleNames[i];
                ++i;
            }
        }
        return fullTypeNames;
    }

    public static char[][] seperateFullyQualifedName(char[] fullyQualifiedName) {
        char[][] seperatedTypeName = new char[2][];
        if (fullyQualifiedName != null && fullyQualifiedName.length > 0) {
            int lastIndexOfDot = CharOperation.lastIndexOf('.', fullyQualifiedName);
            if (lastIndexOfDot != -1) {
                seperatedTypeName[0] = CharOperation.subarray(fullyQualifiedName, 0, lastIndexOfDot);
                seperatedTypeName[1] = CharOperation.subarray(fullyQualifiedName, lastIndexOfDot + 1, -1);
            } else {
                seperatedTypeName[0] = null;
                seperatedTypeName[1] = fullyQualifiedName;
            }
        }
        return seperatedTypeName;
    }

    public static char[][][] seperateFullyQualifiednames(String[] fullyQualifiedNames, int minLength) {
        return QualificationHelpers.seperateFullyQualifiedNames(QualificationHelpers.stringArrayToCharArray(fullyQualifiedNames), minLength);
    }

    public static char[][][] seperateFullyQualifiedNames(char[] fullyQualifiedNames, int minLength) {
        char[][] names = CharOperation.splitOn(',', fullyQualifiedNames);
        return QualificationHelpers.seperateFullyQualifiedNames(names, minLength);
    }

    public static char[][][] seperateFullyQualifiedNames(char[][] fullyQualifiedNames, int minLength) {
        char[][][] seperatedTypeNames = new char[2][][];
        if (fullyQualifiedNames.length > 0) {
            int length = minLength > fullyQualifiedNames.length ? minLength : fullyQualifiedNames.length;
            seperatedTypeNames[0] = new char[length][];
            seperatedTypeNames[1] = new char[length][];
            int i = 0;
            while (i < fullyQualifiedNames.length) {
                char[][] seperatedTypeName = QualificationHelpers.seperateFullyQualifedName(fullyQualifiedNames[i]);
                seperatedTypeNames[0][i] = seperatedTypeName[0];
                seperatedTypeNames[1][i] = seperatedTypeName[1];
                if (seperatedTypeNames[0][i] != null && seperatedTypeNames[0][i].length > 0) {
                    try {
                        seperatedTypeNames[0][i] = Signature.toCharArray(seperatedTypeNames[0][i]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (seperatedTypeNames[1][i] != null && seperatedTypeNames[1][i].length > 0) {
                    try {
                        seperatedTypeNames[1][i] = Signature.toCharArray(seperatedTypeNames[1][i]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        } else if (minLength > 0) {
            seperatedTypeNames[0] = new char[minLength][];
            seperatedTypeNames[1] = new char[minLength][];
        } else {
            seperatedTypeNames[0] = null;
            seperatedTypeNames[1] = null;
        }
        return seperatedTypeNames;
    }

    public static char[][] stringArrayToCharArray(String[] array) {
        char[][] results = null;
        if (array != null) {
            results = new char[array.length][];
            int i = 0;
            while (i < array.length) {
                results[i] = array[i].toCharArray();
                ++i;
            }
        }
        return results;
    }
}

