/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportJob;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportJobReportDialog;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportRootWizardPage;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;

public class SmartImportWizard
extends Wizard
implements IImportWizard {
    private File initialSelection;
    private Set<IWorkingSet> initialWorkingSets = new HashSet<IWorkingSet>();
    private SmartImportRootWizardPage projectRootPage;
    private SmartImportJob easymportJob;
    private File directoryToImport;

    public SmartImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings == null) {
            dialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
            this.setDialogSettings(dialogSettings);
        }
        this.setWindowTitle(DataTransferMessages.SmartImportWizardPage_importProjectsInFolderTitle);
        this.setDefaultPageImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/newprj_wiz.png"));
    }

    public void setInitialImportSource(File directoryOrArchive) {
        this.initialSelection = directoryOrArchive;
    }

    public void setInitialWorkingSets(Set<IWorkingSet> workingSets) {
        this.initialWorkingSets = workingSets;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null) {
            for (Object item : selection.toList()) {
                File asFile = SmartImportWizard.toFile(item);
                if (asFile != null && this.initialSelection == null) {
                    this.initialSelection = asFile;
                    continue;
                }
                IWorkingSet asWorkingSet = (IWorkingSet)Adapters.adapt(item, IWorkingSet.class);
                if (asWorkingSet == null) continue;
                this.initialWorkingSets.add(asWorkingSet);
            }
        }
    }

    public static File toFile(Object o) {
        IResource resource;
        if (o instanceof File) {
            return (File)o;
        }
        if (o instanceof IResource) {
            IPath location = ((IResource)o).getLocation();
            return location == null ? null : location.toFile();
        }
        if (o instanceof IAdaptable && (resource = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
            IPath location = resource.getLocation();
            return location == null ? null : location.toFile();
        }
        return null;
    }

    public static String toAbsolutePath(Object o) {
        File file = SmartImportWizard.toFile(o);
        return file == null ? "" : file.getAbsolutePath();
    }

    public void addPages() {
        this.projectRootPage = new SmartImportRootWizardPage(this, this.initialSelection, this.initialWorkingSets);
        this.addPage((IWizardPage)this.projectRootPage);
    }

    public boolean performFinish() {
        String[] previousProposals = this.getDialogSettings().getArray(SmartImportRootWizardPage.IMPORTED_SOURCES);
        if (previousProposals == null) {
            previousProposals = new String[]{};
        }
        if (!Arrays.asList(previousProposals).contains(this.projectRootPage.getSelectedRoot().getAbsolutePath())) {
            String[] newProposals = new String[previousProposals.length + 1];
            newProposals[0] = this.projectRootPage.getSelectedRoot().getAbsolutePath();
            System.arraycopy(previousProposals, 0, newProposals, 1, previousProposals.length);
            this.getDialogSettings().put(SmartImportRootWizardPage.IMPORTED_SOURCES, newProposals);
        }
        SmartImportJob job = this.getImportJob();
        if (this.projectRootPage.isDetectNestedProject() || this.projectRootPage.isConfigureProjects()) {
            SmartImportJobReportDialog dialog = new SmartImportJobReportDialog(null);
            dialog.setBlockOnOpen(false);
            this.getContainer().getShell().setEnabled(false);
            dialog.show(job, this.getShell());
        }
        job.schedule();
        return true;
    }

    public SmartImportJob getImportJob() {
        File root = this.projectRootPage.getSelectedRoot();
        if (root == null) {
            return null;
        }
        if (root.isDirectory()) {
            this.directoryToImport = root;
        } else if (SmartImportWizard.isValidArchive(root)) {
            this.directoryToImport = SmartImportWizard.getExpandDirectory(root);
            if (!this.directoryToImport.isDirectory()) {
                throw new IllegalArgumentException("Archive wasn't expanded first");
            }
        } else {
            return null;
        }
        if (this.easymportJob == null || !SmartImportWizard.matchesPage(this.easymportJob, this.projectRootPage)) {
            this.easymportJob = new SmartImportJob(this.directoryToImport, this.projectRootPage.getSelectedWorkingSets(), this.projectRootPage.isConfigureProjects(), this.projectRootPage.isDetectNestedProject());
        }
        if (this.easymportJob != null) {
            this.easymportJob.setWorkingSets(this.projectRootPage.getSelectedWorkingSets());
        }
        return this.easymportJob;
    }

    static boolean isValidArchive(File file) {
        return ArchiveFileManipulations.isZipFile(file.getAbsolutePath()) || ArchiveFileManipulations.isTarFile(file.getAbsolutePath());
    }

    void expandArchive(File archive, IProgressMonitor monitor) throws InvocationTargetException, OperationCanceledException {
        if (!SmartImportWizard.isValidArchive(archive)) {
            throw new IllegalArgumentException("Input must be an archive");
        }
        this.directoryToImport = SmartImportWizard.getExpandDirectory(archive);
        ExpandArchiveIntoFilesystemOperation expandOperation = new ExpandArchiveIntoFilesystemOperation(archive, this.directoryToImport);
        expandOperation.run(monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    static File getExpandDirectory(File archive) {
        if (!SmartImportWizard.isValidArchive(archive)) {
            throw new IllegalArgumentException("Input must be an archive");
        }
        return new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), String.valueOf(archive.getName()) + "_expanded");
    }

    private static boolean matchesPage(SmartImportJob job, SmartImportRootWizardPage page) {
        File pageRoot;
        boolean sameSource;
        File jobRoot = job.getRoot().getAbsoluteFile();
        boolean bl = sameSource = jobRoot.equals(pageRoot = page.getSelectedRoot().getAbsoluteFile()) || SmartImportWizard.isValidArchive(pageRoot) && SmartImportWizard.getExpandDirectory(pageRoot).getAbsoluteFile().equals(jobRoot);
        return sameSource && job.isDetectNestedProjects() == page.isDetectNestedProject() && job.isConfigureProjects() == page.isConfigureProjects();
    }

    private static final class ExpandArchiveIntoFilesystemOperation
    implements IRunnableWithProgress {
        private File archive;
        private File destination;

        private ExpandArchiveIntoFilesystemOperation(File archive, File destination) {
            this.archive = archive;
            this.destination = destination;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, OperationCanceledException {
            monitor.beginTask(NLS.bind((String)DataTransferMessages.SmartImportWizardPage_expandingArchive, (Object)this.archive.getName(), (Object)this.destination.getName()), 1);
            TarFile tarFile = null;
            ZipFile zipFile = null;
            ILeveledImportStructureProvider importStructureProvider = null;
            try {
                try {
                    if (ArchiveFileManipulations.isTarFile(this.archive.getAbsolutePath())) {
                        tarFile = new TarFile(this.archive);
                        importStructureProvider = new TarLeveledStructureProvider(tarFile);
                    } else if (ArchiveFileManipulations.isZipFile(this.archive.getAbsolutePath())) {
                        zipFile = new ZipFile(this.archive);
                        importStructureProvider = new ZipLeveledStructureProvider(zipFile);
                    }
                    LinkedList<Object> toProcess = new LinkedList<Object>();
                    toProcess.add(importStructureProvider.getRoot());
                    while (!toProcess.isEmpty()) {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        Object current = toProcess.pop();
                        String path = importStructureProvider.getFullPath(current);
                        File toCreate = null;
                        toCreate = path.equals("/") ? this.destination : new File(this.destination, path);
                        if (importStructureProvider.isFolder(current)) {
                            toCreate.mkdirs();
                        } else {
                            Throwable throwable = null;
                            Object var10_12 = null;
                            try (InputStream content = importStructureProvider.getContents(current);){
                                if (content != null) {
                                    Files.copy(content, toCreate.toPath(), new CopyOption[0]);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        List children = importStructureProvider.getChildren(current);
                        if (children == null) continue;
                        toProcess.addAll(children);
                    }
                    monitor.worked(1);
                    monitor.done();
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
            }
            finally {
                if (importStructureProvider != null) {
                    importStructureProvider.closeArchive();
                }
                if (tarFile != null) {
                    try {
                        tarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

