/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class MarkerUtil {
    private MarkerUtil() {
    }

    static int getCharEnd(IMarker marker) {
        return marker.getAttribute("charEnd", -1);
    }

    static int getCharStart(IMarker marker) {
        return marker.getAttribute("charStart", -1);
    }

    static String getContainerName(IMarker marker) {
        IPath path = marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int len = 0;
        int i = 0;
        while (i < n) {
            len += path.segment(i).length();
            ++i;
        }
        if (n > 1) {
            len += n - 1;
        }
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < n) {
            if (i2 != 0) {
                sb.append('/');
            }
            sb.append(path.segment(i2));
            ++i2;
        }
        return sb.toString();
    }

    static int getLineNumber(IMarker marker) {
        return marker.getAttribute("lineNumber", -1);
    }

    static String getLocation(IMarker marker) {
        return marker.getAttribute("location", "");
    }

    static String getMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }

    static int getNumericValue(String value) {
        boolean negative = false;
        int i = 0;
        int len = value.length();
        if (i < len && value.charAt(i) == '#') {
            ++i;
        }
        if (i < len && value.charAt(i) == '-') {
            negative = true;
            ++i;
        }
        int result = 0;
        while (i < len) {
            int digit;
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                return result;
            }
            result = result * 10 + digit;
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    static String getResourceName(IMarker marker) {
        return marker.getResource().getName();
    }

    static String getCreationTime(IMarker marker) {
        try {
            return DateFormat.getDateTimeInstance((int)1, (int)2).format(new Date(marker.getCreationTime()));
        }
        catch (CoreException e) {
            return null;
        }
    }
}

