/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ModelEnablementPreferencePage;
import org.eclipse.team.internal.ui.mapping.ModelSynchronizePage;
import org.eclipse.team.internal.ui.preferences.SyncViewerPreferencePage;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.IRefreshable;
import org.eclipse.team.internal.ui.synchronize.RefreshModelParticipantJob;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicy;
import org.eclipse.team.internal.ui.synchronize.StartupPreferencePage;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.progress.IProgressConstants2;

public class ModelSynchronizeParticipant
extends AbstractSynchronizeParticipant {
    public static final String P_VISIBLE_MODEL_PROVIDER = "org.eclipse.team.ui.activeModelProvider";
    public static final String ALL_MODEL_PROVIDERS_VISIBLE = "org.eclipse.team.ui.activeModelProvider";
    public static final String PROP_ENABLED_MODEL_PROVIDERS = "org.eclipse.team.ui.ENABLED_MODEL_PROVIDERS";
    public static final String PROP_ACTIVE_SAVEABLE = "org.eclipse.team.ui.ACTIVE_SAVEABLE";
    public static final String PROP_DIRTY = "org.eclipse.team.ui.DIRTY";
    private static final String CTX_PARTICIPANT_SETTINGS = "org.eclipse.team.ui.MODEL_PARTICIPANT_SETTINGS";
    private static final String CTX_REFRESH_SCHEDULE_SETTINGS = "org.eclipse.team.ui.MODEL_PARTICIPANT_REFRESH_SCHEDULE";
    private static final String CTX_DESCRIPTION = "org.eclipse.team.ui.MODEL_PARTICIPANT_DESCRIPTION";
    private static final String CTX_PARTICIPANT_MAPPINGS = "org.eclipse.team.ui.MODEL_PARTICIPANT_MAPPINGS";
    private static final String CTX_MODEL_PROVIDER_ID = "modelProviderId";
    private static final String CTX_MODEL_PROVIDER_MAPPINGS = "mappings";
    private static final String CTX_STARTUP_ACTION = "startupAction";
    private SynchronizationContext context;
    private boolean mergingEnabled = true;
    private SubscriberRefreshSchedule refreshSchedule;
    private String description;
    private SaveableComparison activeSaveable;
    private PreferenceStore preferences = new PreferenceStore(){

        public void save() throws IOException {
        }
    };
    private IPropertyListener dirtyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source instanceof SaveableComparison && propId == 257) {
                SaveableComparison scm = (SaveableComparison)((Object)source);
                boolean isDirty = scm.isDirty();
                ModelSynchronizeParticipant.this.firePropertyChange(ModelSynchronizeParticipant.this, ModelSynchronizeParticipant.PROP_DIRTY, !isDirty, isDirty);
            }
        }
    };

    public static ModelSynchronizeParticipant createParticipant(SynchronizationContext context, String name) {
        return new ModelSynchronizeParticipant(context, name);
    }

    private ModelSynchronizeParticipant(SynchronizationContext context, String name) {
        this.initializeContext(context);
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor("org.eclipse.team.ui.synchronization_context_synchronize_participant"));
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        this.setName(name);
        this.refreshSchedule = new SubscriberRefreshSchedule(this.createRefreshable());
    }

    public ModelSynchronizeParticipant(SynchronizationContext context) {
        this.initializeContext(context);
        this.refreshSchedule = new SubscriberRefreshSchedule(this.createRefreshable());
    }

    public ModelSynchronizeParticipant() {
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (this.description == null) {
            this.description = Utils.getScopeDescription(this.getContext().getScope());
        }
        return NLS.bind((String)TeamUIMessages.SubscriberParticipant_namePattern, (Object[])new String[]{name, this.description});
    }

    protected final String getShortName() {
        return super.getName();
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        if (this.isMergingEnabled()) {
            configuration.addMenuGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "merge");
            configuration.addActionContribution(this.createMergeActionGroup());
        }
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        configuration.setProperty("org.eclipse.team.ui.synchronizationContext", this.getContext());
        configuration.setProperty("org.eclipse.team.ui.synchronizationScope", this.getContext().getScope());
        if (this.getHandler() != null) {
            configuration.setProperty("org.eclipse.team.ui.startupPreferences", this.preferences);
        }
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new ModelSynchronizeParticipantActionGroup();
    }

    @Override
    public final IPageBookViewPage createPage(ISynchronizePageConfiguration configuration) {
        return new ModelSynchronizePage(configuration);
    }

    @Override
    public void run(IWorkbenchPart part) {
        this.refresh((IWorkbenchSite)(part != null ? part.getSite() : null), this.context.getScope().getMappings());
    }

    public final void refresh(IWorkbenchSite site, ResourceMapping[] mappings) {
        RefreshUserNotificationPolicy listener = new RefreshUserNotificationPolicy(this);
        this.internalRefresh(mappings, null, null, site, listener);
    }

    @Override
    public void dispose() {
        this.context.dispose();
        Job.getJobManager().cancel((Object)this);
        this.refreshSchedule.dispose();
    }

    protected void initializeContext(SynchronizationContext context) {
        this.context = context;
        this.mergingEnabled = context instanceof IMergeContext;
        SubscriberDiffTreeEventHandler handler = this.getHandler();
        if (handler != null) {
            this.preferences.setDefault(CTX_STARTUP_ACTION, "none");
            if (this.isSynchronizeOnStartup()) {
                this.run(null);
            } else if (this.isPopulateOnStartup()) {
                handler.initializeIfNeeded();
            }
        }
    }

    private boolean isPopulateOnStartup() {
        String pref = this.preferences.getString(CTX_STARTUP_ACTION);
        return pref != null && pref.equals("populate");
    }

    private boolean isSynchronizeOnStartup() {
        String pref = this.preferences.getString(CTX_STARTUP_ACTION);
        return pref != null && pref.equals("synchronize");
    }

    public ISynchronizationContext getContext() {
        return this.context;
    }

    public ICompareInput asCompareInput(Object object) {
        if (object instanceof ICompareInput) {
            return (ICompareInput)object;
        }
        ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(object);
        if (adapter != null) {
            return adapter.asCompareInput(this.getContext(), object);
        }
        return null;
    }

    public boolean hasCompareInputFor(Object object) {
        ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(object);
        if (adapter != null) {
            return adapter.hasCompareInput(this.getContext(), object);
        }
        return false;
    }

    public boolean isMergingEnabled() {
        return this.mergingEnabled;
    }

    public void setMergingEnabled(boolean mergingEnabled) {
        this.mergingEnabled = mergingEnabled;
    }

    private void internalRefresh(ResourceMapping[] mappings, String jobName, String taskName, IWorkbenchSite site, IRefreshSubscriberListener listener) {
        if (jobName == null) {
            jobName = this.getShortTaskName();
        }
        if (taskName == null) {
            taskName = this.getLongTaskName(mappings);
        }
        Job.getJobManager().cancel((Object)this);
        RefreshModelParticipantJob job = new RefreshModelParticipantJob(this, jobName, taskName, mappings, listener);
        job.setUser(true);
        job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, Boolean.TRUE);
        Utils.schedule(job, site);
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant", this.getId());
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant_sec_id", this.getSecondaryId());
    }

    protected String getShortTaskName() {
        return NLS.bind((String)TeamUIMessages.Participant_synchronizingDetails, (Object)this.getShortName());
    }

    protected String getLongTaskName(ResourceMapping[] mappings) {
        int mappingCount;
        if (mappings == null) {
            mappings = this.getContext().getScope().getMappings();
        }
        if ((mappingCount = mappings.length) == this.getContext().getScope().getMappings().length) {
            mappings = this.getContext().getScope().getInputMappings();
            mappingCount = mappings.length;
        }
        if (mappingCount == 1) {
            return NLS.bind((String)TeamUIMessages.Participant_synchronizingMoreDetails, (Object[])new String[]{this.getShortName(), Utils.getLabel(mappings[0])});
        }
        return NLS.bind((String)TeamUIMessages.Participant_synchronizingResources, (Object[])new String[]{this.getShortName(), Integer.toString(mappingCount)});
    }

    private IRefreshable createRefreshable() {
        return new IRefreshable(){

            @Override
            public RefreshParticipantJob createJob(String interval) {
                String jobName = NLS.bind((String)TeamUIMessages.RefreshSchedule_15, (Object[])new String[]{ModelSynchronizeParticipant.this.getName(), interval});
                return new RefreshModelParticipantJob(ModelSynchronizeParticipant.this, jobName, jobName, ModelSynchronizeParticipant.this.context.getScope().getMappings(), new RefreshUserNotificationPolicy(ModelSynchronizeParticipant.this));
            }

            @Override
            public ISynchronizeParticipant getParticipant() {
                return ModelSynchronizeParticipant.this;
            }

            @Override
            public void setRefreshSchedule(SubscriberRefreshSchedule schedule) {
                ModelSynchronizeParticipant.this.setRefreshSchedule(schedule);
            }

            @Override
            public SubscriberRefreshSchedule getRefreshSchedule() {
                return ModelSynchronizeParticipant.this.refreshSchedule;
            }
        };
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRefreshable.class && this.refreshSchedule != null) {
            return this.refreshSchedule.getRefreshable();
        }
        if (adapter == SubscriberRefreshSchedule.class) {
            return this.refreshSchedule;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento settings = memento.createChild(CTX_PARTICIPANT_SETTINGS);
        if (this.description != null) {
            settings.putString(CTX_DESCRIPTION, this.description);
        }
        this.refreshSchedule.saveState(settings.createChild(CTX_REFRESH_SCHEDULE_SETTINGS));
        this.saveMappings(settings);
        settings.putString(CTX_STARTUP_ACTION, this.preferences.getString(CTX_STARTUP_ACTION));
    }

    private void saveMappings(IMemento settings) {
        ISynchronizationScope inputScope = this.getContext().getScope().asInputScope();
        ModelProvider[] providers = inputScope.getModelProviders();
        int i = 0;
        while (i < providers.length) {
            ModelProvider provider = providers[i];
            ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(provider);
            if (adapter != null) {
                IMemento child = settings.createChild(CTX_PARTICIPANT_MAPPINGS);
                String id = provider.getDescriptor().getId();
                child.putString(CTX_MODEL_PROVIDER_ID, id);
                adapter.save(inputScope.getMappings(id), child.createChild(CTX_MODEL_PROVIDER_MAPPINGS));
            }
            ++i;
        }
    }

    @Override
    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        if (memento != null) {
            ResourceMapping[] mappings;
            IMemento settings = memento.getChild(CTX_PARTICIPANT_SETTINGS);
            String startupAction = settings.getString(CTX_STARTUP_ACTION);
            if (startupAction != null) {
                this.preferences.putValue(CTX_STARTUP_ACTION, startupAction);
            }
            if ((mappings = this.loadMappings(settings)).length == 0) {
                throw new PartInitException(NLS.bind((String)TeamUIMessages.ModelSynchronizeParticipant_0, (Object)this.getId()));
            }
            this.initializeContext(mappings);
            if (settings != null) {
                SubscriberRefreshSchedule schedule = SubscriberRefreshSchedule.init(settings.getChild(CTX_REFRESH_SCHEDULE_SETTINGS), this.createRefreshable());
                this.description = settings.getString(CTX_DESCRIPTION);
                this.setRefreshSchedule(schedule);
                if (schedule.isEnabled()) {
                    schedule.startJob();
                }
            }
        }
    }

    private ResourceMapping[] loadMappings(IMemento settings) throws PartInitException {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IMemento[] children = settings.getChildren(CTX_PARTICIPANT_MAPPINGS);
        int i = 0;
        while (i < children.length) {
            IMemento memento = children[i];
            String id = memento.getString(CTX_MODEL_PROVIDER_ID);
            if (id != null) {
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
                try {
                    ModelProvider provider = desc.getModelProvider();
                    ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(provider);
                    if (adapter != null) {
                        ResourceMapping[] mappings = adapter.restore(memento.getChild(CTX_MODEL_PROVIDER_MAPPINGS));
                        int j = 0;
                        while (j < mappings.length) {
                            ResourceMapping mapping = mappings[j];
                            result.add(mapping);
                            ++j;
                        }
                    }
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    private void initializeContext(ResourceMapping[] mappings) throws PartInitException {
        try {
            ISynchronizationScopeManager manager = this.createScopeManager(mappings);
            MergeContext context = this.restoreContext(manager);
            this.initializeContext((SynchronizationContext)context);
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
            throw new PartInitException(e.getStatus());
        }
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) throws CoreException {
        throw new PartInitException(NLS.bind((String)TeamUIMessages.ModelSynchronizeParticipant_1, (Object)this.getId()));
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return new SynchronizationScopeManager(super.getName(), mappings, ResourceMappingContext.LOCAL_CONTEXT, true);
    }

    void setRefreshSchedule(SubscriberRefreshSchedule schedule) {
        if (this.refreshSchedule != schedule) {
            if (this.refreshSchedule != null) {
                this.refreshSchedule.dispose();
            }
            this.refreshSchedule = schedule;
        }
        this.firePropertyChange(this, "org.eclipse.team.schedule", schedule, schedule);
    }

    public SaveableComparison getActiveSaveable() {
        return this.activeSaveable;
    }

    public void setActiveSaveable(SaveableComparison activeSaveable) {
        boolean wasDirty = false;
        SaveableComparison oldModel = this.activeSaveable;
        if (oldModel != null) {
            oldModel.removePropertyListener(this.dirtyListener);
            wasDirty = oldModel.isDirty();
        }
        this.activeSaveable = activeSaveable;
        this.firePropertyChange(this, PROP_ACTIVE_SAVEABLE, (Object)oldModel, (Object)activeSaveable);
        boolean isDirty = false;
        if (activeSaveable != null) {
            activeSaveable.addPropertyListener(this.dirtyListener);
            isDirty = activeSaveable.isDirty();
        }
        if (isDirty != wasDirty) {
            this.firePropertyChange(this, PROP_DIRTY, wasDirty, isDirty);
        }
    }

    public boolean checkForBufferChange(Shell shell, ISynchronizationCompareInput input, boolean cancelAllowed, IProgressMonitor monitor) throws CoreException {
        SaveableComparison currentBuffer = this.getActiveSaveable();
        SaveableComparison targetBuffer = input.getSaveable();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ModelParticipantAction.handleTargetSaveableChange(shell, targetBuffer, currentBuffer, cancelAllowed, Policy.subMonitorFor(monitor, 10));
        }
        catch (InterruptedException e) {
            return false;
        }
        this.setActiveSaveable(targetBuffer);
        return true;
    }

    public ModelProvider[] getEnabledModelProviders() {
        return this.getContext().getScope().getModelProviders();
    }

    @Override
    public PreferencePage[] getPreferencePages() {
        ArrayList<Object> pages = new ArrayList<Object>();
        SyncViewerPreferencePage syncViewerPreferencePage = new SyncViewerPreferencePage();
        syncViewerPreferencePage.setIncludeDefaultLayout(false);
        pages.add(syncViewerPreferencePage);
        pages.add((Object)new ModelEnablementPreferencePage());
        ITeamContentProviderDescriptor[] descriptors = TeamUI.getTeamContentProviderManager().getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            ITeamContentProviderDescriptor descriptor = descriptors[i];
            if (this.isIncluded(descriptor)) {
                try {
                    PreferencePage page = (PreferencePage)descriptor.createPreferencePage();
                    if (page != null) {
                        pages.add(page);
                    }
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            ++i;
        }
        if (this.getHandler() != null) {
            pages.add((Object)new StartupPreferencePage((IPreferenceStore)this.preferences));
        }
        return pages.toArray(new PreferencePage[pages.size()]);
    }

    private boolean isIncluded(ITeamContentProviderDescriptor descriptor) {
        ModelProvider[] providers = this.getEnabledModelProviders();
        int i = 0;
        while (i < providers.length) {
            ModelProvider provider = providers[i];
            if (provider.getId().equals(descriptor.getModelProviderId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SubscriberDiffTreeEventHandler getHandler() {
        return (SubscriberDiffTreeEventHandler)Adapters.adapt((Object)this.context, SubscriberDiffTreeEventHandler.class);
    }
}

