/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.provisional.adapters.ICSSModelAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalArranger;
import org.eclipse.wst.html.core.internal.htmlcss.StyleAdapterFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistUtilities;

public class CSSCompletionProposalComputer
implements ICompletionProposalComputer {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        CSSProposalArranger arranger;
        IndexedRegion indexedNode;
        int documentPosition;
        ITextViewer viewer;
        block28: {
            IStructuredModel cssModel;
            block32: {
                ICSSModel cssModel2;
                ITextSelection selection;
                block31: {
                    block30: {
                        IDOMNode parent;
                        block29: {
                            viewer = context.getViewer();
                            documentPosition = context.getInvocationOffset();
                            indexedNode = ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)documentPosition);
                            IDOMNode xNode = null;
                            parent = null;
                            arranger = null;
                            selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
                            if (indexedNode instanceof IDOMNode) {
                                xNode = (IDOMNode)indexedNode;
                                parent = (IDOMNode)xNode.getParentNode();
                            }
                            if (xNode == null || !xNode.getNodeName().equalsIgnoreCase("STYLE")) break block29;
                            cssModel = CSSCompletionProposalComputer.getCSSModel(xNode);
                            if (cssModel != null) {
                                int offset = documentPosition;
                                int pos = 0;
                                IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(pos);
                                if (keyIndexedNode == null) {
                                    keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                                }
                                arranger = new CSSProposalArranger(pos, (ICSSNode)keyIndexedNode, offset, selection.getLength(), '\u0000');
                            }
                            break block28;
                        }
                        if (parent == null || !parent.getNodeName().equalsIgnoreCase("STYLE")) break block30;
                        cssModel = CSSCompletionProposalComputer.getCSSModel(parent);
                        if (cssModel != null) {
                            int offset = indexedNode.getStartOffset();
                            int pos = documentPosition - offset;
                            IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(pos);
                            if (keyIndexedNode == null) {
                                keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                            }
                            arranger = new CSSProposalArranger(pos, (ICSSNode)keyIndexedNode, offset, selection.getLength(), '\u0000');
                        }
                        break block28;
                    }
                    if (!(indexedNode instanceof IDOMNode)) break block31;
                    IDOMNode domNode = (IDOMNode)indexedNode;
                    IStructuredModel cssModel3 = CSSCompletionProposalComputer.getCSSModel(domNode);
                    if (cssModel3 != null) {
                        int textRegionStartOffset = CSSCompletionProposalComputer.getTextRegionStartOffset(domNode, documentPosition);
                        int pos = documentPosition - textRegionStartOffset;
                        char quote = '\u0000';
                        try {
                            quote = context.getDocument().get(textRegionStartOffset, 1).charAt(0);
                        }
                        catch (BadLocationException e) {
                            Logger.logException((String)"error getting quote character", (Throwable)e);
                        }
                        IndexedRegion cssIndexedNode = cssModel3.getIndexedRegion(pos);
                        if (cssIndexedNode == null) {
                            cssIndexedNode = (IndexedRegion)((ICSSModel)cssModel3).getDocument();
                        }
                        if (cssIndexedNode instanceof ICSSNode) {
                            arranger = new CSSProposalArranger(pos, (ICSSNode)cssIndexedNode, textRegionStartOffset, selection.getLength(), quote);
                        }
                    }
                    break block28;
                }
                if (!(indexedNode instanceof ICSSNode)) break block32;
                ICSSDocument cssdoc = ((ICSSNode)indexedNode).getOwnerDocument();
                if (cssdoc != null && (cssModel2 = cssdoc.getModel()) != null) {
                    IndexedRegion keyIndexedNode = cssModel2.getIndexedRegion(documentPosition);
                    if (keyIndexedNode == null) {
                        keyIndexedNode = (IndexedRegion)cssModel2.getDocument();
                    }
                    if (keyIndexedNode instanceof ICSSNode) {
                        arranger = new CSSProposalArranger(documentPosition, (ICSSNode)keyIndexedNode, 0, selection.getLength(), '\u0000');
                    }
                }
                break block28;
            }
            if (indexedNode != null || !ContentAssistUtils.isViewerEmpty((ITextViewer)viewer)) break block28;
            cssModel = null;
            try {
                cssModel = StructuredModelManager.getModelManager().getExistingModelForRead(viewer.getDocument());
                if (cssModel instanceof ICSSModel) {
                    IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(documentPosition);
                    if (keyIndexedNode == null) {
                        keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                    }
                    if (keyIndexedNode instanceof ICSSNode) {
                        arranger = new CSSProposalArranger(documentPosition, (ICSSNode)keyIndexedNode, 0, '\u0000');
                    }
                }
            }
            catch (Throwable pos) {
                Object keyIndexedNode = null;
                if (cssModel == null) throw pos;
                cssModel.releaseFromRead();
                throw pos;
            }
            {
                Object keyIndexedNode = null;
                if (cssModel == null) break block28;
            }
            cssModel.releaseFromRead();
        }
        ICompletionProposal[] proposals = new ICompletionProposal[]{};
        if (arranger == null) return Arrays.asList(proposals);
        proposals = arranger.getProposals();
        ICompletionProposal[] newfileproposals = new ICompletionProposal[]{};
        ICompletionProposal[] anyproposals = new ICompletionProposal[]{};
        ICompletionProposal endTag = XMLContentAssistUtilities.computeXMLEndTagProposal((ITextViewer)viewer, (int)documentPosition, (IndexedRegion)indexedNode, (String)"STYLE", (String)"icons/full/tobj16/tag-generic.png");
        int additionalLength = newfileproposals.length + anyproposals.length;
        int n = additionalLength = endTag != null ? ++additionalLength : additionalLength;
        if (additionalLength <= 0) return Arrays.asList(proposals);
        ICompletionProposal[] plusOnes = new ICompletionProposal[proposals.length + additionalLength];
        int appendPos = proposals.length;
        if (endTag != null) {
            System.arraycopy(proposals, 0, plusOnes, 1, proposals.length);
            plusOnes[0] = endTag;
            ++appendPos;
        } else {
            System.arraycopy(proposals, 0, plusOnes, 0, proposals.length);
        }
        int i = 0;
        while (true) {
            if (i >= newfileproposals.length) {
                appendPos += newfileproposals.length;
                break;
            }
            plusOnes[appendPos + i] = newfileproposals[i];
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= anyproposals.length) {
                proposals = plusOnes;
                return Arrays.asList(proposals);
            }
            plusOnes[appendPos + i] = anyproposals[i];
            ++i;
        }
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    private static IStructuredModel getCSSModel(IDOMNode element) {
        if (element == null) {
            return null;
        }
        INodeAdapter adapter = StyleAdapterFactory.getInstance().adapt((INodeNotifier)element);
        if (adapter == null || !(adapter instanceof ICSSModelAdapter)) {
            return null;
        }
        ICSSModelAdapter modelAdapter = (ICSSModelAdapter)adapter;
        return modelAdapter.getModel();
    }

    private static int getTextRegionStartOffset(IDOMNode domNode, int documentPosition) {
        IStructuredDocumentRegion structRegion = domNode.getFirstStructuredDocumentRegion();
        return structRegion.getStartOffset(structRegion.getRegionAtCharacterOffset(documentPosition));
    }
}

