/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.AllTopicsPart;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineResultSection;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.service.prefs.BackingStoreException;

public class SearchResultsPart
extends AbstractFormPart
implements IHelpPart {
    ReusableHelpPart parent;
    private Composite separator;
    private Composite container;
    private ScrolledForm innerForm;
    private String id;
    private Action showCategoriesAction;
    private Action showDescriptionAction;
    private ArrayList<EngineResultSection> results;
    private FormToolkit innerToolkit;

    public SearchResultsPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.innerToolkit = new FormToolkit(parent.getDisplay());
        this.innerToolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(toolkit.getHyperlinkGroup().getHyperlinkUnderlineMode());
        this.container = this.innerToolkit.createComposite(parent);
        this.container.setLayout((Layout)layout);
        this.separator = this.innerToolkit.createCompositeSeparator(this.container);
        this.separator.setVisible(false);
        GridData gd = new GridData(768);
        gd.heightHint = 1;
        this.separator.setLayoutData((Object)gd);
        this.innerForm = this.innerToolkit.createScrolledForm(this.container);
        this.innerForm.setDelayedReflow(true);
        this.innerForm.setLayoutData((Object)new GridData(1808));
        ScrollBar scrollBar = this.innerForm.getVerticalBar();
        scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchResultsPart.this.updateSeparatorVisibility();
            }
        });
        TableWrapLayout tlayout = new TableWrapLayout();
        tlayout.topMargin = 0;
        tlayout.bottomMargin = 0;
        this.innerForm.getBody().setLayout((Layout)tlayout);
        this.results = new ArrayList();
        this.contributeToToolBar(tbm);
    }

    void updateSeparatorVisibility() {
        ScrollBar scrollBar = this.innerForm.getVerticalBar();
        this.separator.setVisible(scrollBar.getSelection() > 0);
    }

    private void contributeToToolBar(IToolBarManager tbm) {
        boolean descOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "showSearchDescription", false, null);
        boolean showCategories = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "showSearchCategories", false, null);
        this.showCategoriesAction = new Action(){

            public void run() {
                SearchResultsPart.this.updateResultSections();
                IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
                pref.putBoolean("showSearchCategories", SearchResultsPart.this.showCategoriesAction.isChecked());
                try {
                    pref.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        };
        this.showCategoriesAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/showcat_co.gif"));
        this.showCategoriesAction.setChecked(showCategories);
        this.showCategoriesAction.setToolTipText(Messages.SearchResultsPart_showCategoriesAction_tooltip);
        this.showCategoriesAction.setId("categories");
        tbm.insertBefore("back", (IAction)this.showCategoriesAction);
        this.showDescriptionAction = new Action(){

            public void run() {
                SearchResultsPart.this.updateResultSections();
                IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
                pref.putBoolean("showSearchDescription", SearchResultsPart.this.showDescriptionAction.isChecked());
                try {
                    pref.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        };
        this.showDescriptionAction.setImageDescriptor(HelpUIResources.getImageDescriptor("elcl16/showdesc_co.gif"));
        this.showDescriptionAction.setChecked(descOn);
        this.showDescriptionAction.setToolTipText(Messages.SearchResultsPart_showDescriptionAction_tooltip);
        this.showDescriptionAction.setId("description");
        tbm.insertAfter("categories", (IAction)this.showDescriptionAction);
        tbm.insertAfter("description", (IContributionItem)new Separator());
    }

    public void dispose() {
        this.innerToolkit.dispose();
        super.dispose();
    }

    private void updateResultSections() {
        BusyIndicator.showWhile((Display)this.container.getDisplay(), () -> {
            int i = 0;
            while (i < this.results.size()) {
                EngineResultSection section = this.results.get(i);
                section.updateResults(false);
                ++i;
            }
            this.reflow();
        });
    }

    boolean getShowCategories() {
        return this.showCategoriesAction.isChecked();
    }

    boolean getShowDescription() {
        return this.showDescriptionAction.isChecked();
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        this.container.setVisible(visible);
    }

    void clearResults() {
        this.clearResultSections();
        this.separator.setVisible(false);
        this.reflow();
    }

    void clearResultSections() {
        int i = 0;
        while (i < this.results.size()) {
            EngineResultSection section = this.results.get(i);
            section.dispose();
            ++i;
        }
        this.results.clear();
    }

    void startNewSearch(String phrase, ArrayList<EngineDescriptor> eds) {
        EngineDescriptor localHelp = this.findLocalHelp(eds);
        if (localHelp != null) {
            this.add(localHelp);
        }
        int i = 0;
        while (i < eds.size()) {
            EngineDescriptor ed = eds.get(i);
            if (ed != localHelp) {
                this.add(ed);
            }
            ++i;
        }
        this.reflow();
    }

    private EngineDescriptor findLocalHelp(ArrayList<EngineDescriptor> eds) {
        int i = 0;
        while (i < eds.size()) {
            EngineDescriptor ed = eds.get(i);
            if (ed.getEngineTypeId().equals("org.eclipse.help.ui.localSearch")) {
                return ed;
            }
            ++i;
        }
        return null;
    }

    void completed() {
        int i = 0;
        while (i < this.results.size()) {
            EngineResultSection section = this.results.get(i);
            section.completed();
            ++i;
        }
    }

    void canceling() {
        int i = 0;
        while (i < this.results.size()) {
            EngineResultSection section = this.results.get(i);
            section.canceling();
            ++i;
        }
    }

    void doOpenLink(Object href) {
        String url = (String)href;
        if (url.startsWith("nw:")) {
            this.parent.showExternalURL(url.substring(3));
        } else {
            this.parent.showURL(url);
        }
    }

    void doCategoryLink(String href) {
        this.parent.showPage("all-topics-page");
        AllTopicsPart part = (AllTopicsPart)this.parent.findPart("topic-tree");
        if (part != null) {
            IToc[] tocs = HelpSystem.getTocs();
            IToc target = null;
            int i = 0;
            while (i < tocs.length) {
                if (tocs[i].getHref().equals(href)) {
                    target = tocs[i];
                }
                ++i;
            }
            if (target != null) {
                part.selectReveal((IHelpResource)target);
            }
        }
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        Control focusControl = this.container.getDisplay().getFocusControl();
        if (focusControl != null && focusControl instanceof FormText) {
            return this.parent.fillFormContextMenu((FormText)focusControl, manager);
        }
        return false;
    }

    @Override
    public boolean hasFocusControl(Control control) {
        int i = 0;
        while (i < this.results.size()) {
            EngineResultSection er = this.results.get(i);
            if (er.hasControl(control)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void add(EngineDescriptor ed, ISearchEngineResult match) {
        EngineResultSection ers = this.findEngineResult(ed);
        if (match != null) {
            ers.add(match);
        }
    }

    public synchronized void add(EngineDescriptor ed, ISearchEngineResult[] matches) {
        EngineResultSection ers = this.findEngineResult(ed);
        ers.add(matches);
    }

    public synchronized void error(EngineDescriptor ed, IStatus status) {
        EngineResultSection ers = this.findEngineResult(ed);
        ers.error(status);
    }

    private synchronized EngineResultSection findEngineResult(EngineDescriptor ed) {
        int i = 0;
        while (i < this.results.size()) {
            EngineResultSection er = this.results.get(i);
            if (er.matches(ed)) {
                return er;
            }
            ++i;
        }
        EngineResultSection er = new EngineResultSection(this, ed);
        Display display = this.parent.getForm().getToolkit().getColors().getDisplay();
        display.syncExec(() -> {
            Control c = er.createControl(this.innerForm.getBody(), this.innerToolkit);
            c.setLayoutData((Object)new TableWrapData(256));
        });
        this.results.add(er);
        return er;
    }

    private void add(EngineDescriptor ed) {
        EngineResultSection er = new EngineResultSection(this, ed);
        Control c = er.createControl(this.innerForm.getBody(), this.innerToolkit);
        c.setLayoutData((Object)new TableWrapData(256));
        this.results.add(er);
    }

    void reflow() {
        this.innerForm.reflow(true);
        this.parent.reflow();
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    void scrollToBeginning() {
        this.innerForm.setOrigin(0, 0);
    }

    @Override
    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.parent.getCopyAction();
        }
        return null;
    }

    FormToolkit getToolkit() {
        return this.innerToolkit;
    }

    @Override
    public void stop() {
    }

    @Override
    public void toggleRoleFilter() {
        this.updateResultSections();
    }

    @Override
    public void refilter() {
        this.updateResultSections();
    }

    @Override
    public void saveState(IMemento memento) {
    }
}

