/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.tasklist.CopyTaskAction;
import org.eclipse.ui.views.tasklist.DefaultTaskListResourceAdapter;
import org.eclipse.ui.views.tasklist.FiltersAction;
import org.eclipse.ui.views.tasklist.GotoTaskAction;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.eclipse.ui.views.tasklist.MarkCompletedAction;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.NewTaskAction;
import org.eclipse.ui.views.tasklist.PasteTaskAction;
import org.eclipse.ui.views.tasklist.PurgeCompletedAction;
import org.eclipse.ui.views.tasklist.RemoveTaskAction;
import org.eclipse.ui.views.tasklist.ResolveMarkerAction;
import org.eclipse.ui.views.tasklist.SelectAllTasksAction;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskListContentProvider;
import org.eclipse.ui.views.tasklist.TaskPropertiesAction;
import org.eclipse.ui.views.tasklist.TaskSorter;
import org.eclipse.ui.views.tasklist.TasksFilter;

@Deprecated
public class TaskList
extends ViewPart {
    private Table table;
    private TaskSorter comparator;
    private CellEditor descriptionEditor;
    private TableViewer viewer;
    private TasksFilter filter = new TasksFilter();
    private IMemento memento;
    private boolean markerLimitExceeded;
    private Composite parent;
    private StackLayout stackLayout = new StackLayout();
    private Composite compositeMarkerLimitExceeded;
    private CellEditorActionHandler editorActionHandler;
    private TaskAction newTaskAction;
    private TaskAction copyTaskAction;
    private TaskAction pasteTaskAction;
    private TaskAction removeTaskAction;
    private TaskAction purgeCompletedAction;
    private TaskAction gotoTaskAction;
    private TaskAction selectAllAction;
    private ResolveMarkerAction resolveMarkerAction;
    private TaskAction filtersAction;
    private MarkCompletedAction markCompletedAction;
    private TaskAction propertiesAction;
    private Action sortByCategoryAction;
    private Action sortByCompletedAction;
    private Action sortByPriorityAction;
    private Action sortByDescriptionAction;
    private Action sortByResourceAction;
    private Action sortByContainerAction;
    private Action sortByLocationAction;
    private Action sortByCreationTimeAction;
    private Action sortAscendingAction;
    private Action sortDescendingAction;
    private Clipboard clipboard;
    private static String[] tableColumnProperties = new String[]{"org.eclipse.jface.image", "done", "priority", "message", "org.eclipse.ui.tasklist.resourceName", "org.eclipse.ui.tasklist.containerName", "org.eclipse.ui.tasklist.lineAndLocation"};
    private static final String TAG_COLUMN = "column";
    private static final String TAG_NUMBER = "number";
    private static final String TAG_WIDTH = "width";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ID = "id";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_TOP_INDEX = "topIndex";
    private static final String TAG_SORT_SECTION = "TaskListSortState";
    private String[] columnHeaders = new String[]{TaskListMessages.TaskList_headerIcon, TaskListMessages.TaskList_headerCompleted, TaskListMessages.TaskList_headerPriority, TaskListMessages.TaskList_headerDescription, TaskListMessages.TaskList_headerResource, TaskListMessages.TaskList_headerFolder, TaskListMessages.TaskList_headerLocation};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(16, false, true), new ColumnPixelData(16, false, true), new ColumnPixelData(16, false, true), new ColumnWeightData(200), new ColumnWeightData(75), new ColumnWeightData(150), new ColumnWeightData(60)};
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            TaskList.this.partActivated(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            TaskList.this.partClosed(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ISelectionChangedListener focusSelectionChangedListener = event -> this.focusSelectionChanged(event);
    private IResource[] focusResources;
    private IWorkbenchPart focusPart;
    private ISelectionProvider focusSelectionProvider;
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            return MarkerUtil.getProperty(element, property);
        }

        public boolean canModify(Object element, String property) {
            return MarkerUtil.isEditable((IMarker)element);
        }

        public void modify(Object element, String property, Object value) {
            Item item = (Item)element;
            IMarker marker = (IMarker)item.getData();
            TaskList.this.setProperty(marker, property, value);
        }
    };

    void addDragSupport(Control control) {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                TaskList.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)listener);
    }

    void cancelEditing() {
        this.getTableViewer().cancelEditing();
    }

    void createColumns() {
        IMemento[] children;
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = TaskList.this.table.indexOf((TableColumn)e.widget);
                if (column == TaskList.this.comparator.getTopPriority()) {
                    TaskList.this.comparator.reverseTopPriority();
                } else {
                    TaskList.this.comparator.setTopPriority(column);
                }
                TaskList.this.updateSortingState();
                TaskList.this.viewer.refresh();
                IDialogSettings workbenchSettings = TaskList.getPlugin().getDialogSettings();
                IDialogSettings settings = workbenchSettings.getSection(TaskList.TAG_SORT_SECTION);
                if (settings == null) {
                    settings = workbenchSettings.addNewSection(TaskList.TAG_SORT_SECTION);
                }
                TaskList.this.comparator.saveState(settings);
            }
        };
        if (this.memento != null && (children = this.memento.getChildren(TAG_COLUMN)) != null) {
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                Integer val = child.getInteger(TAG_NUMBER);
                if (val != null) {
                    int index = val;
                    val = child.getInteger(TAG_WIDTH);
                    if (val != null) {
                        this.columnLayouts[index] = new ColumnPixelData(val.intValue(), true);
                    }
                }
                ++n2;
            }
        }
        boolean text = Util.isMac();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            TableColumn tc = new TableColumn(this.table, 0, i);
            if (!text && i == 1) {
                tc.setImage(MarkerUtil.getImage("header_complete"));
            } else if (!text && i == 2) {
                tc.setImage(MarkerUtil.getImage("header_priority"));
            } else {
                tc.setText(this.columnHeaders[i]);
            }
            if (text && (i == 1 || i == 2)) {
                tc.pack();
                this.columnLayouts[i] = new ColumnPixelData(Math.max(16, tc.getWidth()), false, true);
            }
            tc.setResizable(this.columnLayouts[i].resizable);
            layout.addColumnData(this.columnLayouts[i]);
            tc.addSelectionListener((SelectionListener)headerListener);
            ++i;
        }
    }

    static String createMarkerReport(IMarker[] markers) {
        StringBuffer buf = new StringBuffer();
        buf.append(TaskListMessages.TaskList_reportKind);
        buf.append("\t");
        buf.append(TaskListMessages.TaskList_reportStatus);
        buf.append("\t");
        buf.append(TaskListMessages.TaskList_reportPriority);
        buf.append("\t");
        buf.append(TaskListMessages.TaskList_headerDescription);
        buf.append("\t");
        buf.append(TaskListMessages.TaskList_headerResource);
        buf.append("\t");
        buf.append(TaskListMessages.TaskList_headerFolder);
        buf.append("\t");
        buf.append(TaskListMessages.TaskList_headerLocation);
        buf.append(System.getProperty("line.separator"));
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            TaskList.writeMarker(buf, marker);
            ++n2;
        }
        return buf.toString();
    }

    static void writeMarker(StringBuffer buf, IMarker marker) {
        buf.append(MarkerUtil.getKindText(marker));
        buf.append("\t");
        buf.append(MarkerUtil.getCompleteText(marker));
        buf.append("\t");
        buf.append(MarkerUtil.getPriorityText(marker));
        buf.append("\t");
        buf.append(MarkerUtil.getMessage(marker));
        buf.append("\t");
        buf.append(MarkerUtil.getResourceName(marker));
        buf.append("\t");
        buf.append(MarkerUtil.getContainerName(marker));
        buf.append("\t");
        buf.append(MarkerUtil.getLineAndLocation(marker));
        buf.append(System.getProperty("line.separator"));
    }

    boolean isMarkerLimitExceeded() {
        return this.markerLimitExceeded;
    }

    void setMarkerLimitExceeded(boolean markerLimitExceeded) {
        this.markerLimitExceeded = markerLimitExceeded;
        this.stackLayout.topControl = markerLimitExceeded ? this.compositeMarkerLimitExceeded : this.table;
        this.parent.layout();
    }

    public void createPartControl(Composite parent) {
        this.createPartControl0(parent);
    }

    private void createPartControl0(Composite parent) {
        IMemento filterMem;
        this.parent = parent;
        this.clipboard = new Clipboard(parent.getDisplay());
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.createColumns();
        this.makeActions();
        this.fillActionBars();
        this.addDragSupport((Control)this.table);
        this.compositeMarkerLimitExceeded = new Composite(parent, 0);
        this.compositeMarkerLimitExceeded.setLayout((Layout)new GridLayout());
        Label labelMarkerLimitExceeded = new Label(this.compositeMarkerLimitExceeded, 64);
        labelMarkerLimitExceeded.setText(TaskListMessages.TaskList_markerLimitExceeded);
        parent.setLayout((Layout)this.stackLayout);
        this.setMarkerLimitExceeded(false);
        this.viewer.setContentProvider((IContentProvider)new TaskListContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TaskListLabelProvider());
        if (this.memento != null && (filterMem = this.memento.getChild(TAG_FILTER)) != null) {
            this.getFilter().restoreState(filterMem);
        }
        this.comparator = new TaskSorter();
        IDialogSettings workbenchSettings = TaskList.getPlugin().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_SORT_SECTION);
        this.comparator.restoreState(settings);
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.updateSortingState();
        this.viewer.setInput((Object)this.getWorkspace().getRoot());
        this.viewer.addSelectionChangedListener(event -> this.selectionChanged(event));
        this.viewer.addOpenListener(event -> this.gotoTaskAction.run());
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TaskList.this.handleKeyPressed(e);
            }
        });
        this.viewer.getControl().getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                int childIndex = e.childID;
                if (childIndex == -1) {
                    super.getValue(e);
                    return;
                }
                Object item = TaskList.this.viewer.getElementAt(childIndex);
                if (item instanceof IMarker) {
                    IMarker marker = (IMarker)item;
                    e.result = MarkerUtil.isEditable(marker) ? MarkerUtil.getCompleteText(marker) : MarkerUtil.getKindText(marker);
                } else {
                    super.getValue(e);
                    return;
                }
            }
        });
        CellEditor[] editors = new CellEditor[this.columnHeaders.length];
        editors[1] = new CheckboxCellEditor((Composite)this.table);
        String[] priorities = new String[]{TaskListMessages.TaskList_high, TaskListMessages.TaskList_normal, TaskListMessages.TaskList_low};
        editors[2] = new ComboBoxCellEditor((Composite)this.table, priorities, 8);
        editors[3] = this.descriptionEditor = new TextCellEditor((Composite)this.table);
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier(this.cellModifier);
        this.viewer.setColumnProperties(tableColumnProperties);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener(this.partListener);
        this.editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.editorActionHandler.addCellEditor(this.descriptionEditor);
        this.editorActionHandler.setCopyAction((IAction)this.copyTaskAction);
        this.editorActionHandler.setPasteAction((IAction)this.pasteTaskAction);
        this.editorActionHandler.setDeleteAction((IAction)this.removeTaskAction);
        this.editorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        this.viewer.getControl().addHelpListener(e -> {
            String contextId = null;
            IMarker marker = (IMarker)((IStructuredSelection)this.getSelection()).getFirstElement();
            if (marker != null) {
                contextId = IDE.getMarkerHelpRegistry().getHelp(marker);
            }
            if (contextId == null) {
                contextId = "org.eclipse.ui.task_list_view_context";
            }
            this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().displayHelp(contextId);
        });
        this.updateStatusMessage();
        this.updateTitle();
    }

    void createTable(Composite parent) {
        this.table = new Table(parent, 66306);
        this.table.setLinesVisible(true);
        new TableEditor(this.table);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.focusSelectionProvider != null) {
            this.focusSelectionProvider.removeSelectionChangedListener(this.focusSelectionChangedListener);
            this.focusSelectionProvider = null;
        }
        this.focusPart = null;
        if (this.editorActionHandler != null) {
            this.editorActionHandler.dispose();
            this.editorActionHandler = null;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }

    public void edit(IMarker marker) {
        this.viewer.editElement((Object)marker, 3);
    }

    void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menu = actionBars.getMenuManager();
        MenuManager submenu = new MenuManager(TaskListMessages.SortByMenu_text);
        menu.add((IContributionItem)submenu);
        submenu.add((IAction)this.sortByCategoryAction);
        submenu.add((IAction)this.sortByCompletedAction);
        submenu.add((IAction)this.sortByPriorityAction);
        submenu.add((IAction)this.sortByDescriptionAction);
        submenu.add((IAction)this.sortByResourceAction);
        submenu.add((IAction)this.sortByContainerAction);
        submenu.add((IAction)this.sortByLocationAction);
        submenu.add((IAction)this.sortByCreationTimeAction);
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.sortAscendingAction);
        submenu.add((IAction)this.sortDescendingAction);
        menu.add((IAction)this.filtersAction);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.newTaskAction);
        toolBar.add((IAction)this.removeTaskAction);
        toolBar.add((IAction)this.filtersAction);
    }

    void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        this.markCompletedAction.setEnabled(this.markCompletedAction.shouldEnable(selection));
        this.resolveMarkerAction.setEnabled(this.resolveMarkerAction.shouldEnable(selection));
        menu.add((IAction)this.newTaskAction);
        menu.add((IAction)this.gotoTaskAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.copyTaskAction);
        menu.add((IAction)this.pasteTaskAction);
        menu.add((IAction)this.removeTaskAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.markCompletedAction);
        menu.add((IAction)this.purgeCompletedAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.resolveMarkerAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        menu.add((IAction)this.propertiesAction);
    }

    void filterChanged() {
        BusyIndicator.showWhile((Display)this.viewer.getControl().getShell().getDisplay(), () -> {
            this.viewer.getControl().setRedraw(false);
            this.viewer.refresh(false);
            this.viewer.getControl().setRedraw(true);
            this.updateStatusMessage();
            this.updateTitle();
        });
    }

    void focusSelectionChanged(SelectionChangedEvent event) {
        this.updateFocusResource(event.getSelection());
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == IShowInSource.class) {
            return adapterType.cast(() -> new ShowInContext(null, this.getSelection()));
        }
        if (adapterType == IShowInTargetList.class) {
            return adapterType.cast(() -> new String[]{"org.eclipse.ui.views.ResourceNavigator"});
        }
        return (T)super.getAdapter(adapterType);
    }

    Clipboard getClipboard() {
        return this.clipboard;
    }

    TasksFilter getFilter() {
        return this.filter;
    }

    static AbstractUIPlugin getPlugin() {
        return WorkbenchPlugin.getDefault();
    }

    public IResource getResource() {
        if (this.showSelections() && this.focusResources != null && this.focusResources.length >= 1 && this.focusResources[0] != null) {
            return this.focusResources[0];
        }
        return this.getWorkspace().getRoot();
    }

    public IResource[] getResources() {
        if (this.showSelections() && this.focusResources != null) {
            return this.focusResources;
        }
        return new IResource[]{this.getWorkspace().getRoot()};
    }

    int getResourceDepth() {
        if (this.showSelections() && !this.showChildrenHierarchy()) {
            return 0;
        }
        return 2;
    }

    public ISelection getSelection() {
        return this.viewer.getStructuredSelection();
    }

    String getStatusMessage(IStructuredSelection selection) {
        if (selection != null && selection.size() == 1) {
            IMarker marker = (IMarker)selection.getFirstElement();
            return MarkerUtil.getMessage(marker);
        }
        TaskListContentProvider provider = (TaskListContentProvider)this.viewer.getContentProvider();
        if (selection != null && selection.size() > 1) {
            return provider.getStatusSummarySelected(selection);
        }
        return provider.getStatusSummaryVisible();
    }

    TableViewer getTableViewer() {
        return this.viewer;
    }

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.removeTaskAction.isEnabled()) {
            this.removeTaskAction.run();
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    boolean checkResource(IResource resource) {
        IResource currentResource;
        int n;
        if (!this.showSelections()) {
            return true;
        }
        IResource[] resources = this.getResources();
        if (this.showOwnerProject()) {
            IResource[] iResourceArray = resources;
            int n2 = resources.length;
            n = 0;
            while (n < n2) {
                IResource currentResource2 = iResourceArray[n];
                if (currentResource2 == null) {
                    return true;
                }
                IProject project = currentResource2.getProject();
                if (project == null || project.equals((Object)resource.getProject())) {
                    return true;
                }
                ++n;
            }
        }
        if (this.showChildrenHierarchy()) {
            IResource[] iResourceArray = resources;
            n = resources.length;
            int n3 = 0;
            while (n3 < n) {
                currentResource = iResourceArray[n3];
                if (currentResource != null && currentResource.getFullPath().isPrefixOf(resource.getFullPath())) {
                    return true;
                }
                ++n3;
            }
        } else {
            IResource[] iResourceArray = resources;
            n = resources.length;
            int n4 = 0;
            while (n4 < n) {
                currentResource = iResourceArray[n4];
                if (resource.equals((Object)currentResource)) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    boolean shouldShow(IMarker marker) {
        return this.checkResource(marker.getResource()) && this.getFilter().select(marker);
    }

    void makeActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.gotoTaskAction = new GotoTaskAction(this, "gotoFile");
        this.gotoTaskAction.setText(TaskListMessages.GotoTask_text);
        this.gotoTaskAction.setToolTipText(TaskListMessages.GotoTask_tooltip);
        this.gotoTaskAction.setImageDescriptor(MarkerUtil.getImageDescriptor("gotoobj"));
        this.gotoTaskAction.setEnabled(false);
        this.newTaskAction = new NewTaskAction(this, "newTask");
        this.newTaskAction.setText(TaskListMessages.NewTask_text);
        this.newTaskAction.setToolTipText(TaskListMessages.NewTask_tooltip);
        this.newTaskAction.setImageDescriptor(MarkerUtil.getImageDescriptor("addtsk"));
        this.newTaskAction.setDisabledImageDescriptor(MarkerUtil.getImageDescriptor("addtsk_disabled"));
        this.copyTaskAction = new CopyTaskAction(this, "copy");
        this.copyTaskAction.setText(TaskListMessages.CopyTask_text);
        this.copyTaskAction.setToolTipText(TaskListMessages.CopyTask_tooltip);
        this.copyTaskAction.setEnabled(false);
        this.pasteTaskAction = new PasteTaskAction(this, "paste");
        this.pasteTaskAction.setText(TaskListMessages.PasteTask_text);
        this.pasteTaskAction.setToolTipText(TaskListMessages.PasteTask_tooltip);
        this.pasteTaskAction.setEnabled(false);
        this.removeTaskAction = new RemoveTaskAction(this, "delete");
        this.removeTaskAction.setText(TaskListMessages.RemoveTask_text);
        this.removeTaskAction.setToolTipText(TaskListMessages.RemoveTask_tooltip);
        this.removeTaskAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.removeTaskAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.removeTaskAction.setEnabled(false);
        this.markCompletedAction = new MarkCompletedAction(this, "markCompleted");
        this.markCompletedAction.setText(TaskListMessages.MarkCompleted_text);
        this.markCompletedAction.setToolTipText(TaskListMessages.MarkCompleted_tooltip);
        this.markCompletedAction.setEnabled(false);
        this.purgeCompletedAction = new PurgeCompletedAction(this, "deleteCompleted");
        this.purgeCompletedAction.setText(TaskListMessages.PurgeCompleted_text);
        this.purgeCompletedAction.setToolTipText(TaskListMessages.PurgeCompleted_tooltip);
        this.purgeCompletedAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.purgeCompletedAction.setEnabled(true);
        this.selectAllAction = new SelectAllTasksAction(this, "selectAll");
        this.selectAllAction.setText(TaskListMessages.SelectAll_text);
        this.selectAllAction.setToolTipText(TaskListMessages.SelectAll_tooltip);
        this.resolveMarkerAction = new ResolveMarkerAction(this, "resolve");
        this.resolveMarkerAction.setText(TaskListMessages.Resolve_text);
        this.resolveMarkerAction.setToolTipText(TaskListMessages.Resolve_tooltip);
        this.resolveMarkerAction.setEnabled(false);
        this.sortByCategoryAction = new SortByAction(0);
        this.sortByCategoryAction.setText(TaskListMessages.SortByCategory_text);
        this.sortByCategoryAction.setToolTipText(TaskListMessages.SortByCategory_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCategoryAction, "org.eclipse.ui.task_sort_type_action_context");
        this.sortByCompletedAction = new SortByAction(1);
        this.sortByCompletedAction.setText(TaskListMessages.SortByCompleted_text);
        this.sortByCompletedAction.setToolTipText(TaskListMessages.SortByCompleted_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCompletedAction, "org.eclipse.ui.task_sort_completed_action_context");
        this.sortByPriorityAction = new SortByAction(2);
        this.sortByPriorityAction.setText(TaskListMessages.SortByPriority_text);
        this.sortByPriorityAction.setToolTipText(TaskListMessages.SortByPriority_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByPriorityAction, "org.eclipse.ui.task_sort_priority_action_context");
        this.sortByDescriptionAction = new SortByAction(3);
        this.sortByDescriptionAction.setText(TaskListMessages.SortByDescription_text);
        this.sortByDescriptionAction.setToolTipText(TaskListMessages.SortByDescription_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByDescriptionAction, "org.eclipse.ui.task_sort_description_action_context");
        this.sortByResourceAction = new SortByAction(4);
        this.sortByResourceAction.setText(TaskListMessages.SortByResource_text);
        this.sortByResourceAction.setToolTipText(TaskListMessages.SortByResource_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByResourceAction, "org.eclipse.ui.task_sort_resource_action_context");
        this.sortByContainerAction = new SortByAction(5);
        this.sortByContainerAction.setText(TaskListMessages.SortByContainer_text);
        this.sortByContainerAction.setToolTipText(TaskListMessages.SortByContainer_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByContainerAction, "org.eclipse.ui.task_sort_folder_action_context");
        this.sortByLocationAction = new SortByAction(6);
        this.sortByLocationAction.setText(TaskListMessages.SortByLocation_text);
        this.sortByLocationAction.setToolTipText(TaskListMessages.SortByLocation_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByLocationAction, "org.eclipse.ui.task_sort_location_action_context");
        this.sortByCreationTimeAction = new SortByAction(7);
        this.sortByCreationTimeAction.setText(TaskListMessages.SortByCreationTime_text);
        this.sortByCreationTimeAction.setToolTipText(TaskListMessages.SortByCreationTime_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCreationTimeAction, "org.eclipse.ui.task_sort_creation_time_action_context");
        this.sortAscendingAction = new SortDirectionAction(1);
        this.sortAscendingAction.setText(TaskListMessages.SortAscending_text);
        this.sortAscendingAction.setToolTipText(TaskListMessages.SortAscending_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortAscendingAction, "org.eclipse.ui.task_sort_ascending_action_context");
        this.sortDescendingAction = new SortDirectionAction(-1);
        this.sortDescendingAction.setText(TaskListMessages.SortDescending_text);
        this.sortDescendingAction.setToolTipText(TaskListMessages.SortDescending_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortDescendingAction, "org.eclipse.ui.task_sort_descending_action_context");
        this.filtersAction = new FiltersAction(this, TAG_FILTER);
        this.filtersAction.setText(TaskListMessages.Filters_text);
        this.filtersAction.setToolTipText(TaskListMessages.Filters_tooltip);
        this.filtersAction.setImageDescriptor(MarkerUtil.getImageDescriptor(TAG_FILTER));
        this.propertiesAction = new TaskPropertiesAction(this, "properties");
        this.propertiesAction.setText(TaskListMessages.Properties_text);
        this.propertiesAction.setToolTipText(TaskListMessages.Properties_tooltip);
        this.propertiesAction.setEnabled(false);
    }

    void markersChanged() {
        this.updateStatusMessage();
        this.updateTitle();
    }

    void partActivated(IWorkbenchPart part) {
        if (part == this.focusPart) {
            return;
        }
        if (this.focusSelectionProvider != null) {
            this.focusSelectionProvider.removeSelectionChangedListener(this.focusSelectionChangedListener);
            this.focusSelectionProvider = null;
        }
        this.focusPart = part;
        if (this.focusPart != null) {
            this.focusSelectionProvider = this.focusPart.getSite().getSelectionProvider();
            if (this.focusSelectionProvider != null) {
                this.focusSelectionProvider.addSelectionChangedListener(this.focusSelectionChangedListener);
                this.updateFocusResource(this.focusSelectionProvider.getSelection());
            } else {
                this.updateFocusResource(null);
            }
        }
    }

    void partClosed(IWorkbenchPart part) {
        if (part != this.focusPart) {
            return;
        }
        if (this.focusSelectionProvider != null) {
            this.focusSelectionProvider.removeSelectionChangedListener(this.focusSelectionChangedListener);
            this.focusSelectionProvider = null;
        }
        this.focusPart = null;
    }

    void performDragSetData(DragSourceEvent event) {
        if (MarkerTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.viewer.getStructuredSelection().toArray();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            Object[] data = this.viewer.getStructuredSelection().toArray();
            if (data != null) {
                IMarker[] markers = new IMarker[data.length];
                int i = 0;
                while (i < markers.length) {
                    markers[i] = (IMarker)data[i];
                    ++i;
                }
                event.data = TaskList.createMarkerReport(markers);
            }
            return;
        }
    }

    void restoreState(IMemento memento) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMemento selectionMem = memento.getChild(TAG_SELECTION);
        if (selectionMem != null) {
            ArrayList<IMarker> selectionList = new ArrayList<IMarker>();
            IMemento[] iMementoArray = selectionMem.getChildren(TAG_MARKER);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento markerMemento = iMementoArray[n2];
                try {
                    IMarker marker;
                    long id = Long.parseLong(markerMemento.getString(TAG_ID));
                    IResource resource = root.findMember(markerMemento.getString(TAG_RESOURCE));
                    if (resource != null && (marker = resource.findMarker(id)) != null) {
                        selectionList.add(marker);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
        Table table = this.viewer.getTable();
        try {
            String topIndexStr = memento.getString(TAG_TOP_INDEX);
            table.setTopIndex(Integer.parseInt(topIndexStr));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void saveState(IMemento memento) {
        Object[] markers;
        if (this.viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        this.getFilter().saveState(memento.createChild(TAG_FILTER));
        Table table = this.viewer.getTable();
        TableColumn[] columns = table.getColumns();
        boolean shouldSave = false;
        int i = 0;
        while (i < columns.length) {
            if (this.columnLayouts[i].resizable && columns[i].getWidth() != 0) {
                shouldSave = true;
                break;
            }
            ++i;
        }
        if (shouldSave) {
            i = 0;
            while (i < columns.length) {
                if (this.columnLayouts[i].resizable) {
                    IMemento child = memento.createChild(TAG_COLUMN);
                    child.putInteger(TAG_NUMBER, i);
                    child.putInteger(TAG_WIDTH, columns[i].getWidth());
                }
                ++i;
            }
        }
        if ((markers = this.viewer.getStructuredSelection().toArray()).length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            Object[] objectArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                Object selection = objectArray[n2];
                IMemento elementMem = selectionMem.createChild(TAG_MARKER);
                IMarker marker = (IMarker)selection;
                elementMem.putString(TAG_RESOURCE, marker.getResource().getFullPath().toString());
                elementMem.putString(TAG_ID, String.valueOf(marker.getId()));
                ++n2;
            }
        }
        int topIndex = table.getTopIndex();
        memento.putString(TAG_TOP_INDEX, String.valueOf(topIndex));
    }

    void selectionChanged(SelectionChangedEvent event) {
        IFile file;
        IEditorPart editor;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.updateStatusMessage(selection);
        this.updateTitle();
        this.updatePasteEnablement();
        if (selection.isEmpty()) {
            this.copyTaskAction.setEnabled(false);
            this.removeTaskAction.setEnabled(false);
            this.gotoTaskAction.setEnabled(false);
            this.propertiesAction.setEnabled(false);
            return;
        }
        this.propertiesAction.setEnabled(selection.size() == 1);
        this.copyTaskAction.setEnabled(true);
        IMarker selectedMarker = (IMarker)selection.getFirstElement();
        boolean canJump = selection.size() == 1 && selectedMarker.getResource().getType() == 1;
        this.gotoTaskAction.setEnabled(canJump);
        boolean canRemove = true;
        for (IMarker m : selection) {
            if (MarkerUtil.isEditable(m)) continue;
            canRemove = false;
            break;
        }
        this.removeTaskAction.setEnabled(canRemove);
        if (canJump && (editor = this.getSite().getPage().getActiveEditor()) != null && (file = ResourceUtil.getFile(editor.getEditorInput())) != null && selectedMarker.getResource().equals((Object)file)) {
            IDE.gotoMarker(editor, selectedMarker);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void setProperty(IMarker marker, String property, Object value) {
        if (MarkerUtil.getProperty(marker, property).equals(value)) {
            return;
        }
        try {
            if (property == tableColumnProperties[1]) {
                marker.setAttribute("done", value);
            } else if (property == tableColumnProperties[2]) {
                marker.setAttribute("priority", 2 - (Integer)value);
            } else if (property == tableColumnProperties[3]) {
                marker.setAttribute("message", value);
            }
        }
        catch (CoreException e) {
            String msg = TaskListMessages.TaskList_errorModifyingTask;
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)msg, null, (IStatus)e.getStatus());
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        IStructuredSelection ssel = (IStructuredSelection)selection;
        Iterator i = ssel.iterator();
        while (i.hasNext()) {
            Assert.isTrue((boolean)(i.next() instanceof IMarker));
        }
        if (this.viewer != null) {
            this.viewer.setSelection(selection, reveal);
        }
    }

    boolean showChildrenHierarchy() {
        switch (this.getFilter().onResource) {
            default: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    boolean showSelections() {
        switch (this.getFilter().onResource) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    boolean showOwnerProject() {
        return this.getFilter().onResource == 3;
    }

    void toggleInputSelection(boolean value) {
    }

    void toggleLockInput(boolean value) {
    }

    void updateFocusResource(ISelection selection) {
        int l;
        IResource resource;
        IEditorInput input;
        ArrayList<IResource> list = new ArrayList<IResource>();
        if (selection instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)selection) {
                IResource resource2;
                if (!(object instanceof IAdaptable)) continue;
                ITaskListResourceAdapter taskListResourceAdapter = (ITaskListResourceAdapter)Adapters.adapt(object, ITaskListResourceAdapter.class);
                if (taskListResourceAdapter == null) {
                    taskListResourceAdapter = DefaultTaskListResourceAdapter.getDefault();
                }
                if ((resource2 = taskListResourceAdapter.getAffectedResource((IAdaptable)object)) == null) continue;
                list.add(resource2);
            }
        }
        if (list.size() == 0 && this.focusPart instanceof IEditorPart && (input = ((IEditorPart)this.focusPart).getEditorInput()) != null && (resource = ResourceUtil.getResource(input)) != null) {
            list.add(resource);
        }
        if ((l = list.size()) < 1) {
            return;
        }
        Object[] resources = list.toArray(new IResource[l]);
        int i = 0;
        while (i < l) {
            Assert.isNotNull((Object)resources[i]);
            ++i;
        }
        if (!Arrays.equals(resources, this.focusResources)) {
            boolean updateNeeded = false;
            if (this.showOwnerProject()) {
                int m;
                int n = m = this.focusResources == null ? 0 : this.focusResources.length;
                if (l != m) {
                    updateNeeded = true;
                } else {
                    int i2 = 0;
                    while (i2 < l) {
                        boolean projectsEqual;
                        IProject oldProject = m < 1 ? null : this.focusResources[0].getProject();
                        IProject newProject = resources[0].getProject();
                        boolean bl = oldProject == null ? newProject == null : (projectsEqual = oldProject.equals((Object)newProject));
                        if (!projectsEqual) {
                            updateNeeded = true;
                            break;
                        }
                        ++i2;
                    }
                }
            } else if (this.showSelections()) {
                updateNeeded = true;
            }
            this.focusResources = resources;
            if (updateNeeded) {
                this.viewer.getControl().setRedraw(false);
                this.viewer.refresh();
                this.viewer.getControl().setRedraw(true);
                this.updateStatusMessage();
                this.updateTitle();
            }
        }
    }

    void updatePasteEnablement() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.getClipboard().getContents((Transfer)transfer);
        boolean canPaste = false;
        if (markerData != null) {
            IMarker[] iMarkerArray = markerData;
            int n = markerData.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
                    canPaste = true;
                    break;
                }
                ++n2;
            }
        }
        this.pasteTaskAction.setEnabled(canPaste);
    }

    void updateStatusMessage() {
        this.updateStatusMessage(this.viewer.getStructuredSelection());
    }

    void updateStatusMessage(IStructuredSelection selection) {
        String message = this.getStatusMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    void updateTitle() {
        TaskListContentProvider provider = (TaskListContentProvider)this.getTableViewer().getContentProvider();
        String summary = provider.getTitleSummary();
        this.setContentDescription(summary);
    }

    void updateSortingState() {
        int curColumn = this.comparator.getTopPriority();
        this.sortByCategoryAction.setChecked(curColumn == 0);
        this.sortByCompletedAction.setChecked(curColumn == 1);
        this.sortByPriorityAction.setChecked(curColumn == 2);
        this.sortByDescriptionAction.setChecked(curColumn == 3);
        this.sortByResourceAction.setChecked(curColumn == 4);
        this.sortByContainerAction.setChecked(curColumn == 5);
        this.sortByLocationAction.setChecked(curColumn == 6);
        this.sortByCreationTimeAction.setChecked(curColumn == 7);
        int curDirection = this.comparator.getTopPriorityDirection();
        this.sortAscendingAction.setChecked(curDirection == 1);
        this.sortDescendingAction.setChecked(curDirection == -1);
    }

    class SortByAction
    extends Action {
        private int column;

        public SortByAction(int column) {
            this.column = column;
        }

        public void run() {
            TaskList.this.comparator.setTopPriority(this.column);
            TaskList.this.updateSortingState();
            TaskList.this.viewer.refresh();
            IDialogSettings workbenchSettings = TaskList.getPlugin().getDialogSettings();
            IDialogSettings settings = workbenchSettings.getSection(TaskList.TAG_SORT_SECTION);
            if (settings == null) {
                settings = workbenchSettings.addNewSection(TaskList.TAG_SORT_SECTION);
            }
            TaskList.this.comparator.saveState(settings);
        }
    }

    class SortDirectionAction
    extends Action {
        private int direction;

        public SortDirectionAction(int direction) {
            this.direction = direction;
        }

        public void run() {
            TaskList.this.comparator.setTopPriorityDirection(this.direction);
            TaskList.this.updateSortingState();
            TaskList.this.viewer.refresh();
            IDialogSettings workbenchSettings = TaskList.getPlugin().getDialogSettings();
            IDialogSettings settings = workbenchSettings.getSection(TaskList.TAG_SORT_SECTION);
            if (settings == null) {
                settings = workbenchSettings.addNewSection(TaskList.TAG_SORT_SECTION);
            }
            TaskList.this.comparator.saveState(settings);
        }
    }

    static class TaskListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static String[] keys = new String[]{"org.eclipse.jface.image", "org.eclipse.ui.tasklist.completeImage", "org.eclipse.ui.tasklist.priorityImage", "message", "org.eclipse.ui.tasklist.resourceName", "org.eclipse.ui.tasklist.containerName", "org.eclipse.ui.tasklist.lineAndLocation"};

        TaskListLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex >= 3 && columnIndex <= 6) {
                return (String)MarkerUtil.getProperty(element, keys[columnIndex]);
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex >= 0 && columnIndex <= 2) {
                return (Image)MarkerUtil.getProperty(element, keys[columnIndex]);
            }
            return null;
        }
    }
}

