/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.internal.ui.AbstractDebugListSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectLaunchersDialog
extends AbstractDebugListSelectionDialog {
    Text description = null;
    Button configspecific = null;
    private ILaunchDelegate[] fDelegates = null;
    private ILaunchConfigurationWorkingCopy fConfiguration = null;
    private String fLaunchMode = null;

    public SelectLaunchersDialog(Shell parentShell, ILaunchDelegate[] delegates, ILaunchConfigurationWorkingCopy configuration, String launchmode) {
        super(parentShell);
        super.setTitle(LaunchConfigurationsMessages.SelectLaunchersDialog_0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDelegates = delegates;
        this.fConfiguration = configuration;
        this.fLaunchMode = launchmode;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException nfe) {
                return new Point(450, 450);
            }
        }
        return new Point(450, 450);
    }

    @Override
    protected String getDialogSettingsId() {
        return "org.eclipse.debug.ui.SELECT_LAUNCHERS_DIALOG";
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_launchers_dialog";
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new DelegatesLabelProvider();
    }

    @Override
    protected Object getViewerInput() {
        return this.fDelegates;
    }

    @Override
    protected void addCustomHeaderControls(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 768, 0, 0);
        SWTFactory.createWrapLabel(comp, LaunchConfigurationsMessages.SelectLaunchersDialog_2, 2);
        SWTFactory.createVerticalSpacer(comp, 1);
        this.configspecific = SWTFactory.createCheckButton(comp, LaunchConfigurationsMessages.SelectLaunchersDialog_1, null, true, 1);
        this.configspecific.setSelection(false);
        GridData gd = (GridData)this.configspecific.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.configspecific.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = ((Button)e.widget).getSelection();
                SelectLaunchersDialog.this.getViewer().getControl().setEnabled(checked);
                SelectLaunchersDialog.this.resetDelegate();
            }
        });
        Link link = new Link(comp, 64);
        link.setText(LaunchConfigurationsMessages.SelectLaunchersDialog_4);
        link.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTFactory.showPreferencePage("org.eclipse.debug.ui.LaunchDelegatesPreferencePage");
                if (!SelectLaunchersDialog.this.configspecific.getSelection()) {
                    SelectLaunchersDialog.this.resetDelegate();
                }
            }
        });
    }

    protected ILaunchDelegate getSelectedDelegate() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        return (ILaunchDelegate)selection.getFirstElement();
    }

    @Override
    protected void okPressed() {
        ILaunchDelegate delegate = null;
        Set<String> modes = this.getCurrentModeSet();
        if (this.configspecific.getSelection()) {
            delegate = this.getSelectedDelegate();
            if (delegate != null) {
                this.fConfiguration.setPreferredLaunchDelegate(modes, delegate.getId());
            }
        } else {
            this.fConfiguration.setPreferredLaunchDelegate(modes, null);
        }
        if (this.fConfiguration.isDirty()) {
            try {
                this.fConfiguration.doSave();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        super.okPressed();
    }

    private void resetDelegate() {
        try {
            ILaunchDelegate preferred = this.fConfiguration.getType().getPreferredDelegate(this.getCurrentModeSet());
            Viewer viewer = this.getViewer();
            if (preferred != null) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)preferred));
            } else {
                viewer.setSelection((ISelection)new StructuredSelection());
            }
            this.getButton(0).setEnabled(this.isValid());
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
    }

    @Override
    protected void addCustomFooterControls(Composite parent) {
        Group group = SWTFactory.createGroup(parent, LaunchConfigurationsMessages.SelectLaunchersDialog_5, 1, 1, 1808);
        this.description = SWTFactory.createText((Composite)group, 72, 1, 1808);
        this.description.setBackground(group.getBackground());
    }

    protected Set<String> getCurrentModeSet() {
        HashSet<String> modes = new HashSet();
        try {
            modes = this.fConfiguration.getModes();
            modes.add(this.fLaunchMode);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return modes;
    }

    @Override
    protected void addViewerListeners(StructuredViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss != null && !ss.isEmpty()) {
                    SelectLaunchersDialog.this.description.setText(((ILaunchDelegate)ss.getFirstElement()).getDescription());
                } else {
                    SelectLaunchersDialog.this.description.setText("");
                }
            }
        });
        super.addViewerListeners(viewer);
    }

    @Override
    protected void initializeControls() {
        Viewer viewer = this.getViewer();
        try {
            ILaunchDelegate delegate = this.fConfiguration.getPreferredDelegate(this.getCurrentModeSet());
            if (delegate != null) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)delegate));
                this.configspecific.setSelection(true);
            } else {
                viewer.getControl().setEnabled(false);
                this.resetDelegate();
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
    }

    @Override
    protected String getViewerLabel() {
        return LaunchConfigurationsMessages.SelectLaunchersDialog_launchers;
    }

    class DelegatesLabelProvider
    implements ILabelProvider {
        DelegatesLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ILaunchDelegate) {
                ILaunchDelegate ldp = (ILaunchDelegate)element;
                String name = ldp.getName();
                if (name == null) {
                    name = ldp.getContributorName();
                }
                return name;
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

