/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;

public class CMDescriptionBuilder
extends CMVisitor {
    protected StringBuffer sb;
    protected CMNode root;
    protected boolean isRootVisited;

    public String buildDescription(CMNode node) {
        this.sb = new StringBuffer();
        this.root = node;
        this.isRootVisited = false;
        this.visitCMNode(node);
        return this.sb.toString();
    }

    public void visitCMAnyElement(CMAnyElement anyElement) {
        this.sb.append("namespace:uri=\"" + anyElement.getNamespaceURI() + "\"");
    }

    public void visitCMDataType(CMDataType dataType) {
        this.sb.append("#PCDATA");
    }

    public void visitCMDocument(CMDocument document) {
        CMNamedNodeMap map = document.getElements();
        int size = map.getLength();
        int i = 0;
        while (i < size) {
            this.visitCMNode(map.item(i));
            ++i;
        }
    }

    public void visitCMGroup(CMGroup group) {
        int op = group.getOperator();
        if (op == 3) {
            this.sb.append("all");
        }
        this.sb.append("(");
        String separator = ", ";
        if (op == 2) {
            separator = " | ";
        }
        CMNodeList nodeList = group.getChildNodes();
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            this.visitCMNode(nodeList.item(i));
            if (i < size - 1) {
                this.sb.append(separator);
            }
            ++i;
        }
        this.sb.append(")");
        this.addOccurenceSymbol(group);
    }

    public void visitCMElementDeclaration(CMElementDeclaration ed) {
        if (ed == this.root && !this.isRootVisited) {
            this.isRootVisited = true;
            CMContent content = ed.getContent();
            if (content != null) {
                if (content.getNodeType() != 7) {
                    this.sb.append("(");
                    this.visitCMNode(content);
                    this.sb.append(")");
                } else {
                    this.visitCMNode(content);
                }
            }
        } else {
            this.sb.append(ed.getElementName());
            this.addOccurenceSymbol(ed);
        }
    }

    public void addOccurenceSymbol(CMContent content) {
        int min = content.getMinOccur();
        int max = content.getMaxOccur();
        if (min == 0) {
            if (max > 1 || max == -1) {
                this.sb.append("*");
            } else {
                this.sb.append("?");
            }
        } else if (max > 1 || max == -1) {
            this.sb.append("+");
        }
    }
}

