/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class DefaultBinaryFileEditor
extends AbstractTextEditor
implements IResourceChangeListener {
    public DefaultBinaryFileEditor() {
        this.setDocumentProvider((IDocumentProvider)new BinaryFileDocumentProvider());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer sourceViewer = super.createSourceViewer(parent, ruler, styles);
        sourceViewer.setEditable(false);
        return sourceViewer;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() == 1) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getName().equals(DefaultBinaryFileEditor.this.getEditorInput().getName())) {
                            DefaultBinaryFileEditor.this.refresh();
                            return false;
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    protected void refresh() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultBinaryFileEditor.this.doSetInput(DefaultBinaryFileEditor.this.getEditorInput());
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
            }
        });
    }

    public static class BinaryFileDocumentProvider
    extends StorageDocumentProvider {
        protected IDocument createDocument(Object element) throws CoreException {
            ICElement cElement;
            IFile file = ResourceUtil.getFile((Object)element);
            if (file != null && (cElement = CoreModel.getDefault().create(file)) instanceof IBinary) {
                element = new BinaryFileEditorInput((IBinary)cElement);
            }
            return super.createDocument(element);
        }

        public long getModificationStamp(Object element) {
            if (element instanceof FileEditorInput) {
                return ((FileEditorInput)element).getFile().getModificationStamp();
            }
            return 0L;
        }

        public boolean isModifiable(Object element) {
            return false;
        }

        public boolean isReadOnly(Object element) {
            return true;
        }
    }

    public static class BinaryFileEditorInput
    extends PlatformObject
    implements IStorageEditorInput {
        private final IBinary fBinary;
        private IStorage fStorage;

        public BinaryFileEditorInput(IBinary binary) {
            this.fBinary = binary;
        }

        public boolean exists() {
            return this.fBinary.exists();
        }

        public ImageDescriptor getImageDescriptor() {
            IFile file = (IFile)this.fBinary.getResource();
            IContentType contentType = IDE.getContentType((IFile)file);
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName(), contentType);
        }

        public String getName() {
            return this.fBinary.getElementName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.fBinary.getResource().getFullPath().toString();
        }

        public IStorage getStorage() throws CoreException {
            if (this.fStorage == null) {
                Objdump objdump;
                IGnuToolFactory factory;
                IBinaryParser.IBinaryObject object = (IBinaryParser.IBinaryObject)this.fBinary.getAdapter(IBinaryParser.IBinaryObject.class);
                if (object != null && (factory = (IGnuToolFactory)object.getBinaryParser().getAdapter(IGnuToolFactory.class)) != null && (objdump = factory.getObjdump(object.getPath())) != null) {
                    try {
                        int limitBytes = 0x600000;
                        byte[] output = objdump.getOutput(limitBytes);
                        if (output.length >= limitBytes) {
                            String text = CEditorMessages.DefaultBinaryFileEditor_TruncateMessage;
                            String message = "\n\n--- " + text + " ---\n" + objdump.toString();
                            System.arraycopy(message.getBytes(), 0, output, limitBytes - message.length(), message.length());
                        }
                        this.fStorage = new FileStorage((InputStream)new ByteArrayInputStream(output), object.getPath());
                    }
                    catch (IOException exc) {
                        CUIPlugin.log(exc);
                    }
                }
                if (this.fStorage == null) {
                    this.fStorage = EditorUtility.getStorage(this.fBinary);
                    if (this.fStorage == null) {
                        this.fStorage = (IFile)this.fBinary.getResource();
                    }
                }
            }
            return this.fStorage;
        }
    }
}

