/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;

public class CompareCoreUtils {
    @Nullable
    public static String getResourceEncoding(Repository db, String repoPath) {
        if (db.isBare()) {
            return null;
        }
        IFile resource = ResourceUtil.getFileForLocation(db, repoPath, false);
        if (resource == null) {
            return null;
        }
        return CompareCoreUtils.getResourceEncoding((IResource)resource);
    }

    @NonNull
    public static String getResourceEncoding(@NonNull IResource resource) {
        String charset;
        if (resource instanceof IEncodedStorage) {
            IEncodedStorage encodedStorage = (IEncodedStorage)resource;
            try {
                charset = encodedStorage.getCharset();
                if (charset == null) {
                    charset = resource.getParent().getDefaultCharset();
                }
            }
            catch (CoreException coreException) {
                charset = ResourcesPlugin.getEncoding();
            }
        } else if (resource instanceof IContainer) {
            try {
                charset = ((IContainer)resource).getDefaultCharset();
            }
            catch (CoreException coreException) {
                charset = ResourcesPlugin.getEncoding();
            }
        } else {
            charset = ResourcesPlugin.getEncoding();
        }
        return charset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DiffEntry getChangeDiffEntry(Repository repository, String newPath, RevCommit newCommit, RevCommit oldCommit, ObjectReader objectReader) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            DiffEntry diff;
            TreeWalk walk = new TreeWalk(objectReader);
            try {
                List entries;
                block12: {
                    walk.setRecursive(true);
                    walk.addTree((AnyObjectId)oldCommit.getTree());
                    walk.addTree((AnyObjectId)newCommit.getTree());
                    entries = DiffEntry.scan((TreeWalk)walk);
                    Iterator iterator = entries.iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        if (entries.size() < 2) {
                            return null;
                        }
                        break block12;
                    } while ((diff = (DiffEntry)iterator.next()).getChangeType() != DiffEntry.ChangeType.MODIFY || !newPath.equals(diff.getNewPath()));
                    return diff;
                }
                RenameDetector detector = new RenameDetector(repository);
                detector.addAll((Collection)entries);
                List renames = detector.compute(walk.getObjectReader(), (ProgressMonitor)NullProgressMonitor.INSTANCE);
                Iterator iterator = renames.iterator();
            }
            finally {
                if (walk == null) return diff;
                walk.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

