/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.commands;

import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorPresentation;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DisassemblyDisplayModeHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String ID_PARAMETER_MODE = "org.eclipse.cdt.debug.command.disassemblyDisplayMode.parameterMode";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DisassemblyEditorPresentation presentation = this.getEditorPresentation(event);
        if (presentation != null) {
            String param = event.getParameter(ID_PARAMETER_MODE);
            if ("instructions".equals(param)) {
                presentation.setShowIntstructions(!presentation.showIntstructions());
            } else if ("source".equals(param)) {
                presentation.setShowSource(!presentation.showSource());
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IDocumentPresentation p;
        IDocumentProvider dp;
        IEditorInput input;
        IWorkbenchPart part;
        IWorkbenchPartSite site = (IWorkbenchPartSite)element.getServiceLocator().getService(IWorkbenchPartSite.class);
        if (site != null && (part = site.getPart()) instanceof ITextEditor && (input = ((ITextEditor)part).getEditorInput()) instanceof DisassemblyEditorInput && (dp = ((ITextEditor)part).getDocumentProvider()) instanceof DisassemblyDocumentProvider && (p = ((DisassemblyDocumentProvider)dp).getDocumentPresentation(input)) instanceof DisassemblyEditorPresentation) {
            DisassemblyEditorPresentation presentation = (DisassemblyEditorPresentation)p;
            String param = (String)parameters.get(ID_PARAMETER_MODE);
            if ("instructions".equals(param)) {
                element.setChecked(presentation.showIntstructions());
            } else if ("source".equals(param)) {
                element.setChecked(presentation.showSource());
            }
        }
    }

    private DisassemblyEditorPresentation getEditorPresentation(ExecutionEvent event) throws ExecutionException {
        DisassemblyDocumentProvider dp;
        Object o;
        ISelection s = HandlerUtil.getActiveMenuEditorInputChecked((ExecutionEvent)event);
        if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof DisassemblyEditorInput && (dp = CDebugUIPlugin.getDefault().getDisassemblyEditorManager().getDocumentProvider()) != null) {
            return (DisassemblyEditorPresentation)dp.getDocumentPresentation(o);
        }
        return null;
    }
}

