/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.help.internal.HelpPlugin;

public class HelpProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private File file = null;
    protected String name = null;

    public HelpProperties(String name, Plugin plugin) {
        this(name, plugin.getStateLocation().toFile());
    }

    public HelpProperties(String name, File dir) {
        this.name = name;
        this.file = new File(dir, name);
    }

    public boolean restore() {
        boolean loaded = false;
        this.clear();
        if (!this.file.exists()) {
            return loaded;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(this.file);){
                super.load(in);
                loaded = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe00) {
            HelpPlugin.logError((String)("File " + this.file.getName() + " cannot be read."));
        }
        return loaded;
    }

    public boolean save() {
        boolean ret = false;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(this.file);){
                super.store(out, "This is a generated file; do not edit.");
                ret = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe00) {
            HelpPlugin.logError((String)("Exception occurred while saving table " + this.name + " to file " + this.file.getAbsolutePath() + "."), (Throwable)ioe00);
        }
        return ret;
    }
}

