/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class EditAttributeDialog
extends Dialog
implements ModifyListener {
    protected Attr attribute;
    protected String attributeName;
    protected Text attributeNameField;
    protected String attributeValue;
    protected Text attributeValueField;
    protected Label errorMessageIcon;
    protected Label errorMessageLabel;
    protected Button okButton;
    protected Element ownerElement;

    public EditAttributeDialog(Shell parentShell, Element ownerElement, Attr attribute) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.ownerElement = ownerElement;
        this.attribute = attribute;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.attributeName = this.getModelValue(this.attributeNameField.getText());
            this.attributeValue = this.attributeValueField.getText();
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.attributeNameField.forceFocus();
        this.attributeNameField.selectAll();
        this.updateErrorMessage();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogArea, "org.eclipse.wst.xml.ui.xcui0500");
        Composite composite = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label attributeNameLabel = new Label(composite, 0);
        attributeNameLabel.setText(XMLUIMessages._UI_LABEL_NAME_COLON);
        this.attributeNameField = new Text(composite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.attributeNameField.setLayoutData((Object)gd);
        this.attributeNameField.setText(this.getDisplayValue(this.attribute != null ? this.attribute.getName() : ""));
        this.attributeNameField.addModifyListener((ModifyListener)this);
        Label attributeValueLabel = new Label(composite, 0);
        attributeValueLabel.setText(XMLUIMessages._UI_LABEL_VALUE_COLON);
        String value = this.attribute != null ? this.attribute.getValue() : "";
        int style = 2052;
        if (value.indexOf("\n") != -1) {
            style = 2818;
        }
        this.attributeValueField = new Text(composite, style);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.attributeValueField.setLayoutData((Object)gd);
        this.attributeValueField.setText(this.getDisplayValue(this.attribute != null ? this.attribute.getValue() : ""));
        Composite message = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        message.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        message.setLayoutData((Object)gd);
        this.errorMessageIcon = new Label(message, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 128;
        this.errorMessageIcon.setLayoutData((Object)gd);
        this.errorMessageIcon.setImage(null);
        this.errorMessageLabel = new Label(message, 64);
        this.errorMessageLabel.setText(XMLUIMessages.error_message_goes_here);
        gd = new GridData(768);
        gd.widthHint = 200;
        gd.heightHint = Math.max(30, this.errorMessageLabel.computeSize((int)0, (int)0, (boolean)false).y * 2);
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 128;
        this.errorMessageLabel.setLayoutData((Object)gd);
        return dialogArea;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    protected String getDisplayValue(String string) {
        return string != null ? string : "";
    }

    protected String getModelValue(String string) {
        String result = null;
        if (string != null && string.trim().length() > 0) {
            result = string;
        }
        return result;
    }

    public void modifyText(ModifyEvent e) {
        this.updateErrorMessage();
    }

    protected void updateErrorMessage() {
        String errorMessage = null;
        Image image = null;
        String name = this.attributeNameField.getText().trim();
        if (name.length() > 0) {
            Attr matchingAttribute = this.ownerElement.getAttributeNode(name);
            if (matchingAttribute != null && matchingAttribute != this.attribute) {
                errorMessage = XMLUIMessages._ERROR_XML_ATTRIBUTE_ALREADY_EXISTS;
                image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/error_obj.png");
            } else if (!this.isValidName(name)) {
                errorMessage = NLS.bind((String)XMLUIMessages._ERROR_XML_ATTRIBUTE_IS_INVALID, (Object)name);
                image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/error_obj.png");
            }
        } else {
            errorMessage = "";
        }
        this.errorMessageLabel.setText(errorMessage != null ? errorMessage : "");
        this.errorMessageIcon.setImage(image);
        this.errorMessageLabel.getParent().layout();
        this.okButton.setEnabled(errorMessage == null);
    }

    private boolean isValidName(String name) {
        if (NameValidator.isValid((String)name)) {
            return true;
        }
        return name.startsWith("<%");
    }
}

