/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration
implements IFunctionDeclaration {
    public TypeReference returnType;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public FlowInfo analyseCode(Scope classScope, FlowContext initializationContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            boolean isJsDocInferredReturn;
            if (this.binding == null) {
                return flowInfo;
            }
            if (!this.binding.isUsed() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.declaringClass.isLocalType()) && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.getScope().problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.isAbstract()) {
                return flowInfo;
            }
            ExceptionHandlingFlowContext methodContext = new ExceptionHandlingFlowContext(initializationContext, this, null, this.getScope(), FlowInfo.DEAD_END);
            if (this.arguments != null) {
                int i = 0;
                int count = this.arguments.length;
                while (i < count) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[i].getBinding());
                    ++i;
                }
            }
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                int i = 0;
                int count = this.statements.length;
                while (i < count) {
                    Statement stat = this.statements[i];
                    if (!stat.complainIfUnreachable(flowInfo, this.getScope(), didAlreadyComplain)) {
                        if (stat instanceof AbstractMethodDeclaration) {
                            ((AbstractMethodDeclaration)stat).analyseCode(this.getScope(), null, flowInfo.copy());
                        } else {
                            flowInfo = stat.analyseCode(this.getScope(), methodContext, flowInfo);
                        }
                    } else {
                        didAlreadyComplain = true;
                    }
                    ++i;
                }
            }
            TypeBinding returnTypeBinding = this.binding.returnType;
            boolean bl = isJsDocInferredReturn = (this.binding.tagBits & 0x40000000000000L) != 0L;
            if (returnTypeBinding == TypeBinding.VOID || returnTypeBinding == TypeBinding.UNKNOWN || this.isAbstract()) {
                this.needFreeReturn = (flowInfo.tagBits & 1) == 0;
            } else if (!(flowInfo == FlowInfo.DEAD_END || this.inferredMethod != null && this.inferredMethod.isConstructor || isJsDocInferredReturn)) {
                this.getScope().problemReporter().shouldReturn(returnTypeBinding, this);
            }
            this.getScope().reportUnusedDeclarations();
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public boolean isMethod() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, unit);
    }

    public void resolveStatements() {
        super.resolveStatements();
    }

    public void traverse(ASTVisitor visitor, Scope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, this.getScope());
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.getScope());
                    ++i;
                }
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.getScope());
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, (Scope)blockScope)) {
            int i;
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.getScope());
                    ++i;
                }
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.getScope());
                    ++i;
                }
            }
        }
        visitor.endVisit(this, (Scope)blockScope);
    }

    public int getASTType() {
        return 43;
    }
}

