/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.wst.jsdt.core.ast.ILiteral;
import org.eclipse.wst.jsdt.core.ast.ISingleNameReference;
import org.eclipse.wst.jsdt.core.ast.IThisReference;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;

public class Util
implements SuffixConstants {
    private static final int DEFAULT_READING_SIZE = 8192;
    public static final String UTF_8 = "UTF-8";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = new String(CharOperation.NO_CHAR);
    public static final int[] EMPTY_INT_ARRAY = new int[0];

    public static char[] bytesToChar(byte[] bytes, String encoding) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(bytes), bytes.length, encoding);
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            byte[] byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
            return byArray;
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            char[] cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
            return cArray;
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            reader = new InputStreamReader(stream);
        }
        int totalRead = 0;
        char[] contents = length == -1 ? CharOperation.NO_CHAR : new char[length];
        while (true) {
            int amountRequested;
            if (totalRead < length) {
                amountRequested = length - totalRead;
            } else {
                int current = reader.read();
                if (current < 0) break;
                amountRequested = Math.max(stream.available(), 8192);
                if (totalRead + 1 + amountRequested > contents.length) {
                    char[] cArray = contents;
                    contents = new char[totalRead + 1 + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, totalRead);
                }
                contents[totalRead++] = (char)current;
            }
            int amountRead = reader.read(contents, totalRead, amountRequested);
            if (amountRead < 0) break;
            totalRead += amountRead;
        }
        int start = 0;
        if (totalRead > 0 && UTF_8.equals(encoding) && contents[0] == '\ufeff') {
            --totalRead;
            start = 1;
        }
        if (totalRead < contents.length) {
            char[] cArray = contents;
            contents = new char[totalRead];
            System.arraycopy(cArray, start, contents, 0, totalRead);
        }
        return contents;
    }

    public static int getLineNumber(int position, int[] lineEnds, int g, int d) {
        if (lineEnds == null) {
            return 1;
        }
        if (d == -1) {
            return 1;
        }
        int m = g;
        while (g <= d) {
            m = g + (d - g) / 2;
            int start = lineEnds[m];
            if (position < start) {
                d = m - 1;
                continue;
            }
            if (position > start) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < lineEnds[m]) {
            return m + 1;
        }
        return m + 2;
    }

    public static byte[] getZipEntryByteContent(ZipEntry ze, ZipFile zip) throws IOException {
        InputStream stream = null;
        try {
            stream = zip.getInputStream(ze);
            if (stream == null) {
                throw new IOException("Invalid zip entry name : " + ze.getName());
            }
            byte[] byArray = Util.getInputStreamAsByteArray(stream, (int)ze.getSize());
            return byArray;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final boolean isArchiveFileName(String name) {
        int suffixIndex;
        char c;
        int i;
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength == (suffixLength = SUFFIX_ZIP.length)) {
            i = 0;
            while (i < suffixLength) {
                c = name.charAt(nameLength - i - 1);
                if (c != SUFFIX_zip[suffixIndex = suffixLength - i - 1] && c != SUFFIX_ZIP[suffixIndex]) break;
                ++i;
            }
        }
        if (nameLength < (suffixLength = SUFFIX_JAR.length)) {
            return false;
        }
        i = 0;
        while (i < suffixLength) {
            c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_jar[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAR[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length;
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name[offset + i];
            if (c != SUFFIX_java[i] && c != SUFFIX_JAVA[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isClassFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_java[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAVA[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isExcluded(char[] path, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf('/', pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf('*', pattern, lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray(pattern, 0, lastSlash);
                    }
                    if (!Util.pathMatch(path, folderPattern)) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat(path, new char[]{'*'}, '/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (Util.pathMatch(path, exclusionPatterns[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final boolean isJavaFileName(char[] name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length;
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name[offset + i];
            if (c != SUFFIX_java[i] && c != SUFFIX_JAVA[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isJavaFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_java[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAVA[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int searchColumnNumber(int[] startLineIndexes, int lineNumber, int position) {
        switch (lineNumber) {
            case 1: {
                return position + 1;
            }
            case 2: {
                return position - startLineIndexes[0];
            }
        }
        int line = lineNumber - 2;
        int length = startLineIndexes.length;
        if (line >= length) {
            return position - startLineIndexes[length - 1];
        }
        return position - startLineIndexes[line];
    }

    public static Boolean toBoolean(boolean bool) {
        if (bool) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toString(Object[] objects) {
        return Util.toString(objects, new Displayable(){

            public String displayString(Object o) {
                if (o == null) {
                    return "null";
                }
                return o.toString();
            }
        });
    }

    public static String toString(Object[] objects, Displayable renderer) {
        if (objects == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(10);
        int i = 0;
        while (i < objects.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(renderer.displayString(objects[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static final char[] getTypeName(IExpression expression) {
        IExpression currExpr = expression;
        char[] selector = null;
        while (currExpr != null) {
            if (currExpr instanceof IFieldReference) {
                selector = selector == null ? ((IFieldReference)currExpr).getToken() : CharOperation.concatWith(new char[][]{((IFieldReference)currExpr).getToken(), selector}, '.');
                currExpr = ((IFieldReference)currExpr).getReceiver();
                continue;
            }
            if (currExpr instanceof ISingleNameReference) {
                selector = selector == null ? ((ISingleNameReference)currExpr).getToken() : CharOperation.concatWith(new char[][]{((ISingleNameReference)currExpr).getToken(), selector}, '.');
                currExpr = null;
                continue;
            }
            if (currExpr instanceof ArrayReference) {
                ArrayReference arrayRef = (ArrayReference)currExpr;
                if (arrayRef.position instanceof ILiteral) {
                    selector = selector == null ? ((ILiteral)((Object)arrayRef.position)).source() : CharOperation.concatWith(new char[][]{((ILiteral)((Object)arrayRef.position)).source(), selector}, '.');
                    currExpr = arrayRef.receiver;
                    continue;
                }
                currExpr = null;
                selector = null;
                continue;
            }
            if (currExpr instanceof IThisReference) {
                currExpr = null;
                selector = null;
                continue;
            }
            currExpr = null;
            selector = null;
        }
        return selector;
    }

    public static boolean pathMatch(char[] pathChars, char[] matchPathChars) {
        Path path = new Path(new String(pathChars));
        Path matchPath = new Path(new String(matchPathChars));
        IPath fileSystemWorkspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        boolean isPathFileSystemAbsolute = fileSystemWorkspacePath.isPrefixOf((IPath)path);
        boolean isMatchPathFileSystemAbsolute = fileSystemWorkspacePath.isPrefixOf((IPath)matchPath);
        if (!isPathFileSystemAbsolute && isMatchPathFileSystemAbsolute || isPathFileSystemAbsolute && !isMatchPathFileSystemAbsolute) {
            boolean hadTrailingSeparator;
            if (!isPathFileSystemAbsolute) {
                hadTrailingSeparator = path.hasTrailingSeparator();
                path = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getLocation();
                if (hadTrailingSeparator) {
                    path = path.addTrailingSeparator();
                }
            }
            if (!isMatchPathFileSystemAbsolute) {
                hadTrailingSeparator = matchPath.hasTrailingSeparator();
                matchPath = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)matchPath).getLocation();
                if (hadTrailingSeparator) {
                    matchPath = matchPath.addTrailingSeparator();
                }
            }
        }
        path = path.makeAbsolute();
        matchPath = matchPath.makeAbsolute();
        return CharOperation.pathMatch(matchPath.toPortableString().toCharArray(), path.toPortableString().toCharArray(), true, '/');
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

