/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataReader;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataSourceElementNotifier;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
        String documentPath = this.document.getPath();
        SourceElementParser parser = this.document.parser;
        if (parser == null) {
            Path path = new Path(documentPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaScriptCore.create(project), requestor);
        } else {
            parser.setRequestor(requestor);
        }
        char[] source = null;
        char[] name = null;
        try {
            source = this.document.getCharContents();
            name = documentPath.toCharArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (source == null || name == null) {
            return;
        }
        String pkgName = ((JavaSearchDocument)this.document).getPackageName();
        char[][] packageName = null;
        if (pkgName != null) {
            packageName = new char[][]{pkgName.toCharArray()};
        }
        BasicCompilationUnit compilationUnit = new BasicCompilationUnit(source, packageName, new String(name));
        try {
            parser.parseCompilationUnit(compilationUnit, true);
        }
        catch (Exception e) {
            Logger.logException("Error while indexing document", e);
        }
    }

    public void indexMetadata() {
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
        String documentPath = this.document.getPath();
        char[] source = null;
        char[] name = null;
        try {
            source = this.document.getCharContents();
            name = documentPath.toCharArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (source == null || name == null) {
            return;
        }
        String pkgName = ((JavaSearchDocument)this.document).getPackageName();
        char[][] packageName = null;
        if (pkgName != null) {
            packageName = new char[][]{pkgName.toCharArray()};
        }
        LibraryAPIs apis = MetadataReader.readAPIsFromString(new String(source), documentPath);
        new MetadataSourceElementNotifier(apis, requestor).notifyRequestor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void indexArchive() {
        Path jarPath = new Path(this.document.getPath());
        File file = new File(jarPath.toOSString());
        if (!file.isFile()) return;
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        Index index = indexManager.getIndexForUpdate((IPath)jarPath, false, true);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        ZipFile zip = null;
        try {
            try {
                zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    if (!Util.isClassFileName(ze.getName())) continue;
                    byte[] classFileBytes = Util.getZipEntryByteContent(ze, zip);
                    JavaSearchDocument entryDocument = new JavaSearchDocument(ze, (IPath)jarPath, ByteBuffer.wrap(classFileBytes).asCharBuffer().array(), participant);
                    indexManager.indexDocument(entryDocument, participant, index, (IPath)jarPath);
                }
                indexManager.saveIndex(index);
                return;
            }
            catch (ZipException e1) {
                e1.printStackTrace();
                if (zip == null) return;
                try {
                    zip.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                if (zip == null) return;
                try {
                    zip.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

