/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.javadoc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIException;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaDocLocations {
    public static final String ARCHIVE_PREFIX = "jar:";
    private static final String PREF_JAVADOCLOCATIONS = "org.eclipse.wst.jsdt.ui.javadoclocations";
    public static final String PREF_JAVADOCLOCATIONS_MIGRATED = "org.eclipse.wst.jsdt.ui.javadoclocations.migrated";
    private static final String NODE_ROOT = "javadoclocation";
    private static final String NODE_ENTRY = "location_01";
    private static final String NODE_PATH = "path";
    private static final String NODE_URL = "url";
    private static final QualifiedName PROJECT_JAVADOC = new QualifiedName("org.eclipse.wst.jsdt.ui", "project_javadoc_location");

    public static void migrateToClasspathAttributes() {
        final Map oldLocations = JavaDocLocations.loadOldForCompatibility();
        if (oldLocations.isEmpty()) {
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            preferenceStore.setValue(PREF_JAVADOCLOCATIONS, "");
            preferenceStore.setValue(PREF_JAVADOCLOCATIONS_MIGRATED, true);
            return;
        }
        Job job = new Job(CorextMessages.JavaDocLocations_migratejob_name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor pm) throws CoreException {
                            JavaDocLocations.updateClasspathEntries(oldLocations, pm);
                            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
                            preferenceStore.setValue(JavaDocLocations.PREF_JAVADOCLOCATIONS, "");
                            preferenceStore.setValue(JavaDocLocations.PREF_JAVADOCLOCATIONS_MIGRATED, true);
                        }
                    };
                    new WorkbenchRunnableAdapter(runnable).run(monitor);
                }
                catch (InvocationTargetException e) {
                    JavaScriptPlugin.log(e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    static final void updateClasspathEntries(Map oldLocationMap, IProgressMonitor monitor) throws JavaScriptModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaScriptProject[] javaProjects = JavaScriptCore.create((IWorkspaceRoot)root).getJavaScriptProjects();
        try {
            monitor.beginTask(CorextMessages.JavaDocLocations_migrate_operation, javaProjects.length);
            int i = 0;
            while (i < javaProjects.length) {
                IJavaScriptProject project = javaProjects[i];
                String projectJavadoc = (String)oldLocationMap.get(project.getPath());
                if (projectJavadoc != null) {
                    try {
                        JavaDocLocations.setProjectJavadocLocation(project, projectJavadoc);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                IIncludePathEntry[] rawClasspath = project.getRawIncludepath();
                boolean hasChange = false;
                int k = 0;
                while (k < rawClasspath.length) {
                    IIncludePathEntry updated = JavaDocLocations.getConvertedEntry(rawClasspath[k], project, oldLocationMap);
                    if (updated != null) {
                        rawClasspath[k] = updated;
                        hasChange = true;
                    }
                    ++k;
                }
                if (hasChange) {
                    project.setRawIncludepath(rawClasspath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IIncludePathEntry getConvertedEntry(IIncludePathEntry entry, IJavaScriptProject project, Map oldLocationMap) {
        IPath path = null;
        switch (entry.getEntryKind()) {
            case 2: 
            case 3: {
                return null;
            }
            case 5: {
                JavaDocLocations.convertContainer(entry, project, oldLocationMap);
                return null;
            }
            case 1: {
                path = entry.getPath();
                break;
            }
            case 4: {
                path = JavaScriptCore.getResolvedVariablePath((IPath)entry.getPath());
                break;
            }
            default: {
                return null;
            }
        }
        if (path == null) {
            return null;
        }
        IIncludePathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            if ("javadoc_location".equals(extraAttributes[i].getName())) {
                return null;
            }
            ++i;
        }
        String libraryJavadocLocation = (String)oldLocationMap.get(path);
        if (libraryJavadocLocation != null) {
            CPListElement element = CPListElement.createFromExisting(entry, project);
            element.setAttribute("javadoc_location", libraryJavadocLocation);
            return element.getClasspathEntry();
        }
        return null;
    }

    private static void convertContainer(IIncludePathEntry entry, IJavaScriptProject project, Map oldLocationMap) {
        try {
            IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)entry.getPath(), (IJavaScriptProject)project);
            if (container == null) {
                return;
            }
            IIncludePathEntry[] entries = container.getIncludepathEntries();
            boolean hasChange = false;
            int i = 0;
            while (i < entries.length) {
                IIncludePathEntry curr = entries[i];
                IIncludePathEntry updatedEntry = JavaDocLocations.getConvertedEntry(curr, project, oldLocationMap);
                if (updatedEntry != null) {
                    entries[i] = updatedEntry;
                    hasChange = true;
                }
                ++i;
            }
            if (hasChange) {
                BuildPathSupport.requestContainerUpdate(project, container, entries);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void setProjectJavadocLocation(IJavaScriptProject project, URL url) {
        try {
            String location = url != null ? url.toExternalForm() : null;
            JavaDocLocations.setProjectJavadocLocation(project, location);
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private static void setProjectJavadocLocation(IJavaScriptProject project, String url) throws CoreException {
        project.getProject().setPersistentProperty(PROJECT_JAVADOC, url);
    }

    public static URL getProjectJavadocLocation(IJavaScriptProject project) {
        String prop;
        block4: {
            prop = project.getProject().getPersistentProperty(PROJECT_JAVADOC);
            if (prop != null) break block4;
            return null;
        }
        try {
            return new URL(prop);
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        catch (MalformedURLException e) {
            JavaScriptPlugin.log(e);
        }
        return null;
    }

    public static URL getLibraryJavadocLocation(IIncludePathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int kind = entry.getEntryKind();
        if (kind != 1 && kind != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IIncludePathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IIncludePathAttribute attrib = extraAttributes[i];
            if ("javadoc_location".equals(attrib.getName())) {
                try {
                    return new URL(attrib.getValue());
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public static URL getJavadocBaseLocation(IJavaScriptElement element) throws JavaScriptModelException {
        if (element.getElementType() == 2) {
            return JavaDocLocations.getProjectJavadocLocation((IJavaScriptProject)element);
        }
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            IIncludePathEntry entry = root.getRawIncludepathEntry();
            if (entry == null) {
                return null;
            }
            if (entry.getEntryKind() == 5 && (entry = JavaDocLocations.getRealClasspathEntry(root.getJavaScriptProject(), entry.getPath(), root.getPath())) == null) {
                return null;
            }
            return JavaDocLocations.getLibraryJavadocLocation(entry);
        }
        return JavaDocLocations.getProjectJavadocLocation(root.getJavaScriptProject());
    }

    private static IIncludePathEntry getRealClasspathEntry(IJavaScriptProject jproject, IPath containerPath, IPath libPath) throws JavaScriptModelException {
        IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject)jproject);
        if (container != null) {
            IIncludePathEntry[] entries = container.getIncludepathEntries();
            int i = 0;
            while (i < entries.length) {
                IIncludePathEntry curr = entries[i];
                IIncludePathEntry resolved = JavaScriptCore.getResolvedIncludepathEntry((IIncludePathEntry)curr);
                if (resolved != null && libPath.equals((Object)resolved.getPath())) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map loadOldForCompatibility() {
        HashMap resultingOldLocations;
        block38: {
            resultingOldLocations = new HashMap();
            String string = PreferenceConstants.getPreferenceStore().getString(PREF_JAVADOCLOCATIONS);
            if (string != null && string.length() > 0) {
                byte[] bytes;
                try {
                    bytes = string.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = string.getBytes();
                }
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                try {
                    JavaDocLocations.loadFromStream(new InputSource(is), resultingOldLocations);
                    PreferenceConstants.getPreferenceStore().setValue(PREF_JAVADOCLOCATIONS, "");
                    HashMap hashMap = resultingOldLocations;
                    return hashMap;
                }
                catch (CoreException e) {
                    JavaScriptPlugin.log(e);
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                String STORE_FILE = "javadoclocations.xml";
                File file = JavaScriptPlugin.getDefault().getStateLocation().append("javadoclocations.xml").toFile();
                if (!file.exists()) break block38;
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    JavaDocLocations.loadFromStream(new InputSource(reader), resultingOldLocations);
                    file.delete();
                    HashMap hashMap = resultingOldLocations;
                    return hashMap;
                }
                catch (IOException e) {
                    JavaScriptPlugin.log(e);
                }
                finally {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (CoreException e2) {
                JavaScriptPlugin.log(e2);
            }
        }
        try {
            QualifiedName QUALIFIED_NAME = new QualifiedName("org.eclipse.wst.jsdt.ui", "jdoclocation");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String xmlString = root.getPersistentProperty(QUALIFIED_NAME);
            if (xmlString == null) return resultingOldLocations;
            StringReader reader = new StringReader(xmlString);
            try {
                JavaDocLocations.loadFromStream(new InputSource(reader), resultingOldLocations);
                root.setPersistentProperty(QUALIFIED_NAME, null);
                HashMap hashMap = resultingOldLocations;
                return hashMap;
            }
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        return resultingOldLocations;
    }

    private static void loadFromStream(InputSource inputSource, Map oldLocations) throws CoreException {
        Element cpElement;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            cpElement = parser.parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw JavaDocLocations.createException(e, CorextMessages.JavaDocLocations_error_readXML);
        }
        catch (ParserConfigurationException e) {
            throw JavaDocLocations.createException(e, CorextMessages.JavaDocLocations_error_readXML);
        }
        catch (IOException e) {
            throw JavaDocLocations.createException(e, CorextMessages.JavaDocLocations_error_readXML);
        }
        if (cpElement == null) {
            return;
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
            return;
        }
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase(NODE_ENTRY)) {
                String varPath = element.getAttribute(NODE_PATH);
                String varURL = element.getAttribute(NODE_URL);
                oldLocations.put(Path.fromPortableString((String)varPath), varURL);
            }
            ++i;
        }
    }

    public static URL getJavadocLocation(IJavaScriptElement element, boolean includeMemberReference) throws JavaScriptModelException {
        URL baseLocation = JavaDocLocations.getJavadocBaseLocation(element);
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer pathBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            pathBuffer.append('/');
        }
        switch (element.getElementType()) {
            case 4: {
                JavaDocLocations.appendPackageSummaryPath((IPackageFragment)element, pathBuffer);
                break;
            }
            case 2: 
            case 3: {
                JavaDocLocations.appendIndexPath(pathBuffer);
                break;
            }
            case 12: {
                element = element.getParent();
            }
            case 5: {
                IType mainType = ((IJavaScriptUnit)element).findPrimaryType();
                if (mainType == null) {
                    return null;
                }
                JavaDocLocations.appendTypePath(mainType, pathBuffer);
                break;
            }
            case 6: {
                JavaDocLocations.appendTypePath(((IClassFile)element).getType(), pathBuffer);
                break;
            }
            case 7: {
                JavaDocLocations.appendTypePath((IType)element, pathBuffer);
                break;
            }
            case 8: {
                IField field = (IField)element;
                JavaDocLocations.appendTypePath(field.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendFieldReference(field, pathBuffer);
                break;
            }
            case 9: {
                IFunction method = (IFunction)element;
                JavaDocLocations.appendTypePath(method.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendMethodReference(method, pathBuffer);
                break;
            }
            case 10: {
                JavaDocLocations.appendTypePath(((IMember)element).getDeclaringType(), pathBuffer);
                break;
            }
            case 13: {
                IImportDeclaration decl = (IImportDeclaration)element;
                if (decl.isOnDemand()) {
                    IJavaScriptElement cont = JavaModelUtil.findTypeContainer(element.getJavaScriptProject(), Signature.getQualifier((String)decl.getElementName()));
                    if (cont instanceof IType) {
                        JavaDocLocations.appendTypePath((IType)cont, pathBuffer);
                        break;
                    }
                    if (!(cont instanceof IPackageFragment)) break;
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)cont, pathBuffer);
                    break;
                }
                IType imp = element.getJavaScriptProject().findType(decl.getElementName());
                JavaDocLocations.appendTypePath(imp, pathBuffer);
                break;
            }
            default: {
                return null;
            }
        }
        try {
            return new URL(pathBuffer.toString());
        }
        catch (MalformedURLException e) {
            JavaScriptPlugin.log(e);
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment pack, StringBuffer buf) {
        String packPath = pack.getElementName().replace('.', '/');
        buf.append(packPath);
        buf.append("/package-summary.html");
    }

    private static void appendIndexPath(StringBuffer buf) {
        buf.append("index.html");
    }

    private static void appendTypePath(IType type, StringBuffer buf) {
        IPackageFragment pack = type.getPackageFragment();
        String packPath = pack.getElementName().replace('.', '/');
        String typePath = JavaModelUtil.getTypeQualifiedName(type);
        buf.append(packPath);
        buf.append('/');
        buf.append(typePath);
        buf.append(".html");
    }

    private static void appendFieldReference(IField field, StringBuffer buf) {
        buf.append('#');
        buf.append(field.getElementName());
    }

    private static void appendMethodReference(IFunction meth, StringBuffer buf) throws JavaScriptModelException {
        buf.append('#');
        buf.append(meth.getElementName());
        buf.append('(');
        String[] params = meth.getParameterTypes();
        IType declaringType = meth.getDeclaringType();
        boolean isVararg = Flags.isVarargs((int)meth.getFlags());
        int lastParam = params.length - 1;
        int i = 0;
        while (i <= lastParam) {
            String curr;
            String fullName;
            if (i != 0) {
                buf.append(", ");
            }
            if ((fullName = JavaModelUtil.getResolvedTypeName(curr = params[i], declaringType)) != null) {
                buf.append(fullName);
                int dim = Signature.getArrayCount((String)curr);
                if (i == lastParam && isVararg) {
                    --dim;
                }
                while (dim > 0) {
                    buf.append("[]");
                    --dim;
                }
                if (i == lastParam && isVararg) {
                    buf.append("...");
                }
            }
            ++i;
        }
        buf.append(')');
    }
}

