/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpConstants;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.ui.fix.CleanUpSaveParticipantConfigurationModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.SaveParticipantMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.AbstractSaveParticipantPreferenceConfiguration;
import org.eclipse.wst.jsdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;

public class CleanUpSaveParticipantPreferenceConfiguration
extends AbstractSaveParticipantPreferenceConfiguration {
    private static final int INDENT = 10;
    private IScopeContext fContext;
    private Map fSettings;
    private BulletListBlock fSelectedActionsText;
    private Button fFormatCodeButton;
    private Shell fShell;
    private Link fFormatConfigLink;
    private IPreferencePageContainer fContainer;
    private Button fAdditionalActionButton;
    private Button fConfigureButton;

    public Control createConfigControl(Composite parent, IPreferencePageContainer container) {
        this.fContainer = container;
        this.fShell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 10;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.fFormatCodeButton = new Button(composite, 32);
        this.fFormatCodeButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_SaveActionPreferencePage_FormatSource_Checkbox);
        this.fFormatCodeButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fFormatCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSaveParticipantPreferenceConfiguration.this.changeSettingsValue("cleanup.format_source_code", CleanUpSaveParticipantPreferenceConfiguration.this.fFormatCodeButton.getSelection());
            }
        });
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        int heightOneHalf = (int)Math.round((double)pixelConverter.convertHeightInCharsToPixels(1) * 1.5);
        this.fFormatConfigLink = new Link(composite, 0);
        this.fFormatConfigLink.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_ConfigureFormatter_Link);
        GridData gridData2 = new GridData(16384, 128, false, true);
        gridData2.horizontalIndent = 20;
        gridData2.minimumHeight = heightOneHalf;
        this.fFormatConfigLink.setLayoutData((Object)gridData2);
        this.fAdditionalActionButton = new Button(composite, 32);
        this.fAdditionalActionButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_AdditionalActions_Checkbox);
        this.createAdvancedComposite(composite);
        this.fAdditionalActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSaveParticipantPreferenceConfiguration.this.changeSettingsValue("cleanup.on_save_use_additional_actions", CleanUpSaveParticipantPreferenceConfiguration.this.fAdditionalActionButton.getSelection());
            }
        });
        return composite;
    }

    private Composite createAdvancedComposite(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 10;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fSelectedActionsText = new BulletListBlock();
        GridData data = (GridData)this.fSelectedActionsText.createControl(composite).getLayoutData();
        data.heightHint = new PixelConverter((Control)composite).convertHeightInCharsToPixels(8);
        this.fConfigureButton = new Button(composite, 0);
        this.fConfigureButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_Configure_Button);
        this.fConfigureButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fConfigureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CleanUpSaveParticipantConfigurationModifyDialog(parent.getShell(), CleanUpSaveParticipantPreferenceConfiguration.this.fSettings, SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_CleanUpSaveParticipantConfiguration_Title).open();
                CleanUpSaveParticipantPreferenceConfiguration.this.settingsChanged();
            }
        });
        return composite;
    }

    public void initialize(IScopeContext context, IAdaptable element) {
        IJavaScriptProject jProject;
        IProject project;
        this.fContext = context;
        this.fSettings = CleanUpPreferenceUtil.loadSaveParticipantOptions(context);
        this.settingsChanged();
        IJavaScriptProject javaProject = null;
        if (element != null && (project = (IProject)element.getAdapter(IProject.class)) != null && (jProject = JavaScriptCore.create((IProject)project)) != null && jProject.exists()) {
            javaProject = jProject;
        }
        this.configurePreferenceLink(this.fFormatConfigLink, javaProject, "org.eclipse.wst.jsdt.ui.preferences.CodeFormatterPreferencePage", "org.eclipse.wst.jsdt.ui.propertyPages.CodeFormatterPreferencePage");
        super.initialize(context, element);
    }

    public void dispose() {
        super.dispose();
    }

    public void performDefaults() {
        this.fSettings = CleanUpPreferenceUtil.loadSaveParticipantOptions((IScopeContext)new InstanceScope());
        this.settingsChanged();
    }

    public void performOk() {
        super.performOk();
        if (!"project".equals(this.fContext.getName()) || this.hasSettingsInScope(this.fContext)) {
            CleanUpPreferenceUtil.saveSaveParticipantOptions(this.fContext, this.fSettings);
        }
    }

    public void enableProjectSettings() {
        super.enableProjectSettings();
        CleanUpPreferenceUtil.saveSaveParticipantOptions(this.fContext, this.fSettings);
        this.updateAdvancedEnableState();
    }

    public void disableProjectSettings() {
        super.disableProjectSettings();
        IEclipsePreferences node = this.fContext.getNode("org.eclipse.wst.jsdt.ui");
        Map settings = CleanUpConstants.getSaveParticipantSettings();
        for (String key : settings.keySet()) {
            node.remove("sp_" + key);
        }
        this.updateAdvancedEnableState();
    }

    protected String getPostSaveListenerId() {
        return "org.eclipse.wst.jsdt.ui.postsavelistener.cleanup";
    }

    protected String getPostSaveListenerName() {
        return SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_CleanUpActionsTopNodeName_Checkbox;
    }

    protected void enableConfigControl(boolean isEnabled) {
        super.enableConfigControl(isEnabled);
        this.updateAdvancedEnableState();
    }

    private void settingsChanged() {
        this.fFormatCodeButton.setSelection("true".equals(this.fSettings.get("cleanup.format_source_code")));
        this.fAdditionalActionButton.setSelection("true".equals(this.fSettings.get("cleanup.on_save_use_additional_actions")));
        this.updateAdvancedEnableState();
        HashMap<String, String> settings = new HashMap<String, String>(this.fSettings);
        settings.put("cleanup.format_source_code", "false");
        settings.put("cleanup.organize_imports", "false");
        ICleanUp[] cleanUps = CleanUpRefactoring.createCleanUps(settings);
        if (cleanUps.length == 0) {
            this.fSelectedActionsText.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_NoActionEnabled_Info);
        } else {
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            int i = 0;
            while (i < cleanUps.length) {
                String[] descriptions = cleanUps[i].getDescriptions();
                if (descriptions != null) {
                    int j = 0;
                    while (j < descriptions.length) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append('\n');
                        }
                        buf.append(descriptions[j]);
                        ++j;
                    }
                }
                ++i;
            }
            this.fSelectedActionsText.setText(buf.toString());
        }
    }

    private void updateAdvancedEnableState() {
        boolean additionalOptionEnabled = this.isEnabled(this.fContext) && "true".equals(this.fSettings.get("cleanup.on_save_use_additional_actions"));
        boolean additionalEnabled = additionalOptionEnabled && (!"project".equals(this.fContext.getName()) || this.hasSettingsInScope(this.fContext));
        this.fSelectedActionsText.setEnabled(additionalEnabled);
        this.fConfigureButton.setEnabled(additionalEnabled);
    }

    private void configurePreferenceLink(Link link, final IJavaScriptProject javaProject, final String preferenceId, final String propertyId) {
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CleanUpSaveParticipantPreferenceConfiguration.this.fContainer instanceof IWorkbenchPreferenceContainer) {
                    IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)CleanUpSaveParticipantPreferenceConfiguration.this.fContainer;
                    if (javaProject != null) {
                        container.openPage(propertyId, null);
                    } else {
                        container.openPage(preferenceId, null);
                    }
                } else {
                    PreferencesUtil.createPreferenceDialogOn((Shell)CleanUpSaveParticipantPreferenceConfiguration.this.fShell, (String)preferenceId, null, null);
                }
            }
        });
    }

    private void changeSettingsValue(String key, boolean enabled) {
        String value = enabled ? "true" : "false";
        this.fSettings.put(key, value);
        this.settingsChanged();
    }
}

