/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class RenameSelectionState {
    private final Display fDisplay;
    private final Object fElement;
    private final List fParts;
    private final List fSelections;

    public RenameSelectionState(Object element) {
        this.fElement = element;
        this.fParts = new ArrayList();
        this.fSelections = new ArrayList();
        IWorkbenchWindow dw = JavaScriptPlugin.getActiveWorkbenchWindow();
        if (dw == null) {
            this.fDisplay = null;
            return;
        }
        this.fDisplay = dw.getShell().getDisplay();
        IWorkbenchPage page = dw.getActivePage();
        if (page == null) {
            return;
        }
        IViewReference[] vrefs = page.getViewReferences();
        int i = 0;
        while (i < vrefs.length) {
            this.consider(vrefs[i].getPart(false));
            ++i;
        }
        IEditorReference[] refs = page.getEditorReferences();
        int i2 = 0;
        while (i2 < refs.length) {
            this.consider(refs[i2].getPart(false));
            ++i2;
        }
    }

    private void consider(IWorkbenchPart part) {
        ISelectionProvider selectionProvider;
        if (part == null) {
            return;
        }
        ISetSelectionTarget target = null;
        if (!(part instanceof ISetSelectionTarget)) {
            target = (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) {
                return;
            }
        } else {
            target = (ISetSelectionTarget)part;
        }
        if ((selectionProvider = part.getSite().getSelectionProvider()) == null) {
            return;
        }
        ISelection s = selectionProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (!selection.toList().contains(this.fElement)) {
            return;
        }
        this.fParts.add(part);
        this.fSelections.add(selection);
    }

    public void restore(Object newElement) {
        if (this.fDisplay == null) {
            return;
        }
        int i = 0;
        while (i < this.fParts.size()) {
            IStructuredSelection currentSelection = (IStructuredSelection)this.fSelections.get(i);
            boolean changed = false;
            final ISetSelectionTarget target = (ISetSelectionTarget)this.fParts.get(i);
            final IStructuredSelection[] newSelection = new IStructuredSelection[]{currentSelection};
            if (currentSelection instanceof TreeSelection) {
                TreeSelection treeSelection = (TreeSelection)currentSelection;
                TreePath[] paths = treeSelection.getPaths();
                int p = 0;
                while (p < paths.length) {
                    TreePath path = paths[p];
                    if (path.getSegmentCount() > 0 && path.getLastSegment().equals(this.fElement)) {
                        paths[p] = this.createTreePath(path, newElement);
                        changed = true;
                    }
                    ++p;
                }
                if (changed) {
                    newSelection[0] = new TreeSelection(paths, treeSelection.getElementComparer());
                }
            } else {
                Object[] elements = currentSelection.toArray();
                int e = 0;
                while (e < elements.length) {
                    if (elements[e].equals(this.fElement)) {
                        elements[e] = newElement;
                        changed = true;
                    }
                    ++e;
                }
                if (changed) {
                    newSelection[0] = new StructuredSelection(elements);
                }
            }
            if (changed) {
                this.fDisplay.asyncExec(new Runnable(){

                    public void run() {
                        target.selectReveal((ISelection)newSelection[0]);
                    }
                });
            }
            ++i;
        }
    }

    private TreePath createTreePath(TreePath old, Object newElement) {
        int count = old.getSegmentCount();
        Object[] newObjects = new Object[count];
        int i = 0;
        while (i < count - 1) {
            newObjects[i] = old.getSegment(i);
            ++i;
        }
        newObjects[count - 1] = newElement;
        return new TreePath(newObjects);
    }
}

