/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;

public class SequenceCharacterIterator
implements CharacterIterator {
    private int fIndex = -1;
    private final CharSequence fSequence;
    private final int fFirst;
    private final int fLast;

    private void invariant() {
        Assert.isTrue((this.fIndex >= this.fFirst ? 1 : 0) != 0);
        Assert.isTrue((this.fIndex <= this.fLast ? 1 : 0) != 0);
    }

    public SequenceCharacterIterator(CharSequence sequence) {
        this(sequence, 0);
    }

    public SequenceCharacterIterator(CharSequence sequence, int first) throws IllegalArgumentException {
        this(sequence, first, sequence.length());
    }

    public SequenceCharacterIterator(CharSequence sequence, int first, int last) throws IllegalArgumentException {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (first < 0 || first > last) {
            throw new IllegalArgumentException();
        }
        if (last > sequence.length()) {
            throw new IllegalArgumentException();
        }
        this.fSequence = sequence;
        this.fFirst = first;
        this.fLast = last;
        this.fIndex = first;
        this.invariant();
    }

    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    public char last() {
        if (this.fFirst == this.fLast) {
            return this.setIndex(this.getEndIndex());
        }
        return this.setIndex(this.getEndIndex() - 1);
    }

    public char current() {
        if (this.fIndex >= this.fFirst && this.fIndex < this.fLast) {
            return this.fSequence.charAt(this.fIndex);
        }
        return '\uffff';
    }

    public char next() {
        return this.setIndex(Math.min(this.fIndex + 1, this.getEndIndex()));
    }

    public char previous() {
        if (this.fIndex > this.getBeginIndex()) {
            return this.setIndex(this.fIndex - 1);
        }
        return '\uffff';
    }

    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.fIndex = position;
        this.invariant();
        return this.current();
    }

    public int getBeginIndex() {
        return this.fFirst;
    }

    public int getEndIndex() {
        return this.fLast;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

