/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;

public class HierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fSpecialColor;
    private ViewerFilter fFilter;
    private TypeHierarchyLifeCycle fHierarchy;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle lifeCycle) {
        super(317758862524458L, 1);
        this.fHierarchy = lifeCycle;
        this.fFilter = null;
    }

    public ViewerFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ViewerFilter filter) {
        this.fFilter = filter;
    }

    protected boolean isDifferentScope(IType type) {
        if (this.fFilter != null && !this.fFilter.select(null, null, (Object)type)) {
            return true;
        }
        IJavaScriptElement input = this.fHierarchy.getInputElement();
        if (input == null || input.getElementType() == 7) {
            return false;
        }
        IJavaScriptElement parent = type.getAncestor(input.getElementType());
        return !(input.getElementType() == 4 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent));
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IType) {
            Object desc = this.getTypeImageDescriptor((IType)element);
            if (desc != null) {
                if (element.equals(this.fHierarchy.getInputElement())) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = JavaScriptPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else {
            result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        }
        return this.decorateImage(result, element);
    }

    private ImageDescriptor getTypeImageDescriptor(IType type) {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return new JavaScriptElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        int flags = hierarchy.getCachedFlags(type);
        if (flags == -1) {
            return new JavaScriptElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        boolean isInner = type.getDeclaringType() != null;
        ImageDescriptor desc = JavaElementImageProvider.getTypeImageDescriptor(isInner, false, flags, this.isDifferentScope(type));
        int adornmentFlags = 0;
        if (Flags.isAbstract((int)flags)) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)flags)) {
            adornmentFlags |= 8;
        }
        return new JavaScriptElementImageDescriptor(desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
    }

    public Color getForeground(Object element) {
        if (element instanceof IFunction) {
            if (this.fSpecialColor == null) {
                this.fSpecialColor = Display.getCurrent().getSystemColor(10);
            }
            return this.fSpecialColor;
        }
        if (element instanceof IType && this.isDifferentScope((IType)element)) {
            return JFaceResources.getColorRegistry().get("org.eclipse.wst.jsdt.ui.ColoredLabels.qualifier");
        }
        return null;
    }

    private static class FocusDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor fBase;

        public FocusDescriptor(ImageDescriptor base) {
            this.fBase = base;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.getImageData(this.fBase), 0, 0);
            this.drawImage(this.getImageData(JavaPluginImages.DESC_OVR_FOCUS), 0, 0);
        }

        private ImageData getImageData(ImageDescriptor descriptor) {
            ImageData data = descriptor.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
                JavaScriptPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
            }
            return data;
        }

        protected Point getSize() {
            return JavaElementImageProvider.BIG_SIZE;
        }

        public int hashCode() {
            return this.fBase.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && FocusDescriptor.class.equals(object.getClass()) && ((FocusDescriptor)((Object)object)).fBase.equals(this.fBase);
        }
    }
}

