/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.workingsets.SimpleWorkingSetSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public final class ConfigureWorkingSetAssignementAction
extends SelectionDispatchAction {
    private static final String[] VALID_WORKING_SET_IDS = new String[]{"org.eclipse.wst.jsdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
    private WorkingSetModel fWorkingSetModel;
    private final IWorkbenchSite fSite;

    public ConfigureWorkingSetAssignementAction(IWorkbenchSite site) {
        super(site);
        this.fSite = site;
        this.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSets_actionLabel);
        this.setEnabled(false);
    }

    public void setWorkingSetModel(WorkingSetModel workingSetModel) {
        this.fWorkingSetModel = workingSetModel;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        List list = selection.toList();
        for (Object object : list) {
            if (object instanceof IResource || object instanceof IJavaScriptElement) continue;
            return false;
        }
        return true;
    }

    private IAdaptable[] getSelectedElements(IStructuredSelection selection) {
        ArrayList result = new ArrayList();
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof IResource) && !(object instanceof IJavaScriptElement)) continue;
            result.add(object);
        }
        return result.toArray(new IAdaptable[result.size()]);
    }

    public void run(IStructuredSelection selection) {
        IAdaptable[] elements = this.getSelectedElements(selection);
        GrayedCheckedModel model = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(elements, this.getAllWorkingSets());
        WorkingSetModelAwareSelectionDialog dialog = new WorkingSetModelAwareSelectionDialog(this.fSite.getShell(), model, elements);
        if (elements.length == 1) {
            IAdaptable element = elements[0];
            String elementName = element instanceof IResource ? ((IResource)element).getName() : JavaScriptElementLabels.getElementLabel((IJavaScriptElement)element, 0x20000AL);
            dialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_specific, elementName));
        } else {
            dialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_multi, elements.length));
        }
        if (dialog.open() == 0) {
            this.updateWorkingSets(dialog.getSelection(), dialog.getGrayed(), elements);
            this.selectAndReveal(elements);
        }
    }

    private static GrayedCheckedModel createGrayedCheckedModel(IAdaptable[] elements, IWorkingSet[] workingSets) {
        GrayedCheckedModelElement[] result = new GrayedCheckedModelElement[workingSets.length];
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            int checkCount = 0;
            int j = 0;
            while (j < elements.length) {
                IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(set, elements[j]);
                if (adapted != null && ConfigureWorkingSetAssignementAction.contains(set, adapted)) {
                    ++checkCount;
                }
                ++j;
            }
            result[i] = new GrayedCheckedModelElement(set, checkCount, elements.length);
            ++i;
        }
        return new GrayedCheckedModel(result);
    }

    private void updateWorkingSets(IWorkingSet[] newWorkingSets, IWorkingSet[] grayedWorkingSets, IAdaptable[] elements) {
        IAdaptable adapted;
        int j;
        HashSet<IWorkingSet> selectedSets = new HashSet<IWorkingSet>(Arrays.asList(newWorkingSets));
        HashSet<IWorkingSet> grayedSets = new HashSet<IWorkingSet>(Arrays.asList(grayedWorkingSets));
        IWorkingSet[] workingSets = this.getAllWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(workingSet) && !selectedSets.contains(workingSet) && !grayedSets.contains(workingSet)) {
                j = 0;
                while (j < elements.length) {
                    adapted = ConfigureWorkingSetAssignementAction.adapt(workingSet, elements[j]);
                    if (adapted != null && ConfigureWorkingSetAssignementAction.contains(workingSet, adapted)) {
                        ConfigureWorkingSetAssignementAction.remove(workingSet, adapted);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newWorkingSets.length) {
            IWorkingSet set = newWorkingSets[i];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(set) && !grayedSets.contains(set)) {
                j = 0;
                while (j < elements.length) {
                    adapted = ConfigureWorkingSetAssignementAction.adapt(set, elements[j]);
                    if (adapted != null && !ConfigureWorkingSetAssignementAction.contains(set, adapted)) {
                        ConfigureWorkingSetAssignementAction.add(set, adapted);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private IWorkingSet[] getAllWorkingSets() {
        if (this.fWorkingSetModel != null) {
            return this.fWorkingSetModel.getAllWorkingSets();
        }
        return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
    }

    private static boolean isValidWorkingSet(IWorkingSet set) {
        if (set.isAggregateWorkingSet() || !set.isSelfUpdating()) {
            return false;
        }
        if (!set.isVisible()) {
            return false;
        }
        if (!set.isEditable()) {
            return false;
        }
        int i = 0;
        while (i < VALID_WORKING_SET_IDS.length) {
            if (VALID_WORKING_SET_IDS[i].equals(set.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IAdaptable adapt(IWorkingSet set, IAdaptable element) {
        IAdaptable[] adaptedElements = set.adaptElements(new IAdaptable[]{element});
        if (adaptedElements.length != 1) {
            return null;
        }
        return adaptedElements[0];
    }

    private static boolean contains(IWorkingSet set, IAdaptable adaptedElement) {
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(adaptedElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void remove(IWorkingSet workingSet, IAdaptable adaptedElement) {
        HashSet<IAdaptable> set = new HashSet<IAdaptable>(Arrays.asList(workingSet.getElements()));
        set.remove(adaptedElement);
        workingSet.setElements(set.toArray(new IAdaptable[set.size()]));
    }

    private static void add(IWorkingSet workingSet, IAdaptable adaptedElement) {
        IAdaptable[] elements = workingSet.getElements();
        IAdaptable[] newElements = new IAdaptable[elements.length + 1];
        System.arraycopy(elements, 0, newElements, 0, elements.length);
        newElements[elements.length] = adaptedElement;
        workingSet.setElements(newElements);
    }

    private void selectAndReveal(IAdaptable[] elements) {
        PackageExplorerPart explorer = this.getActivePackageExplorer();
        if (explorer != null) {
            explorer.selectReveal((ISelection)new StructuredSelection((Object[])elements));
        }
    }

    private PackageExplorerPart getActivePackageExplorer() {
        IWorkbenchPart activePart;
        IWorkbenchPage page = JavaScriptPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) instanceof PackageExplorerPart) {
            return (PackageExplorerPart)activePart;
        }
        return null;
    }

    private static final class GrayedCheckedModel {
        private GrayedCheckedModelElement[] fElements;
        private final Hashtable fLookup;

        public GrayedCheckedModel(GrayedCheckedModelElement[] elements) {
            this.fElements = elements;
            this.fLookup = new Hashtable();
            int i = 0;
            while (i < elements.length) {
                this.fLookup.put(elements[i].getWorkingSet(), elements[i]);
                ++i;
            }
        }

        public void addElement(GrayedCheckedModelElement element) {
            ArrayList<GrayedCheckedModelElement> list = new ArrayList<GrayedCheckedModelElement>(Arrays.asList(this.fElements));
            list.add(element);
            this.fElements = list.toArray(new GrayedCheckedModelElement[list.size()]);
            this.fLookup.put(element.getWorkingSet(), element);
        }

        public IWorkingSet[] getAll() {
            IWorkingSet[] result = new IWorkingSet[this.fElements.length];
            int i = 0;
            while (i < this.fElements.length) {
                result[i] = this.fElements[i].getWorkingSet();
                ++i;
            }
            return result;
        }

        public GrayedCheckedModelElement getModelElement(IWorkingSet element) {
            return (GrayedCheckedModelElement)this.fLookup.get(element);
        }

        public IWorkingSet[] getChecked() {
            ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
            int i = 0;
            while (i < this.fElements.length) {
                if (this.fElements[i].isChecked()) {
                    result.add(this.fElements[i].getWorkingSet());
                }
                ++i;
            }
            return result.toArray(new IWorkingSet[result.size()]);
        }

        public IWorkingSet[] getGrayed() {
            ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
            int i = 0;
            while (i < this.fElements.length) {
                if (this.fElements[i].isGrayed()) {
                    result.add(this.fElements[i].getWorkingSet());
                }
                ++i;
            }
            return result.toArray(new IWorkingSet[result.size()]);
        }

        public void selectAll() {
            int i = 0;
            while (i < this.fElements.length) {
                this.fElements[i].select();
                ++i;
            }
        }

        public void deselectAll() {
            int i = 0;
            while (i < this.fElements.length) {
                this.fElements[i].deselect();
                ++i;
            }
        }
    }

    private static final class GrayedCheckedModelElement {
        private final IWorkingSet fWorkingSet;
        private final int fElementCount;
        private int fCheckCount;

        public GrayedCheckedModelElement(IWorkingSet workingSet, int checkCount, int elementCount) {
            this.fWorkingSet = workingSet;
            this.fCheckCount = checkCount;
            this.fElementCount = elementCount;
        }

        public IWorkingSet getWorkingSet() {
            return this.fWorkingSet;
        }

        public int getCheckCount() {
            return this.fCheckCount;
        }

        public boolean isGrayed() {
            return this.isChecked() && this.fCheckCount < this.fElementCount;
        }

        public boolean isChecked() {
            return this.fCheckCount > 0;
        }

        public void deselect() {
            this.fCheckCount = 0;
        }

        public void select() {
            this.fCheckCount = this.fElementCount;
        }
    }

    private final class WorkingSetModelAwareSelectionDialog
    extends SimpleWorkingSetSelectionDialog {
        private CheckboxTableViewer fTableViewer;
        private boolean fShowVisibleOnly;
        private GrayedCheckedModel fModel;
        private final IAdaptable[] fElements;

        private WorkingSetModelAwareSelectionDialog(Shell shell, GrayedCheckedModel model, IAdaptable[] elements) {
            super(shell, VALID_WORKING_SET_IDS, model.getChecked());
            this.setTitle(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSetAssignments_title);
            this.fModel = model;
            this.fShowVisibleOnly = true;
            this.fElements = elements;
        }

        public IWorkingSet[] getGrayed() {
            return this.fModel.getGrayed();
        }

        public IWorkingSet[] getSelection() {
            return this.fModel.getChecked();
        }

        protected CheckboxTableViewer createTableViewer(Composite parent) {
            this.fTableViewer = super.createTableViewer(parent);
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
            this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    IWorkingSet element = (IWorkingSet)event.getElement();
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setGrayed((Object)element, false);
                    GrayedCheckedModelElement modelElement = WorkingSetModelAwareSelectionDialog.this.fModel.getModelElement(element);
                    if (event.getChecked()) {
                        modelElement.select();
                    } else {
                        modelElement.deselect();
                    }
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.update((Object)element, null);
                }
            });
            this.createShowVisibleOnly(parent);
            return this.fTableViewer;
        }

        protected void selectAll() {
            super.selectAll();
            this.fModel.selectAll();
            this.fTableViewer.setGrayedElements(new Object[0]);
            this.fTableViewer.refresh();
        }

        protected void deselectAll() {
            super.deselectAll();
            this.fModel.deselectAll();
            this.fTableViewer.setGrayedElements(new Object[0]);
            this.fTableViewer.refresh();
        }

        protected void addNewWorkingSet(IWorkingSet workingSet) {
            if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel != null) {
                IWorkingSet[] workingSets = ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getActiveWorkingSets();
                IWorkingSet[] activeWorkingSets = new IWorkingSet[workingSets.length + 1];
                activeWorkingSets[0] = workingSet;
                System.arraycopy(workingSets, 0, activeWorkingSets, 1, workingSets.length);
                ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.setActiveWorkingSets(activeWorkingSets);
            }
            int checkCount = 0;
            int i = 0;
            while (i < this.fElements.length) {
                IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(workingSet, this.fElements[i]);
                if (adapted != null && ConfigureWorkingSetAssignementAction.contains(workingSet, adapted)) {
                    ++checkCount;
                }
                ++i;
            }
            this.fModel.addElement(new GrayedCheckedModelElement(workingSet, checkCount, this.fElements.length));
            this.fTableViewer.setInput((Object)this.fModel.getAll());
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)workingSet));
        }

        protected ViewerFilter createTableFilter() {
            final ViewerFilter superFilter = super.createTableFilter();
            return new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (!superFilter.select(viewer, parentElement, element)) {
                        return false;
                    }
                    IWorkingSet set = (IWorkingSet)element;
                    if (!ConfigureWorkingSetAssignementAction.isValidWorkingSet(set)) {
                        return false;
                    }
                    if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null) {
                        return true;
                    }
                    if (WorkingSetModelAwareSelectionDialog.this.fShowVisibleOnly) {
                        return ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.isActiveWorkingSet(set);
                    }
                    return true;
                }
            };
        }

        protected ViewerSorter createTableSorter() {
            final ViewerSorter superSorter = super.createTableSorter();
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null) {
                        return superSorter.compare(viewer, e1, e2);
                    }
                    IWorkingSet[] activeWorkingSets = ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getActiveWorkingSets();
                    int i = 0;
                    while (i < activeWorkingSets.length) {
                        IWorkingSet active = activeWorkingSets[i];
                        if (active == e1) {
                            return -1;
                        }
                        if (active == e2) {
                            return 1;
                        }
                        ++i;
                    }
                    return superSorter.compare(viewer, e1, e2);
                }
            };
        }

        protected LabelProvider createTableLabelProvider() {
            final LabelProvider superLabelProvider = super.createTableLabelProvider();
            return new LabelProvider(){

                public String getText(Object element) {
                    String superText = superLabelProvider.getText(element);
                    if (superText == null) {
                        return null;
                    }
                    GrayedCheckedModelElement modelElement = WorkingSetModelAwareSelectionDialog.this.fModel.getModelElement((IWorkingSet)element);
                    if (!modelElement.isGrayed()) {
                        return superText;
                    }
                    return String.valueOf(superText) + Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_XofY_label, new Object[]{modelElement.getCheckCount(), WorkingSetModelAwareSelectionDialog.this.fElements.length});
                }
            };
        }

        private void createShowVisibleOnly(Composite parent) {
            if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null) {
                return;
            }
            Composite bar = new Composite(parent, 0);
            bar.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            bar.setLayout((Layout)gridLayout);
            final Button showVisibleOnly = new Button(bar, 32);
            showVisibleOnly.setSelection(this.fShowVisibleOnly);
            showVisibleOnly.setLayoutData((Object)new GridData(16384, 4, false, true));
            showVisibleOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkingSetModelAwareSelectionDialog.this.fShowVisibleOnly = showVisibleOnly.getSelection();
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.refresh();
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setCheckedElements((Object[])WorkingSetModelAwareSelectionDialog.this.fModel.getChecked());
                    WorkingSetModelAwareSelectionDialog.this.fTableViewer.setGrayedElements((Object[])WorkingSetModelAwareSelectionDialog.this.fModel.getGrayed());
                }
            });
            Link ppwsLink = new Link(bar, 0);
            ppwsLink.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_OnlyShowVisible_link);
            ppwsLink.setLayoutData((Object)new GridData(4, 4, true, true));
            ppwsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>(Arrays.asList(ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getAllWorkingSets()));
                    IWorkingSet[] activeWorkingSets = ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getActiveWorkingSets();
                    WorkingSetConfigurationDialog dialog = new WorkingSetConfigurationDialog(WorkingSetModelAwareSelectionDialog.this.getShell(), workingSets.toArray(new IWorkingSet[workingSets.size()]), activeWorkingSets);
                    dialog.setSelection(activeWorkingSets);
                    if (dialog.open() == 0) {
                        IWorkingSet[] selection = dialog.getSelection();
                        ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.setActiveWorkingSets(selection);
                    }
                    WorkingSetModelAwareSelectionDialog.this.recalculateCheckedState();
                }
            });
        }

        private void recalculateCheckedState() {
            this.fModel = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(this.fElements, ConfigureWorkingSetAssignementAction.this.getAllWorkingSets());
            this.fTableViewer.setInput((Object)this.fModel.getAll());
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
        }
    }
}

