/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MakeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private IPath pathPrefix;
    private WorkbenchLabelProvider fLableProvider = new WorkbenchLabelProvider();

    public MakeLabelProvider() {
        this(null);
    }

    public MakeLabelProvider(IPath removePrefix) {
        this.pathPrefix = removePrefix;
    }

    public Image getImage(Object obj) {
        Image image = null;
        if (obj instanceof TargetSourceContainer) {
            return CDTSharedImages.getImage((String)"icons/tobj16/sroot_obj.png");
        }
        if (obj instanceof IContainer) {
            if (!(obj instanceof IProject) && MakeContentProvider.isSourceEntry((IResource)((IContainer)obj))) {
                return CDTSharedImages.getImage((String)"icons/tobj16/sroot_obj.png");
            }
            return this.fLableProvider.getImage(obj);
        }
        if (obj instanceof IMakeTarget) {
            return MakeUIImages.getImage("icons/obj16/target_obj.gif");
        }
        return image;
    }

    public String getText(Object obj) {
        if (obj instanceof TargetSourceContainer) {
            IContainer container = ((TargetSourceContainer)obj).getContainer();
            IPath path = container.getFullPath();
            path = path.removeFirstSegments(1);
            return path.toString();
        }
        if (obj instanceof IContainer) {
            return this.fLableProvider.getText(obj);
        }
        if (obj instanceof IMakeTarget) {
            return ((IMakeTarget)obj).getName();
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        this.fLableProvider.dispose();
    }

    public Image getColumnImage(Object obj, int columnIndex) {
        return columnIndex == 0 ? this.getImage(obj) : null;
    }

    public String getColumnText(Object obj, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(obj);
            }
            case 1: {
                if (!(obj instanceof IMakeTarget) || this.pathPrefix == null) break;
                IPath targetPath = ((IMakeTarget)obj).getContainer().getProjectRelativePath();
                if (this.pathPrefix.isPrefixOf(targetPath)) {
                    targetPath = targetPath.removeFirstSegments(this.pathPrefix.segmentCount());
                }
                if (targetPath.segmentCount() <= 0) break;
                return targetPath.toString();
            }
        }
        return "";
    }
}

