/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.IncludeExportPatterns;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.ITokenSequence;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenForDigraph;
import org.eclipse.cdt.internal.core.parser.scanner.TokenWithImage;

public final class Lexer
implements ITokenSequence {
    public static final int tBEFORE_INPUT = -100;
    public static final int tNEWLINE = -99;
    public static final int tQUOTE_HEADER_NAME = -98;
    public static final int tSYSTEM_HEADER_NAME = -97;
    public static final int tOTHER_CHARACTER = -96;
    private static final int END_OF_INPUT = -1;
    private static final int ORIGIN_LEXER = 1;
    private final LexerOptions fOptions;
    private boolean fSupportContentAssist = false;
    private final ILexerLog fLog;
    private final Object fSource;
    private final AbstractCharArray fInput;
    private final int fStart;
    private int fLimit;
    private int fOffset;
    private int fEndOffset;
    private int fCharPhase3;
    private boolean fInsideIncludeDirective = false;
    private Token fToken;
    private Token fLastToken;
    private int fMarkPhase3Offset;
    private int fMarkPhase3EndOffset;
    private int fMarkPhase3PrefetchedChar;
    private int fMarkOffset;
    private int fMarkEndOffset;
    private int fMarkPrefetchedChar;
    private boolean fMarkInsideIncludeDirective;
    private Token fMarkToken;
    private Token fMarkLastToken;

    public Lexer(char[] input, LexerOptions options, ILexerLog log, Object source) {
        this(new CharArray(input), 0, input.length, options, log, source);
    }

    public Lexer(AbstractCharArray input, LexerOptions options, ILexerLog log, Object source) {
        this(input, 0, input.tryGetLength(), options, log, source);
    }

    public Lexer(AbstractCharArray input, int start, int end, LexerOptions options, ILexerLog log, Object source) {
        this.fInput = input;
        this.fOffset = this.fEndOffset = start;
        this.fStart = this.fEndOffset;
        this.fLimit = end;
        this.fOptions = options;
        this.fLog = log;
        this.fSource = source;
        this.fLastToken = this.fToken = new Token(-100, source, start, start);
        this.nextCharPhase3();
    }

    private boolean isValidOffset(int pos) {
        if (this.fLimit < 0) {
            return this.fInput.isValidOffset(pos);
        }
        return pos < this.fLimit;
    }

    public Object getSource() {
        return this.fSource;
    }

    public void setContentAssistMode(int offset) {
        this.fSupportContentAssist = true;
        if (this.isValidOffset(offset)) {
            this.fLimit = offset;
        }
        this.fOffset = this.fEndOffset = this.fStart;
        this.nextCharPhase3();
    }

    public boolean isContentAssistMode() {
        return this.fSupportContentAssist;
    }

    public void setInsideIncludeDirective(boolean val) {
        this.fInsideIncludeDirective = val;
    }

    @Override
    public Token currentToken() {
        return this.fToken;
    }

    @Override
    public int getLastEndOffset() {
        return this.fLastToken.getEndOffset();
    }

    @Override
    public Token nextToken() throws OffsetLimitReachedException {
        this.fLastToken = this.fToken;
        this.fToken = this.fetchToken();
        return this.fToken;
    }

    public boolean currentTokenIsFirstOnLine() {
        int type = this.fLastToken.getType();
        return type == -99 || type == -100;
    }

    public final int consumeLine(int origin) throws OffsetLimitReachedException {
        Token t = this.fToken;
        Token lt = null;
        while (true) {
            switch (t.getType()) {
                case 140: {
                    if (lt != null) {
                        this.fLastToken = lt;
                    }
                    this.fToken = t;
                    throw new OffsetLimitReachedException(origin, t);
                }
                case 144: {
                    if (this.fSupportContentAssist) {
                        t.setType(140);
                        throw new OffsetLimitReachedException(origin, t);
                    }
                }
                case -99: {
                    this.fToken = t;
                    if (lt != null) {
                        this.fLastToken = lt;
                    }
                    return this.getLastEndOffset();
                }
            }
            lt = t;
            t = this.fetchToken();
        }
    }

    public Token nextDirective() throws OffsetLimitReachedException {
        Token t0;
        int tt0;
        int tt1;
        Token t1 = this.fToken;
        do {
            t0 = t1;
        } while ((tt1 = (t1 = this.fetchToken()).getType()) != 144 && tt1 != 140 && (tt1 != 138 || (tt0 = t0.getType()) != -99 && tt0 != -100));
        this.fLastToken = t0;
        this.fToken = t1;
        return this.fToken;
    }

    private Token fetchToken() throws OffsetLimitReachedException {
        int start;
        block110: while (true) {
            start = this.fOffset;
            int c = this.fCharPhase3;
            int d = this.nextCharPhase3();
            switch (c) {
                case -1: {
                    return this.newToken(144, start);
                }
                case 10: {
                    this.fInsideIncludeDirective = false;
                    return this.newToken(-99, start);
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    continue block110;
                }
                case 76: {
                    switch (d) {
                        case 82: {
                            if (!this.fOptions.fSupportRawStringLiterals) break;
                            this.markPhase3();
                            if (this.nextCharPhase3() == 34) {
                                this.nextCharPhase3();
                                return this.rawStringLiteral(start, 3, 131);
                            }
                            this.restorePhase3();
                            break;
                        }
                        case 34: {
                            this.nextCharPhase3();
                            return this.stringLiteral(start, 2, 131);
                        }
                        case 39: {
                            this.nextCharPhase3();
                            return this.charLiteral(start, 133);
                        }
                    }
                    return this.identifier(start, 1);
                }
                case 85: 
                case 117: {
                    if (this.fOptions.fSupportUTFLiterals) {
                        switch (d) {
                            case 82: {
                                if (!this.fOptions.fSupportRawStringLiterals) break;
                                this.markPhase3();
                                if (this.nextCharPhase3() == 34) {
                                    this.nextCharPhase3();
                                    return this.rawStringLiteral(start, 3, c == 117 ? 5000 : 5001);
                                }
                                this.restorePhase3();
                                break;
                            }
                            case 34: {
                                this.nextCharPhase3();
                                return this.stringLiteral(start, 2, c == 117 ? 5000 : 5001);
                            }
                            case 39: {
                                this.nextCharPhase3();
                                return this.charLiteral(start, c == 117 ? 5002 : 5003);
                            }
                            case 56: {
                                if (c != 117) break;
                                this.markPhase3();
                                switch (this.nextCharPhase3()) {
                                    case 82: {
                                        if (!this.fOptions.fSupportRawStringLiterals || this.nextCharPhase3() != 34) break;
                                        this.nextCharPhase3();
                                        return this.rawStringLiteral(start, 4, 130);
                                    }
                                    case 34: {
                                        this.nextCharPhase3();
                                        return this.stringLiteral(start, 3, 130);
                                    }
                                }
                                this.restorePhase3();
                            }
                        }
                    }
                    return this.identifier(start, 1);
                }
                case 82: {
                    if (this.fOptions.fSupportRawStringLiterals && d == 34) {
                        this.nextCharPhase3();
                        return this.rawStringLiteral(start, 2, 130);
                    }
                    return this.identifier(start, 1);
                }
                case 34: {
                    if (this.fInsideIncludeDirective) {
                        return this.headerName(start, true);
                    }
                    return this.stringLiteral(start, 1, 130);
                }
                case 39: {
                    return this.charLiteral(start, 132);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 83: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    return this.identifier(start, 1);
                }
                case 36: {
                    if (!this.fOptions.fSupportDollarInIdentifiers) break block110;
                    return this.identifier(start, 1);
                }
                case 64: {
                    if (!this.fOptions.fSupportAtSignInIdentifiers) break block110;
                    return this.identifier(start, 1);
                }
                case 92: {
                    switch (d) {
                        case 85: 
                        case 117: {
                            this.nextCharPhase3();
                            return this.identifier(start, 2);
                        }
                    }
                    return this.newToken(-96, start, 1);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.number(start, 1, false);
                }
                case 46: {
                    switch (d) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.nextCharPhase3();
                            return this.number(start, 2, true);
                        }
                        case 46: {
                            this.markPhase3();
                            if (this.nextCharPhase3() == 46) {
                                this.nextCharPhase3();
                                return this.newToken(48, start);
                            }
                            this.restorePhase3();
                            break;
                        }
                        case 42: {
                            this.nextCharPhase3();
                            return this.newToken(49, start);
                        }
                    }
                    return this.newToken(50, start);
                }
                case 35: {
                    if (d == 35) {
                        this.nextCharPhase3();
                        return this.newToken(139, start);
                    }
                    return this.newToken(138, start);
                }
                case 123: {
                    return this.newToken(12, start);
                }
                case 125: {
                    return this.newToken(13, start);
                }
                case 91: {
                    return this.newToken(10, start);
                }
                case 93: {
                    return this.newToken(11, start);
                }
                case 40: {
                    return this.newToken(8, start);
                }
                case 41: {
                    return this.newToken(9, start);
                }
                case 59: {
                    return this.newToken(5, start);
                }
                case 58: {
                    switch (d) {
                        case 58: {
                            this.nextCharPhase3();
                            return this.newToken(3, start);
                        }
                        case 62: {
                            this.nextCharPhase3();
                            return this.newDigraphToken(11, start);
                        }
                    }
                    return this.newToken(4, start);
                }
                case 63: {
                    return this.newToken(7, start);
                }
                case 43: {
                    switch (d) {
                        case 43: {
                            this.nextCharPhase3();
                            return this.newToken(15, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(14, start);
                        }
                    }
                    return this.newToken(16, start);
                }
                case 45: {
                    switch (d) {
                        case 62: {
                            int e = this.nextCharPhase3();
                            if (e == 42) {
                                this.nextCharPhase3();
                                return this.newToken(19, start);
                            }
                            return this.newToken(20, start);
                        }
                        case 45: {
                            this.nextCharPhase3();
                            return this.newToken(18, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(17, start);
                        }
                    }
                    return this.newToken(21, start);
                }
                case 42: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(22, start);
                    }
                    return this.newToken(23, start);
                }
                case 47: {
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(51, start);
                        }
                        case 47: {
                            this.nextCharPhase3();
                            this.lineComment(start);
                            continue block110;
                        }
                        case 42: {
                            this.blockComment(start, '*');
                            continue block110;
                        }
                        case 37: {
                            if (!this.fOptions.fSupportSlashPercentComments) break;
                            this.blockComment(start, '%');
                            continue block110;
                        }
                    }
                    return this.newToken(52, start);
                }
                case 37: {
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(24, start);
                        }
                        case 62: {
                            this.nextCharPhase3();
                            return this.newDigraphToken(13, start);
                        }
                        case 58: {
                            int e = this.nextCharPhase3();
                            if (e == 37) {
                                this.markPhase3();
                                if (this.nextCharPhase3() == 58) {
                                    this.nextCharPhase3();
                                    return this.newDigraphToken(139, start);
                                }
                                this.restorePhase3();
                            }
                            return this.newDigraphToken(138, start);
                        }
                    }
                    return this.newToken(25, start);
                }
                case 94: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(26, start);
                    }
                    return this.newToken(27, start);
                }
                case 38: {
                    switch (d) {
                        case 38: {
                            this.nextCharPhase3();
                            return this.newToken(29, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(28, start);
                        }
                    }
                    return this.newToken(30, start);
                }
                case 124: {
                    switch (d) {
                        case 124: {
                            this.nextCharPhase3();
                            return this.newToken(32, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(31, start);
                        }
                    }
                    return this.newToken(33, start);
                }
                case 126: {
                    return this.newToken(34, start);
                }
                case 33: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(35, start);
                    }
                    return this.newToken(36, start);
                }
                case 61: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(37, start);
                    }
                    return this.newToken(38, start);
                }
                case 60: {
                    if (this.fInsideIncludeDirective) {
                        return this.headerName(start, false);
                    }
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(41, start);
                        }
                        case 60: {
                            int e = this.nextCharPhase3();
                            if (e == 61) {
                                this.nextCharPhase3();
                                return this.newToken(47, start);
                            }
                            return this.newToken(40, start);
                        }
                        case 63: {
                            if (!this.fOptions.fSupportMinAndMax) break;
                            this.nextCharPhase3();
                            return this.newToken(153, start);
                        }
                        case 58: {
                            this.markPhase3();
                            if (this.nextCharPhase3() != 58) {
                                return this.newDigraphToken(10, start);
                            }
                            switch (this.nextCharPhase3()) {
                                case 58: 
                                case 62: {
                                    this.restorePhase3();
                                    this.nextCharPhase3();
                                    return this.newDigraphToken(10, start);
                                }
                            }
                            this.restorePhase3();
                            break;
                        }
                        case 37: {
                            this.nextCharPhase3();
                            return this.newDigraphToken(12, start);
                        }
                    }
                    return this.newToken(42, start);
                }
                case 62: {
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(45, start);
                        }
                        case 62: {
                            int e = this.nextCharPhase3();
                            if (e == 61) {
                                this.nextCharPhase3();
                                return this.newToken(43, start);
                            }
                            return this.newToken(44, start);
                        }
                        case 63: {
                            if (!this.fOptions.fSupportMinAndMax) break;
                            this.nextCharPhase3();
                            return this.newToken(152, start);
                        }
                    }
                    return this.newToken(46, start);
                }
                case 44: {
                    return this.newToken(6, start);
                }
                default: {
                    if (!Character.isUnicodeIdentifierStart((char)c)) break block110;
                    return this.identifier(start, 1);
                }
            }
            break;
        }
        return this.newToken(-96, start, 1);
    }

    private Token newToken(int kind, int offset) {
        return new Token(kind, this.fSource, offset, this.fOffset);
    }

    private Token newDigraphToken(int kind, int offset) {
        return new TokenForDigraph(kind, this.fSource, offset, this.fOffset);
    }

    private Token newToken(int kind, int offset, int imageLength) {
        char[] image;
        int endOffset = this.fOffset;
        int sourceLen = endOffset - offset;
        if (sourceLen != imageLength) {
            image = this.getCharImage(offset, endOffset, imageLength);
        } else {
            image = new char[imageLength];
            this.fInput.arraycopy(offset, image, 0, imageLength);
        }
        return new TokenWithImage(kind, this.fSource, offset, endOffset, image);
    }

    private void handleProblem(int problemID, char[] arg, int offset) {
        this.fLog.handleProblem(problemID, arg, offset, this.fOffset);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Token headerName(int start, boolean expectQuotes) throws OffsetLimitReachedException {
        int n;
        int length = 1;
        boolean done = false;
        int c = this.fCharPhase3;
        block6: while (!done) {
            switch (c) {
                case -1: {
                    if (this.fSupportContentAssist) {
                        int n2;
                        if (expectQuotes) {
                            n2 = -98;
                            throw new OffsetLimitReachedException(1, this.newToken(n2, start, length));
                        }
                        n2 = -97;
                        throw new OffsetLimitReachedException(1, this.newToken(n2, start, length));
                    }
                }
                case 10: {
                    this.handleProblem(0x1000002, this.getInputChars(start, this.fOffset), start);
                    break block6;
                }
                case 34: {
                    done = expectQuotes;
                    break;
                }
                case 62: {
                    done = !expectQuotes;
                }
            }
            ++length;
            c = this.nextCharPhase3();
        }
        if (expectQuotes) {
            n = -98;
            return this.newToken(n, start, length);
        }
        n = -97;
        return this.newToken(n, start, length);
    }

    private void blockComment(int start, char trigger) {
        int pos = this.fEndOffset;
        while (this.isValidOffset(pos)) {
            if (this.fInput.get(pos++) != trigger) continue;
            this.fEndOffset = pos;
            if (this.nextCharPhase3() != 47) continue;
            this.nextCharPhase3();
            this.fLog.handleComment(true, start, this.fOffset, this.fInput);
            return;
        }
        this.fCharPhase3 = -1;
        this.fOffset = this.fEndOffset = pos;
        this.fLog.handleComment(true, start, pos, this.fInput);
    }

    private void lineComment(int start) {
        int c = this.fCharPhase3;
        while (true) {
            switch (c) {
                case -1: 
                case 10: {
                    this.fLog.handleComment(false, start, this.fOffset, this.fInput);
                    return;
                }
            }
            c = this.nextCharPhase3();
        }
    }

    private boolean isIdentifierStart(int c) {
        return Character.isLetter((char)c) || Character.isDigit((char)c) || Character.isUnicodeIdentifierPart(c) || this.fOptions.fSupportDollarInIdentifiers && c == 36 || this.fOptions.fSupportAtSignInIdentifiers && c == 64 || c == 95;
    }

    private Token stringLiteral(int start, int length, int tokenType) throws OffsetLimitReachedException {
        boolean escaped = false;
        boolean done = false;
        int c = this.fCharPhase3;
        block6: while (!done) {
            switch (c) {
                case -1: {
                    if (this.fSupportContentAssist) {
                        throw new OffsetLimitReachedException(1, this.newToken(tokenType, start, length));
                    }
                }
                case 10: {
                    this.handleProblem(0x1000002, this.getInputChars(start, this.fOffset), start);
                    break block6;
                }
                case 92: {
                    escaped = !escaped;
                    break;
                }
                case 34: {
                    if (!escaped) {
                        done = true;
                    }
                    escaped = false;
                    break;
                }
                default: {
                    escaped = false;
                }
            }
            ++length;
            c = this.nextCharPhase3();
        }
        if (this.fOptions.fSupportUserDefinedLiterals && this.isUDLSuffixStart(c)) {
            Token t = this.identifier(start + length, 0);
            tokenType = 51002;
            length += t.getLength();
        }
        return this.newToken(tokenType, start, length);
    }

    private boolean isUDLSuffixStart(int c) {
        return c == 95;
    }

    private Token rawStringLiteral(int start, int length, int tokenType) throws OffsetLimitReachedException {
        int offset;
        int delimOffset;
        int delimEndOffset = delimOffset = this.fOffset;
        while (true) {
            if (!this.fInput.isValidOffset(delimEndOffset)) {
                offset = delimEndOffset;
                break;
            }
            if (this.fInput.get(delimEndOffset) == '(') {
                offset = delimEndOffset + 1;
                break;
            }
            ++delimEndOffset;
        }
        int delimLength = delimEndOffset - delimOffset;
        while (true) {
            int endingDoubleQuoteOffset;
            if (!this.fInput.isValidOffset(offset)) {
                this.handleProblem(0x1000002, this.getInputChars(start, offset), start);
                break;
            }
            char c = this.fInput.get(offset);
            if (c == ')' && this.fInput.isValidOffset(endingDoubleQuoteOffset = offset + delimLength + 1) && this.fInput.get(endingDoubleQuoteOffset) == '\"') {
                boolean prefixMatches = true;
                int i = 0;
                while (i < delimLength) {
                    if (this.fInput.get(offset + i + 1) != this.fInput.get(delimOffset + i)) {
                        prefixMatches = false;
                        break;
                    }
                    ++i;
                }
                if (prefixMatches) {
                    offset = endingDoubleQuoteOffset + 1;
                    break;
                }
            }
            ++offset;
        }
        this.fOffset = offset - 1;
        this.fEndOffset = offset;
        this.fCharPhase3 = 0;
        this.nextCharPhase3();
        if (this.fOptions.fSupportUserDefinedLiterals && this.isUDLSuffixStart(this.fCharPhase3)) {
            Token t = this.identifier(offset, 0);
            tokenType = 51002;
            offset += t.getLength();
        }
        return this.newToken(tokenType, start, offset - start);
    }

    private Token charLiteral(int start, int tokenType) throws OffsetLimitReachedException {
        boolean escaped = false;
        boolean done = false;
        int length = tokenType == 132 ? 1 : 2;
        int c = this.fCharPhase3;
        block6: while (!done) {
            switch (c) {
                case -1: {
                    if (this.fSupportContentAssist) {
                        throw new OffsetLimitReachedException(1, this.newToken(tokenType, start, length));
                    }
                }
                case 10: {
                    this.handleProblem(0x1000001, this.getInputChars(start, this.fOffset), start);
                    break block6;
                }
                case 92: {
                    escaped = !escaped;
                    break;
                }
                case 39: {
                    if (!escaped) {
                        done = true;
                    }
                    escaped = false;
                    break;
                }
                default: {
                    escaped = false;
                }
            }
            ++length;
            c = this.nextCharPhase3();
        }
        if (this.fOptions.fSupportUserDefinedLiterals && this.isIdentifierStart(c)) {
            Token t = this.identifier(start + length, 0);
            tokenType = 51003;
            length += t.getLength();
        }
        return this.newToken(tokenType, start, length);
    }

    private Token identifier(int start, int length) {
        int tokenKind = 1;
        boolean isPartOfIdentifier = true;
        int c = this.fCharPhase3;
        while (true) {
            block0 : switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    break;
                }
                case 92: {
                    this.markPhase3();
                    switch (this.nextCharPhase3()) {
                        case 85: 
                        case 117: {
                            ++length;
                            break block0;
                        }
                    }
                    this.restorePhase3();
                    isPartOfIdentifier = false;
                    break;
                }
                case -1: {
                    if (this.fSupportContentAssist) {
                        tokenKind = 140;
                    }
                    isPartOfIdentifier = false;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    isPartOfIdentifier = false;
                    break;
                }
                case 36: {
                    isPartOfIdentifier = this.fOptions.fSupportDollarInIdentifiers;
                    break;
                }
                case 64: {
                    isPartOfIdentifier = this.fOptions.fSupportAtSignInIdentifiers;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 91: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    isPartOfIdentifier = false;
                    break;
                }
                default: {
                    isPartOfIdentifier = Character.isUnicodeIdentifierPart((char)c);
                }
            }
            if (!isPartOfIdentifier) break;
            ++length;
            c = this.nextCharPhase3();
        }
        return this.newToken(tokenKind, start, length);
    }

    private Token number(int start, int length, boolean isFloat) throws OffsetLimitReachedException {
        boolean isPartOfNumber = true;
        boolean isHex = false;
        int c = this.fCharPhase3;
        block15: while (true) {
            block0 : switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 121: 
                case 122: {
                    break;
                }
                case 88: 
                case 120: {
                    isHex = !isFloat;
                    break;
                }
                case 46: {
                    isFloat = true;
                    break;
                }
                case 69: 
                case 101: {
                    if (isHex) break;
                }
                case 80: 
                case 112: {
                    ++length;
                    c = this.nextCharPhase3();
                    switch (c) {
                        case 43: 
                        case 45: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            isFloat = true;
                            isHex = false;
                            ++length;
                            c = this.nextCharPhase3();
                        }
                    }
                    continue block15;
                }
                case 92: {
                    this.markPhase3();
                    switch (this.nextCharPhase3()) {
                        case 85: 
                        case 117: {
                            ++length;
                            break block0;
                        }
                    }
                    this.restorePhase3();
                    isPartOfNumber = false;
                    break;
                }
                case -1: {
                    if (this.fSupportContentAssist) {
                        throw new OffsetLimitReachedException(1, this.newToken(isFloat ? 129 : 2, start, length));
                    }
                    isPartOfNumber = false;
                    break;
                }
                default: {
                    isPartOfNumber = false;
                }
            }
            if (!isPartOfNumber) break;
            c = this.nextCharPhase3();
            ++length;
        }
        return this.newToken(isFloat ? 129 : 2, start, length);
    }

    private void markPhase3() {
        this.fMarkPhase3Offset = this.fOffset;
        this.fMarkPhase3EndOffset = this.fEndOffset;
        this.fMarkPhase3PrefetchedChar = this.fCharPhase3;
    }

    private void restorePhase3() {
        this.fOffset = this.fMarkPhase3Offset;
        this.fEndOffset = this.fMarkPhase3EndOffset;
        this.fCharPhase3 = this.fMarkPhase3PrefetchedChar;
    }

    private int nextCharPhase3() {
        char c;
        int pos = this.fEndOffset;
        block5: while (true) {
            if (!this.isValidOffset(pos + 1)) {
                if (!this.isValidOffset(pos)) {
                    this.fOffset = pos;
                    this.fEndOffset = pos;
                    this.fCharPhase3 = -1;
                    return -1;
                }
                this.fOffset = pos;
                this.fEndOffset = pos + 1;
                this.fCharPhase3 = this.fInput.get(pos);
                return this.fCharPhase3;
            }
            c = this.fInput.get(pos);
            this.fOffset = pos++;
            this.fEndOffset = pos;
            this.fCharPhase3 = c;
            switch (c) {
                case '\r': {
                    if (this.fInput.get(pos) == '\n') {
                        this.fEndOffset = pos + 1;
                        this.fCharPhase3 = 10;
                        return 10;
                    }
                    this.fCharPhase3 = 10;
                    return 10;
                }
                case '?': {
                    if (this.fInput.get(pos) != '?' || !this.isValidOffset(pos + 1)) {
                        return c;
                    }
                    char trigraph = this.checkTrigraph(this.fInput.get(pos + 1));
                    if (trigraph == '\u0000') {
                        return c;
                    }
                    if (trigraph != '\\') {
                        this.fEndOffset = pos + 2;
                        this.fCharPhase3 = trigraph;
                        return trigraph;
                    }
                    pos += 2;
                }
                case '\\': {
                    int lsPos = this.findEndOfLineSpliceSequence(pos);
                    if (lsPos > pos) {
                        pos = lsPos;
                        continue block5;
                    }
                    this.fEndOffset = pos;
                    this.fCharPhase3 = 92;
                    return 92;
                }
            }
            break;
        }
        return c;
    }

    private char checkTrigraph(char c) {
        switch (c) {
            case '=': {
                return '#';
            }
            case '\'': {
                return '^';
            }
            case '(': {
                return '[';
            }
            case ')': {
                return ']';
            }
            case '!': {
                return '|';
            }
            case '<': {
                return '{';
            }
            case '>': {
                return '}';
            }
            case '-': {
                return '~';
            }
            case '/': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private int findEndOfLineSpliceSequence(int pos) {
        boolean haveBackslash = true;
        int result = -1;
        block6: while (this.isValidOffset(pos)) {
            switch (this.fInput.get(pos++)) {
                case '\n': {
                    if (haveBackslash) {
                        result = pos;
                        haveBackslash = false;
                        break;
                    }
                    return result;
                }
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (haveBackslash) continue block6;
                    return result;
                }
                case '?': {
                    if (!this.isValidOffset(pos + 1) || this.fInput.get(pos) != '?' || this.fInput.get(++pos) != '/') {
                        return result;
                    }
                }
                case '\\': {
                    if (!haveBackslash) {
                        haveBackslash = true;
                        break;
                    }
                    return result;
                }
                default: {
                    return result;
                }
            }
        }
        return result;
    }

    public char[] getInputChars(int offset, int endOffset) {
        int length = endOffset - offset;
        if (length <= 0) {
            return CharArrayUtils.EMPTY;
        }
        char[] result = new char[length];
        this.fInput.arraycopy(offset, result, 0, length);
        return result;
    }

    AbstractCharArray getInput() {
        return this.fInput;
    }

    private char[] getCharImage(int offset, int endOffset, int imageLength) {
        char[] result = new char[imageLength];
        this.markPhase3();
        this.fEndOffset = offset;
        int idx = 0;
        while (idx < imageLength) {
            result[idx] = (char)this.nextCharPhase3();
            ++idx;
        }
        this.restorePhase3();
        return result;
    }

    public void saveState() {
        this.fMarkOffset = this.fOffset;
        this.fMarkEndOffset = this.fEndOffset;
        this.fMarkPrefetchedChar = this.fCharPhase3;
        this.fMarkInsideIncludeDirective = this.fInsideIncludeDirective;
        this.fMarkToken = this.fToken;
        this.fMarkLastToken = this.fLastToken;
    }

    public void restoreState() {
        this.fOffset = this.fMarkOffset;
        this.fEndOffset = this.fMarkEndOffset;
        this.fCharPhase3 = this.fMarkPrefetchedChar;
        this.fInsideIncludeDirective = this.fMarkInsideIncludeDirective;
        this.fToken = this.fMarkToken;
        this.fLastToken = this.fMarkLastToken;
    }

    public static final class LexerOptions
    implements Cloneable {
        public boolean fSupportDollarInIdentifiers = true;
        public boolean fSupportAtSignInIdentifiers = true;
        public boolean fSupportMinAndMax = true;
        public boolean fCreateImageLocations = true;
        public boolean fSupportSlashPercentComments = false;
        public boolean fSupportUTFLiterals = true;
        public boolean fSupportRawStringLiterals = false;
        public boolean fSupportUserDefinedLiterals = false;
        public IncludeExportPatterns fIncludeExportPatterns;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

