/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.TextStatusContextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaScriptTextTools;

public class JavaStatusContextViewer
extends TextStatusContextViewer {
    public void createControl(Composite parent) {
        super.createControl(parent);
        SourceViewer viewer = this.getSourceViewer();
        viewer.unconfigure();
        IPreferenceStore store = JavaScriptPlugin.getDefault().getCombinedPreferenceStore();
        viewer.configure((SourceViewerConfiguration)new JavaScriptSourceViewerConfiguration(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
        viewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
    }

    protected SourceViewer createSourceViewer(Composite parent) {
        IPreferenceStore store = JavaScriptPlugin.getDefault().getCombinedPreferenceStore();
        return new JavaSourceViewer(parent, null, null, false, 33620738, store);
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IClassFile file) {
        IJavaScriptElement element = file.getParent();
        while (element != null && element.getElementType() != 3) {
            element = element.getParent();
        }
        return (IPackageFragmentRoot)element;
    }

    public void setInput(RefactoringStatusContext context) {
        if (context instanceof JavaStatusContext) {
            JavaStatusContext jsc = (JavaStatusContext)context;
            IDocument document = null;
            if (jsc.isBinary()) {
                IClassFile file = jsc.getClassFile();
                InternalClassFileEditorInput editorInput = new InternalClassFileEditorInput(file);
                document = this.getDocument((IDocumentProvider)JavaScriptPlugin.getDefault().getClassFileDocumentProvider(), editorInput);
                if (document.getLength() == 0) {
                    document = new Document(Messages.format(RefactoringMessages.JavaStatusContextViewer_no_source_found0, this.getPackageFragmentRoot(file).getElementName()));
                }
                this.updateTitle((IAdaptable)file);
            } else {
                IJavaScriptUnit cunit = jsc.getCompilationUnit();
                if (cunit.isWorkingCopy()) {
                    try {
                        document = this.newJavaDocument(cunit.getSource());
                    }
                    catch (JavaScriptModelException editorInput) {}
                } else {
                    FileEditorInput editorInput = new FileEditorInput((IFile)cunit.getResource());
                    document = this.getDocument(JavaScriptPlugin.getDefault().getCompilationUnitDocumentProvider(), (IEditorInput)editorInput);
                }
                if (document == null) {
                    document = new Document(RefactoringMessages.JavaStatusContextViewer_no_source_available);
                }
                this.updateTitle((IAdaptable)cunit);
            }
            this.setInput(document, JavaStatusContextViewer.createRegion(jsc.getSourceRange()));
        } else if (context instanceof JavaStringStatusContext) {
            this.updateTitle(null);
            JavaStringStatusContext sc = (JavaStringStatusContext)context;
            this.setInput(this.newJavaDocument(sc.getSource()), JavaStatusContextViewer.createRegion(sc.getSourceRange()));
        }
    }

    private IDocument newJavaDocument(String source) {
        Document result = new Document(source);
        JavaScriptTextTools textTools = JavaScriptPlugin.getDefault().getJavaTextTools();
        textTools.setupJavaDocumentPartitioner((IDocument)result);
        return result;
    }

    private static IRegion createRegion(ISourceRange range) {
        return new Region(range.getOffset(), range.getLength());
    }

    private IDocument getDocument(IDocumentProvider provider, IEditorInput input) {
        if (input == null) {
            return null;
        }
        IDocument result = null;
        try {
            try {
                provider.connect((Object)input);
                result = provider.getDocument((Object)input);
            }
            catch (CoreException coreException) {
                provider.disconnect((Object)input);
            }
        }
        finally {
            provider.disconnect((Object)input);
        }
        return result;
    }
}

