/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.IStatusLineProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class FixCorrectionProposal
extends LinkedCorrectionProposal
implements ICompletionProposalExtension2,
IStatusLineProposal {
    private final IFix fFix;
    private final ICleanUp fCleanUp;
    private JavaScriptUnit fCompilationUnit;

    public FixCorrectionProposal(IFix fix, ICleanUp cleanUp, int relevance, Image image, IInvocationContext context) {
        super(fix.getDescription(), fix.getCompilationUnit(), (ASTRewrite)null, relevance, image);
        this.fFix = fix;
        this.fCleanUp = cleanUp;
        this.fCompilationUnit = context.getASTRoot();
    }

    public ICleanUp getCleanUp() {
        return this.fCleanUp;
    }

    public Image getImage() {
        IStatus status = this.fFix.getStatus();
        if (!status.isOK()) {
            ImageImageDescriptor image = new ImageImageDescriptor(super.getImage());
            int flag = 32;
            if (status.getSeverity() == 4) {
                flag = 64;
            }
            JavaScriptElementImageDescriptor composite = new JavaScriptElementImageDescriptor(image, flag, new Point(image.getImageData().width, image.getImageData().height));
            return composite.createImage();
        }
        return super.getImage();
    }

    public String getAdditionalProposalInfo() {
        AbstractFix af;
        String info;
        String result = super.getAdditionalProposalInfo();
        IStatus status = this.fFix.getStatus();
        if (!status.isOK()) {
            StringBuffer buf = new StringBuffer();
            buf.append("<b>");
            buf.append(CorrectionMessages.FixCorrectionProposal_WarningAdditionalProposalInfo);
            buf.append("</b>");
            buf.append(status.getMessage());
            buf.append("<br><br>");
            buf.append(result);
            return buf.toString();
        }
        if (this.fFix instanceof AbstractFix && (info = (af = (AbstractFix)this.fFix).getAdditionalInfo()) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(info);
            sb.append("<br>");
            sb.append(result);
            return sb.toString();
        }
        return result;
    }

    public int getRelevance() {
        IStatus status = this.fFix.getStatus();
        if (status.getSeverity() == 2) {
            return super.getRelevance() - 100;
        }
        return super.getRelevance();
    }

    protected TextChange createTextChange() throws CoreException {
        IFix fix = this.fFix;
        TextChange createChange = fix.createChange();
        if (createChange instanceof TextFileChange) {
            ((TextFileChange)createChange).setSaveMode(4);
        }
        if (fix instanceof LinkedFix) {
            this.setLinkedProposalModel(((LinkedFix)fix).getLinkedPositions());
        }
        if (createChange == null) {
            return new CompilationUnitChange("", this.getCompilationUnit());
        }
        return createChange;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        if (stateMask == 262144 && this.fCleanUp != null) {
            CleanUpRefactoring refactoring = new CleanUpRefactoring();
            refactoring.addCompilationUnit(this.getCompilationUnit());
            refactoring.addCleanUp(this.fCleanUp);
            refactoring.setLeaveFilesDirty(true);
            int stopSeverity = RefactoringCore.getConditionCheckingFailedSeverity();
            Shell shell = JavaScriptPlugin.getActiveWorkbenchShell();
            ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
            RefactoringExecutionHelper executer = new RefactoringExecutionHelper(refactoring, stopSeverity, 5, shell, (IRunnableContext)context);
            try {
                executer.perform(true, true);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                JavaScriptPlugin.log(e);
            }
            return;
        }
        this.apply(viewer.getDocument());
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    public String getStatusMessage() {
        if (this.fCleanUp == null) {
            return null;
        }
        int count = this.fCleanUp.maximalNumberOfFixes(this.fCompilationUnit);
        if (count == -1) {
            return CorrectionMessages.FixCorrectionProposal_HitCtrlEnter_description;
        }
        if (count < 2) {
            return "";
        }
        return Messages.format(CorrectionMessages.FixCorrectionProposal_hitCtrlEnter_variable_description, count);
    }
}

