/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.Logger;
import org.eclipse.wst.jsdt.internal.ui.text.java.MemberProposalInfo;

public final class MethodProposalInfo
extends MemberProposalInfo {
    private IFunction fFallbackMatch;

    public MethodProposalInfo(IJavaScriptProject project, CompletionProposal proposal) {
        super(project, proposal);
    }

    protected IMember resolveMember() throws JavaScriptModelException {
        char[] declarationSignature;
        char[] typeNameChars = this.fProposal.getDeclarationTypeName();
        String declaringTypeName = null;
        if (typeNameChars != null) {
            declaringTypeName = String.valueOf(typeNameChars);
        }
        if (declaringTypeName == null && (declarationSignature = this.fProposal.getDeclarationSignature()) != null) {
            declaringTypeName = SignatureUtil.stripSignatureToFQN(String.valueOf(declarationSignature));
        }
        IFunction func = null;
        if (declaringTypeName != null) {
            String functionName = String.valueOf(this.fProposal.getName());
            String[] paramTypeNameStrings = null;
            char[][] paramTypeNameChars = this.fProposal.getParameterTypeNames();
            if (paramTypeNameChars != null) {
                paramTypeNameStrings = new String[paramTypeNameChars.length];
                int i = 0;
                while (i < paramTypeNameChars.length) {
                    paramTypeNameStrings[i] = paramTypeNameChars[i] != null ? String.valueOf(paramTypeNameChars[i]) : null;
                    ++i;
                }
            } else {
                char[] signature = this.fProposal.getSignature();
                paramTypeNameStrings = signature != null && signature.length > 0 ? Signature.getParameterTypes((String)String.valueOf(this.fProposal.getSignature())) : new String[]{};
            }
            IType[] types = this.fJavaProject.findTypes(declaringTypeName);
            if (types != null && types.length > 0) {
                int i = 0;
                while (i < types.length && func == null) {
                    IType type = types[i];
                    if (type != null) {
                        boolean isConstructor = this.fProposal.isConstructor();
                        try {
                            func = this.findMethod(functionName, paramTypeNameStrings, isConstructor, type);
                        }
                        catch (JavaScriptModelException javaScriptModelException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            } else {
                MethodPattern methodPattern = new MethodPattern(true, false, functionName.toCharArray(), (char[][])new char[][]{declaringTypeName.toCharArray()}, 0);
                SearchEngine searchEngine = new SearchEngine((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.fJavaProject});
                final ArrayList matches = new ArrayList();
                try {
                    searchEngine.search((SearchPattern)methodPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            if (match.getElement() instanceof IFunction) {
                                matches.add(match.getElement());
                            }
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Logger.logException("Failed index search for function: " + functionName, (Throwable)e);
                }
                if (!matches.isEmpty()) {
                    func = (IFunction)matches.get(0);
                }
            }
        }
        return func;
    }

    private IFunction findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaScriptModelException {
        Map typeVariables = this.computeTypeVariables(type);
        return this.findMethod(name, paramTypes, isConstructor, type.getFunctions(), typeVariables);
    }

    private Map computeTypeVariables(IType type) throws JavaScriptModelException {
        HashMap map = new HashMap();
        char[] declarationSignature = this.fProposal.getDeclarationSignature();
        if (declarationSignature == null) {
            return map;
        }
        return map;
    }

    private IFunction findMethod(String name, String[] paramTypes, boolean isConstructor, IFunction[] methods, Map typeVariables) throws JavaScriptModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (this.isSameMethodSignature(name, paramTypes, isConstructor, methods[i], typeVariables)) {
                return methods[i];
            }
            --i;
        }
        return this.fFallbackMatch;
    }

    private boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IFunction method, Map typeVariables) throws JavaScriptModelException {
        String[] otherParams;
        if ((isConstructor || name.equals(method.getElementName())) && isConstructor == method.isConstructor() && paramTypes.length == (otherParams = method.getParameterTypes()).length) {
            this.fFallbackMatch = method;
            String signature = method.getSignature();
            String[] otherParamsFromSignature = Signature.getParameterTypes((String)signature);
            int i = 0;
            while (i < paramTypes.length) {
                String ourParamName = this.computeSimpleTypeName(paramTypes[i], typeVariables);
                String otherParamName1 = this.computeSimpleTypeName(otherParams[i], typeVariables);
                String otherParamName2 = this.computeSimpleTypeName(otherParamsFromSignature[i], typeVariables);
                if (!ourParamName.equals(otherParamName1) && !ourParamName.equals(otherParamName2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private String computeSimpleTypeName(String signature, Map typeVariables) {
        String simpleName = "";
        if (signature != null && signature.length() > 0) {
            String erasure = signature;
            simpleName = Signature.getSimpleName((String)Signature.toString((String)(erasure = erasure.replaceAll("/", "."))));
            char[] typeVar = (char[])typeVariables.get(simpleName);
            if (typeVar != null) {
                simpleName = String.valueOf(Signature.getSignatureSimpleName((char[])typeVar));
            }
        }
        return simpleName;
    }
}

