/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationBlock;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private LayoutGroup fLayoutGroup;
    private WebPageSupportGroup webPageSupportGroup;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.JavaProjectWizardFirstPage_page_pageName;
    private WorkingSetGroup fWorkingSetGroup;
    private IWorkingSet[] fInitWorkingSets;

    public JavaProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.JavaProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.JavaProjectWizardFirstPage_page_description);
        this.fInitialName = "";
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite);
        this.webPageSupportGroup = new WebPageSupportGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fWorkingSetGroup = new WorkingSetGroup(composite, this.fInitWorkingSets);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fDetectGroup.addObserver(this.webPageSupportGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.jsdt.ui.new_javaproject_wizard_page_context");
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        String location = this.fLocationGroup.getLocation().toOSString();
        IPath projectPath = Path.fromOSString((String)location);
        return Platform.getLocation().isPrefixOf(projectPath);
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrcBin() {
        return this.fLayoutGroup.isSrcBin();
    }

    public boolean isWebEnabled() {
        return this.webPageSupportGroup.shouldEnableWebSupport();
    }

    public boolean isWebDefault() {
        return this.webPageSupportGroup.shouldDefaultToWebBrowser();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.fInitWorkingSets = workingSets;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSetGroup.getSelectedWorkingSets();
    }

    private final class DetectGroup
    extends Observable
    implements Observer {
        private final Link fHintText;
        private Label fIcon;
        private boolean fDetect;

        public DetectGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            this.fIcon = new Label(composite, 16384);
            this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            this.fIcon.setLayoutData((Object)gridData);
            this.fIcon.setVisible(false);
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(composite.getFont());
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = JavaProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = JavaProjectWizardFirstPage.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                if (JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                    this.fDetect = false;
                } else {
                    File directory = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toFile();
                    this.fDetect = directory.isDirectory();
                }
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.JavaProjectWizardFirstPage_DetectGroup_message);
                        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.fIcon.setVisible(true);
                    } else {
                        this.fHintText.setVisible(false);
                        this.fIcon.setVisible(false);
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }
    }

    private final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio;
        private final SelectionButtonDialogField fSrcBinRadio;
        private final Group fGroup;
        private final Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_title);
            this.fStdRadio = new SelectionButtonDialogField(16);
            this.fStdRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_oneFolder);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_separateFolders);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
        }

        public void update(Observable o, Object arg) {
            boolean detect = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String id = "org.eclipse.wst.jsdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.wst.jsdt.ui.last.external.project";

        public LocationGroup(Composite composite) {
            int numColumns = 3;
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_title);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(JavaProjectWizardFirstPage.this.getShell());
            dialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaScriptPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
                JavaScriptPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(JavaProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IWorkspace workspace = JavaScriptPlugin.getWorkspace();
            String name = JavaProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterProjectName);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = JavaProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_projectAlreadyExists);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterLocation);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_invalidDirectory);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                if (!this.canCreate(projectPath.toFile())) {
                    JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_cannotCreateAtExternalLocation);
                    JavaProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
                if (!Platform.getLocation().equals((Object)projectPath) && Platform.getLocation().isPrefixOf(projectPath)) {
                    if (!Platform.getLocation().equals((Object)projectPath.removeLastSegments(1))) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_notOnWorkspaceRoot);
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                    if (!projectPath.toFile().exists()) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_notExisingProjectOnWorkspaceRoot);
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                    String existingName = projectPath.lastSegment();
                    if (!existingName.equals(JavaProjectWizardFirstPage.this.fNameGroup.getName())) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_Message_invalidProjectNameForWorkspaceRoot, existingName));
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                } else {
                    IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
                    if (!locationStatus.isOK()) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                }
            } else {
                IPath projectFolder = projectPath.append(JavaProjectWizardFirstPage.this.fNameGroup.getName());
                if (projectFolder.toFile().exists()) {
                    JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_existingFolderInWorkspace);
                    JavaProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
            }
            JavaProjectWizardFirstPage.this.setPageComplete(true);
            JavaProjectWizardFirstPage.this.setErrorMessage(null);
            JavaProjectWizardFirstPage.this.setMessage(null);
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }
    }

    private final class WebPageSupportGroup
    implements Observer {
        private final Group fGroup;
        private final SelectionButtonDialogField fEnableWebSupport;
        private final SelectionButtonDialogField fDefaultWindowSuperType;

        public WebPageSupportGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_0);
            this.fEnableWebSupport = new SelectionButtonDialogField(32);
            this.fEnableWebSupport.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_1);
            this.fEnableWebSupport.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fEnableWebSupport.setEnabled(true);
            this.fEnableWebSupport.getSelectionButton((Composite)this.fGroup).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (WebPageSupportGroup.this.fDefaultWindowSuperType != null) {
                        WebPageSupportGroup.this.fDefaultWindowSuperType.setEnabled(WebPageSupportGroup.this.fEnableWebSupport.isSelected());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fDefaultWindowSuperType = new SelectionButtonDialogField(32);
            this.fDefaultWindowSuperType.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_2);
            this.fDefaultWindowSuperType.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fDefaultWindowSuperType.setEnabled(true);
            this.fEnableWebSupport.setSelection(true);
            this.fDefaultWindowSuperType.setSelection(true);
        }

        public boolean shouldEnableWebSupport() {
            return this.fEnableWebSupport.isSelected();
        }

        public boolean shouldDefaultToWebBrowser() {
            return this.fDefaultWindowSuperType.isEnabled() && this.fDefaultWindowSuperType.isSelected();
        }

        public void update(Observable o, Object arg) {
            boolean detect = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fEnableWebSupport.setEnabled(!detect);
            this.fDefaultWindowSuperType.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup(Composite composite, IWorkingSet[] initialWorkingSets) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_WorkingSets_group);
            workingSetGroup.setLayoutData((Object)new GridData(4, 128, true, false));
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            String[] workingSetIds = new String[]{"org.eclipse.wst.jsdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, NewWizardMessages.JavaProjectWizardFirstPage_EnableWorkingSet_button, JavaScriptPlugin.getDefault().getDialogSettings());
            this.fWorkingSetBlock.setDialogMessage(NewWizardMessages.JavaProjectWizardFirstPage_WorkingSetSelection_message);
            this.fWorkingSetBlock.setSelection(initialWorkingSets);
            this.fWorkingSetBlock.createContent((Composite)workingSetGroup);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

