/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ShowInNavigatorViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInNavigatorViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ShowInNavigatorView_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.show_in_navigator_action");
    }

    public ShowInNavigatorViewAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getResource(selection) != null);
    }

    public void run(ITextSelection selection) {
        IJavaScriptElement input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IJavaScriptElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null || elements.length == 0) {
                return;
            }
            IJavaScriptElement candidate = elements[0];
            if (elements.length > 1) {
                candidate = SelectionConverter.selectJavaElement(elements, this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_dialog_message);
            }
            if (candidate != null) {
                this.run(this.getResource(candidate));
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run(IStructuredSelection selection) {
        this.run(this.getResource(selection));
    }

    public void run(IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
            IViewPart view = page.showView("org.eclipse.ui.views.ResourceNavigator");
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection((Object)resource);
                ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_error_activation_failed);
        }
    }

    private IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IJavaScriptElement) {
            return this.getResource((IJavaScriptElement)element);
        }
        return null;
    }

    private IResource getResource(IJavaScriptElement element) {
        if (element == null) {
            return null;
        }
        if ((element = (IJavaScriptElement)element.getOpenable()) instanceof IJavaScriptUnit) {
            element = ((IJavaScriptUnit)element).getPrimary();
        }
        return element.getResource();
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInNavigatorView_dialog_title;
    }
}

