/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTConverter;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTRecoveryPropagator;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnitResolver;
import org.eclipse.wst.jsdt.core.dom.NodeSearcher;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScannerData;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.wst.jsdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ASTParser {
    public static final int K_EXPRESSION = 1;
    public static final int K_STATEMENTS = 2;
    public static final int K_CLASS_BODY_DECLARATIONS = 4;
    public static final int K_COMPILATION_UNIT = 8;
    private final int apiLevel;
    private int astKind;
    private Map compilerOptions;
    private boolean resolveBindings;
    private boolean partial = false;
    private boolean statementsRecovery;
    private boolean bindingsRecovery;
    private int focalPointPosition;
    private char[] rawSource = null;
    private ITypeRoot typeRoot = null;
    private int sourceOffset = 0;
    private int sourceLength = -1;
    private WorkingCopyOwner workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
    private IJavaScriptProject project = null;
    private String unitName = null;

    public static ASTParser newParser(int level) {
        return new ASTParser(level);
    }

    ASTParser(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException();
        }
        this.apiLevel = level;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.astKind = 8;
        this.rawSource = null;
        this.typeRoot = null;
        this.resolveBindings = false;
        this.sourceLength = -1;
        this.sourceOffset = 0;
        this.workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        this.unitName = null;
        this.project = null;
        this.partial = false;
        Hashtable options = JavaScriptCore.getOptions();
        options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
        this.compilerOptions = options;
    }

    public void setBindingsRecovery(boolean enabled) {
        this.bindingsRecovery = enabled;
    }

    public void setCompilerOptions(Map options) {
        options = options == null ? JavaScriptCore.getOptions() : new HashMap(options);
        options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
        this.compilerOptions = options;
    }

    public void setResolveBindings(boolean bindings) {
        this.resolveBindings = bindings;
    }

    public void setFocalPosition(int position) {
        this.partial = true;
        this.focalPointPosition = position;
    }

    public void setKind(int kind) {
        if (kind != 8 && kind != 4 && kind != 1 && kind != 2) {
            throw new IllegalArgumentException();
        }
        this.astKind = kind;
    }

    public void setSource(char[] source) {
        this.rawSource = source;
        this.typeRoot = null;
    }

    public void setSource(IJavaScriptUnit source) {
        this.setSource((ITypeRoot)source);
    }

    public void setSource(IClassFile source) {
        this.setSource((ITypeRoot)source);
    }

    public void setSource(ITypeRoot source) {
        this.typeRoot = source;
        this.rawSource = null;
        if (source != null) {
            this.project = source.getJavaScriptProject();
            Map options = this.project.getOptions(true);
            options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public void setSourceRange(int offset, int length) {
        if (offset < 0 || length < -1) {
            throw new IllegalArgumentException();
        }
        this.sourceOffset = offset;
        this.sourceLength = length;
    }

    public void setStatementsRecovery(boolean enabled) {
        this.statementsRecovery = enabled;
    }

    public void setWorkingCopyOwner(WorkingCopyOwner owner) {
        this.workingCopyOwner = owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setProject(IJavaScriptProject project) {
        this.project = project;
        if (project != null) {
            Map options = project.getOptions(true);
            options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public ASTNode createAST(IProgressMonitor monitor) {
        ASTNode result = null;
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            if (this.rawSource == null && this.typeRoot == null) {
                throw new IllegalStateException("source not specified");
            }
            result = this.internalCreateAST(monitor);
        }
        finally {
            this.initializeDefaults();
            if (monitor != null) {
                monitor.done();
            }
        }
        return result;
    }

    public void createASTs(IJavaScriptUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, IProgressMonitor monitor) {
        try {
            int flags = 0;
            if (this.statementsRecovery) {
                flags |= 2;
            }
            if (this.resolveBindings) {
                if (this.project == null) {
                    throw new IllegalStateException("project not specified");
                }
                if (this.bindingsRecovery) {
                    flags |= 4;
                }
                JavaScriptUnitResolver.resolve(compilationUnits, bindingKeys, requestor, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, flags, monitor);
            } else {
                JavaScriptUnitResolver.parse(compilationUnits, requestor, this.apiLevel, this.compilerOptions, flags, monitor);
            }
        }
        finally {
            this.initializeDefaults();
        }
    }

    public IBinding[] createBindings(IJavaScriptElement[] elements, IProgressMonitor monitor) {
        try {
            if (this.project == null) {
                throw new IllegalStateException("project not specified");
            }
            int flags = 0;
            if (this.statementsRecovery) {
                flags |= 2;
            }
            if (this.bindingsRecovery) {
                flags |= 4;
            }
            IBinding[] iBindingArray = JavaScriptUnitResolver.resolve(elements, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, flags, monitor);
            return iBindingArray;
        }
        finally {
            this.initializeDefaults();
        }
    }

    private ASTNode internalCreateAST(IProgressMonitor monitor) {
        boolean needToResolveBindings = this.resolveBindings;
        switch (this.astKind) {
            case 1: 
            case 2: 
            case 4: {
                if (this.rawSource == null) break;
                if (this.sourceOffset + this.sourceLength > this.rawSource.length) {
                    throw new IllegalStateException();
                }
                return this.internalCreateASTForKind();
            }
            case 8: {
                CompilationUnitDeclaration compilationUnitDeclaration = null;
                try {
                    NodeSearcher searcher = null;
                    ICompilationUnit sourceUnit = null;
                    WorkingCopyOwner wcOwner = this.workingCopyOwner;
                    if (this.typeRoot instanceof IJavaScriptUnit) {
                        sourceUnit = (ICompilationUnit)((Object)this.typeRoot);
                        sourceUnit = new BasicCompilationUnit(sourceUnit.getContents(), sourceUnit.getPackageName(), new String(sourceUnit.getFileName()), this.project);
                        wcOwner = ((IJavaScriptUnit)this.typeRoot).getOwner();
                    } else if (this.typeRoot instanceof IClassFile) {
                        try {
                            String sourceString = this.typeRoot.getSource();
                            if (sourceString == null) {
                                throw new IllegalStateException();
                            }
                            PackageFragment packageFragment = (PackageFragment)this.typeRoot.getParent();
                            char[] fileName = this.typeRoot.getElementName().toCharArray();
                            sourceUnit = new BasicCompilationUnit(sourceString.toCharArray(), Util.toCharArrays(packageFragment.names), new String(fileName), this.project);
                        }
                        catch (JavaScriptModelException e) {
                            throw new IllegalStateException();
                        }
                    } else if (this.rawSource != null) {
                        needToResolveBindings = this.resolveBindings && this.unitName != null && this.project != null && this.compilerOptions != null;
                        sourceUnit = new BasicCompilationUnit(this.rawSource, null, this.unitName == null ? "" : this.unitName, this.project);
                    } else {
                        throw new IllegalStateException();
                    }
                    if (this.partial) {
                        searcher = new NodeSearcher(this.focalPointPosition);
                    }
                    int flags = 0;
                    if (this.statementsRecovery) {
                        flags |= 2;
                    }
                    if (needToResolveBindings) {
                        if (this.bindingsRecovery) {
                            flags |= 4;
                        }
                        try {
                            compilationUnitDeclaration = JavaScriptUnitResolver.resolve(sourceUnit, this.project, searcher, this.compilerOptions, this.workingCopyOwner, flags, monitor);
                        }
                        catch (JavaScriptModelException e) {
                            compilationUnitDeclaration = JavaScriptUnitResolver.parse(sourceUnit, searcher, this.compilerOptions, flags &= 0xFFFFFFFB);
                            needToResolveBindings = false;
                        }
                    } else {
                        compilationUnitDeclaration = JavaScriptUnitResolver.parse(sourceUnit, searcher, this.compilerOptions, flags);
                        needToResolveBindings = false;
                    }
                    JavaScriptUnit result = JavaScriptUnitResolver.convert(compilationUnitDeclaration, sourceUnit.getContents(), this.apiLevel, this.compilerOptions, needToResolveBindings, wcOwner, needToResolveBindings ? new DefaultBindingResolver.BindingTables() : null, flags, monitor);
                    result.setTypeRoot(this.typeRoot);
                    JavaScriptUnit javaScriptUnit = result;
                    return javaScriptUnit;
                }
                finally {
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                        if (compilationUnitDeclaration.scope != null) {
                            compilationUnitDeclaration.scope.cleanup();
                        }
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    private ASTNode internalCreateASTForKind() {
        ASTConverter converter = new ASTConverter(this.compilerOptions, false, null);
        converter.compilationUnitSource = this.rawSource;
        converter.compilationUnitSourceLength = this.rawSource.length;
        converter.scanner.setSource(this.rawSource);
        AST ast = AST.newAST(this.apiLevel);
        ast.setDefaultNodeFlag(2);
        ast.setBindingResolver(new BindingResolver());
        if (this.statementsRecovery) {
            ast.setFlag(2);
        }
        converter.setAST(ast);
        CodeSnippetParsingUtil codeSnippetParsingUtil = new CodeSnippetParsingUtil();
        JavaScriptUnit compilationUnit = ast.newJavaScriptUnit();
        if (this.sourceLength == -1) {
            this.sourceLength = this.rawSource.length;
        }
        switch (this.astKind) {
            case 2: {
                ConstructorDeclaration constructorDeclaration = codeSnippetParsingUtil.parseStatements(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true, this.statementsRecovery);
                RecoveryScannerData data = constructorDeclaration.compilationResult.recoveryScannerData;
                if (data != null) {
                    Scanner scanner = converter.scanner;
                    converter.docParser.scanner = converter.scanner = new RecoveryScanner(scanner, data.removeUnused());
                    converter.scanner.setSource(scanner.source);
                }
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                Block block = ast.newBlock();
                block.setSourceRange(this.sourceOffset, this.sourceOffset + this.sourceLength);
                ProgramElement[] statements = constructorDeclaration.statements;
                if (statements != null) {
                    int statementsLength = statements.length;
                    int i = 0;
                    while (i < statementsLength) {
                        if (statements[i] instanceof LocalDeclaration) {
                            converter.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                        } else {
                            Statement statement = converter.convert(statements[i]);
                            if (statement != null) {
                                block.statements().add(statement);
                            }
                        }
                        ++i;
                    }
                }
                this.rootNodeToCompilationUnit(ast, compilationUnit, block, recordedParsingInformation, data);
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return block;
            }
            case 1: {
                org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression = codeSnippetParsingUtil.parseExpression(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (expression != null) {
                    Expression expression2 = converter.convert(expression);
                    this.rootNodeToCompilationUnit(expression2.getAST(), compilationUnit, expression2, codeSnippetParsingUtil.recordedParsingInformation, null);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return expression2;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
            case 4: {
                org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode[] nodes = codeSnippetParsingUtil.parseClassBodyDeclarations(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (nodes != null) {
                    JavaScriptUnit compUnit = converter.convert(nodes, compilationUnit);
                    this.rootNodeToCompilationUnit(compUnit.getAST(), compilationUnit, compUnit, codeSnippetParsingUtil.recordedParsingInformation, null);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return compilationUnit;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
        }
        throw new IllegalStateException();
    }

    private void propagateErrors(ASTNode astNode, CategorizedProblem[] problems, RecoveryScannerData data) {
        astNode.accept(new ASTSyntaxErrorPropagator(problems));
        if (data != null) {
            astNode.accept(new ASTRecoveryPropagator(problems, data));
        }
    }

    private void rootNodeToCompilationUnit(AST ast, JavaScriptUnit compilationUnit, ASTNode node, RecordedParsingInformation recordedParsingInformation, RecoveryScannerData data) {
        int problemsCount = recordedParsingInformation.problemsCount;
        switch (node.getNodeType()) {
            case 8: {
                Block block = (Block)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(block, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            case 15: {
                JavaScriptUnit compUnit = (JavaScriptUnit)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    int i = 0;
                    int max = compUnit.statements().size();
                    while (i < max) {
                        this.propagateErrors((ASTNode)compUnit.statements().get(i), (CategorizedProblem[])problems, data);
                        ++i;
                    }
                    compilationUnit.setProblems(problems);
                }
                if (compilationUnit == node) break;
                int i = 0;
                int max = compUnit.statements().size();
                while (i < max) {
                    compilationUnit.statements().add(compUnit.statements().get(i));
                    ++i;
                }
                break;
            }
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(typeDeclaration, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            default: {
                if (!(node instanceof Expression)) break;
                Expression expression = (Expression)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(expression, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                ExpressionStatement expressionStatement = ast.newExpressionStatement(expression);
                Block block = ast.newBlock();
                block.statements().add(expressionStatement);
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
            }
        }
    }
}

