/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IAllocationExpression;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;

public class AllocationExpression
extends Expression
implements InvocationSite,
IAllocationExpression {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    public Expression member;
    public boolean isShort;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.member != null) {
            flowInfo = this.member.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        if (this.arguments != null) {
            int i = 0;
            int count = this.arguments.length;
            while (i < count) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return null;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding allocatedTypeErasure = this.binding.declaringClass;
        if (allocatedTypeErasure.isNestedType() && currentScope.enclosingSourceType().isLocalType() && allocatedTypeErasure.isLocalType()) {
            ((LocalTypeBinding)allocatedTypeErasure).addInnerEmulationDependent(currentScope, false);
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("new ");
        this.member.print(indent, output);
        if (this.type != null) {
            this.type.printExpression(0, output);
        }
        if (!this.isShort) {
            output.append('(');
            if (this.arguments != null) {
                int i = 0;
                while (i < this.arguments.length) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    this.arguments[i].printExpression(0, output);
                    ++i;
                }
            }
            output.append(')');
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.member != null) {
            this.resolvedType = this.member.resolveForAllocation(scope, this);
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidType(this, this.resolvedType);
            }
        } else {
            this.resolvedType = this.type == null ? scope.enclosingReceiverType() : this.type.resolveType(scope, true);
        }
        boolean argsContainCast = false;
        TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                argumentTypes[i] = argument.resolveType(scope);
                if (argumentTypes[i] == null) {
                    argHasError = true;
                    argumentTypes[i] = TypeBinding.UNKNOWN;
                }
                ++i;
            }
        }
        if (this.resolvedType == null || this.resolvedType.isAnyType() || this.resolvedType instanceof ProblemReferenceBinding) {
            this.binding = new ProblemMethodBinding(TypeConstants.INIT, Binding.NO_PARAMETERS, 1);
            this.resolvedType = TypeBinding.UNKNOWN;
            return this.resolvedType;
        }
        if (!this.resolvedType.isValidBinding()) {
            return null;
        }
        if (this.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding allocationType = (ReferenceBinding)this.resolvedType;
            this.binding = scope.getConstructor(allocationType, argumentTypes, this);
            if (!this.binding.isValidBinding()) {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocationType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
                return this.resolvedType;
            }
            if (argumentTypes.length != this.binding.parameters.length) {
                scope.problemReporter().wrongNumberOfArguments(this, this.binding);
            }
            if (this.isMethodUseDeprecated(this.binding, scope, true)) {
                scope.problemReporter().deprecatedMethod(this.binding, this);
            }
            AllocationExpression.checkInvocationArguments(scope, null, allocationType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
        }
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int i) {
    }

    public void setFieldIndex(int i) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.member != null) {
                this.member.traverse(visitor, scope);
            } else if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int i = 0;
                int argumentsLength = this.arguments.length;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 3;
    }

    public IExpression getMember() {
        return this.member;
    }

    public TypeBinding resolveForAllocation(BlockScope scope, ASTNode location) {
        return this.resolveType(scope);
    }
}

