/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IForeachStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ForeachStatement
extends Statement
implements IForeachStatement {
    public LocalDeclaration elementVariable;
    public int elementVariableImplicitWidening = -1;
    public Expression collection;
    public Statement action;
    private int kind;
    private static final int ARRAY = 0;
    private static final int RAW_ITERABLE = 1;
    private static final int GENERIC_ITERABLE = 2;
    private TypeBinding iteratorReceiverType;
    private TypeBinding collectionElementType;
    public BlockScope scope;
    public LocalVariableBinding indexVariable;
    public LocalVariableBinding collectionVariable;
    public LocalVariableBinding maxVariable;
    private static final char[] SecretIndexVariableName = " index".toCharArray();
    private static final char[] SecretCollectionVariableName = " collection".toCharArray();
    private static final char[] SecretMaxVariableName = " max".toCharArray();
    int postCollectionInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForeachStatement(LocalDeclaration elementVariable, int start) {
        this.elementVariable = elementVariable;
        this.sourceStart = start;
        this.kind = -1;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo exitBranch;
        boolean isContinue = true;
        this.collection.checkNPE(currentScope, flowContext, flowInfo);
        flowInfo = this.elementVariable.analyseCode(this.scope, flowContext, flowInfo);
        FlowInfo condInfo = this.collection.analyseCode(this.scope, flowContext, flowInfo.copy());
        condInfo.markAsDefinitelyAssigned(this.elementVariable.binding);
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.scope);
        UnconditionalFlowInfo actionInfo = condInfo.nullInfoLessUnconditionalCopy();
        actionInfo.markAsDefinitelyUnknown(this.elementVariable.binding);
        if (!(this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L)) {
            if (!this.action.complainIfUnreachable(actionInfo, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo).unconditionalCopy();
            }
            exitBranch = flowInfo.unconditionalCopy().addInitializationsFrom(condInfo.initsWhenFalse());
            if ((actionInfo.tagBits & loopingContext.initsOnContinue.tagBits & 1) != 0) {
                isContinue = false;
            } else {
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue);
                exitBranch.addPotentialInitializationsFrom(actionInfo);
            }
        } else {
            exitBranch = condInfo.initsWhenFalse();
        }
        boolean hasEmptyAction = this.action == null || this.action.isEmptyBlock() || (this.action.bits & 1) != 0;
        switch (this.kind) {
            case 0: {
                if (hasEmptyAction && this.elementVariable.binding.resolvedPosition == -1) break;
                this.collectionVariable.useFlag = 1;
                if (!isContinue) break;
                this.indexVariable.useFlag = 1;
                this.maxVariable.useFlag = 1;
                break;
            }
            case 1: 
            case 2: {
                this.indexVariable.useFlag = 1;
            }
        }
        loopingContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches((loopingContext.initsOnBreak.tagBits & 1) != 0 ? loopingContext.initsOnBreak : flowInfo.addInitializationsFrom(loopingContext.initsOnBreak), false, exitBranch, false, true);
        return mergedInfo;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ForeachStatement.printIndent(indent, output).append("for (");
        this.elementVariable.printAsExpression(0, output);
        output.append(" : ");
        this.collection.print(0, output).append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(indent + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        TypeBinding collectionType;
        this.scope = new BlockScope(upperScope);
        this.elementVariable.resolve(this.scope);
        TypeBinding elementType = this.elementVariable.type.resolvedType;
        TypeBinding typeBinding = collectionType = this.collection == null ? null : this.collection.resolveType(this.scope);
        if (elementType != null && collectionType != null) {
            ReferenceBinding iterableType;
            if (collectionType.isArrayType()) {
                this.kind = 0;
                this.collectionElementType = ((ArrayBinding)collectionType).elementsType();
                int compileTimeTypeID = this.collectionElementType.id;
                if (elementType.isBaseType()) {
                    if (!this.collectionElementType.isBaseType()) {
                        compileTimeTypeID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                        this.elementVariableImplicitWidening = 1024;
                        if (elementType.isBaseType()) {
                            this.elementVariableImplicitWidening |= (elementType.id << 4) + compileTimeTypeID;
                        }
                    } else {
                        this.elementVariableImplicitWidening = (elementType.id << 4) + compileTimeTypeID;
                    }
                } else if (this.collectionElementType.isBaseType()) {
                    int boxedID = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                    this.elementVariableImplicitWidening = 0x200 | compileTimeTypeID << 4 | compileTimeTypeID;
                    compileTimeTypeID = boxedID;
                }
            } else if (collectionType instanceof ReferenceBinding && (iterableType = ((ReferenceBinding)collectionType).findSuperTypeErasingTo(38, false)) != null) {
                this.iteratorReceiverType = collectionType;
                if (((ReferenceBinding)this.iteratorReceiverType).findSuperTypeErasingTo(38, false) == null) {
                    this.iteratorReceiverType = iterableType;
                }
            }
            switch (this.kind) {
                case 0: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)TypeBinding.INT, 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.maxVariable = new LocalVariableBinding(SecretMaxVariableName, (TypeBinding)TypeBinding.INT, 0, false);
                    this.scope.addLocalVariable(this.maxVariable);
                    this.collectionVariable = new LocalVariableBinding(SecretCollectionVariableName, collectionType, 0, false);
                    this.scope.addLocalVariable(this.collectionVariable);
                    break;
                }
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.elementVariable.traverse(visitor, this.scope);
            this.collection.traverse(visitor, this.scope);
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 39;
    }
}

