/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorCopyAction;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.internal.ide.dialogs.WelcomeItem;
import org.eclipse.ui.internal.ide.dialogs.WelcomeParser;
import org.eclipse.ui.part.EditorPart;
import org.xml.sax.SAXException;

public class WelcomeEditor
extends EditorPart {
    private static final int HORZ_SCROLL_INCREMENT = 20;
    private static final int VERT_SCROLL_INCREMENT = 20;
    private static final int WRAP_MIN_WIDTH = 150;
    private Composite editorComposite;
    private Cursor handCursor;
    private Cursor busyCursor;
    private WelcomeParser parser;
    private ArrayList hyperlinkRanges = new ArrayList();
    private ArrayList texts = new ArrayList();
    private ScrolledComposite scrolledComposite;
    private IPropertyChangeListener colorListener;
    private boolean mouseDown = false;
    private boolean dragEvent = false;
    private StyledText firstText;
    private StyledText lastText;
    private StyledText lastNavigatedText;
    private StyledText currentText;
    private boolean nextTabAbortTraversal;
    private boolean previousTabAbortTraversal = false;
    private WelcomeEditorCopyAction copyAction;

    public WelcomeEditor() {
        this.setPartName(IDEWorkbenchMessages.WelcomeEditor_title);
        this.copyAction = new WelcomeEditorCopyAction(this);
        this.copyAction.setEnabled(false);
    }

    private void focusOn(StyledText newText, int caretOffset) {
        if (newText == null) {
            return;
        }
        newText.setFocus();
        newText.setCaretOffset(caretOffset);
        this.scrolledComposite.setOrigin(0, newText.getLocation().y);
    }

    private StyledText nextText(StyledText text) {
        int index = 0;
        if (text == null) {
            return (StyledText)this.texts.get(0);
        }
        index = this.texts.indexOf(text);
        if (index < this.texts.size() - 1) {
            return (StyledText)this.texts.get(index + 1);
        }
        return (StyledText)this.texts.get(0);
    }

    private StyledText previousText(StyledText text) {
        int index = 0;
        if (text == null) {
            return (StyledText)this.texts.get(0);
        }
        index = this.texts.indexOf(text);
        if (index == 0) {
            return (StyledText)this.texts.get(this.texts.size() - 1);
        }
        return (StyledText)this.texts.get(index - 1);
    }

    protected StyledText getCurrentText() {
        return this.currentText;
    }

    protected WelcomeEditorCopyAction getCopyAction() {
        return this.copyAction;
    }

    private StyleRange findNextLink(StyledText text) {
        if (text == null) {
            return null;
        }
        WelcomeItem item = (WelcomeItem)text.getData();
        int currentSelectionEnd = text.getSelection().y;
        StyleRange[] styleRangeArray = text.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange range = styleRangeArray[n2];
            if (range.start >= currentSelectionEnd && item.isLinkAt(range.start)) {
                return range;
            }
            ++n2;
        }
        return null;
    }

    private StyleRange findPreviousLink(StyledText text) {
        if (text == null) {
            return null;
        }
        WelcomeItem item = (WelcomeItem)text.getData();
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionStart = text.getSelection().x;
        int i = ranges.length - 1;
        while (i > -1) {
            if (ranges[i].start + ranges[i].length < currentSelectionStart && item.isLinkAt(ranges[i].start + ranges[i].length - 1)) {
                return ranges[i];
            }
            --i;
        }
        return null;
    }

    protected StyleRange getCurrentLink(StyledText text) {
        int currentSelectionEnd = text.getSelection().y;
        int currentSelectionStart = text.getSelection().x;
        StyleRange[] styleRangeArray = text.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange range = styleRangeArray[n2];
            if (currentSelectionStart >= range.start && currentSelectionEnd <= range.start + range.length) {
                return range;
            }
            ++n2;
        }
        return null;
    }

    private void addListeners(StyledText styledText) {
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                WelcomeEditor.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                WelcomeEditor.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                WelcomeItem item = (WelcomeItem)e.widget.getData();
                int offset = text.getCaretOffset();
                if (WelcomeEditor.this.dragEvent) {
                    WelcomeEditor.this.dragEvent = false;
                    if (item.isLinkAt(offset)) {
                        text.setCursor(WelcomeEditor.this.handCursor);
                    }
                } else if (item.isLinkAt(offset)) {
                    text.setCursor(WelcomeEditor.this.busyCursor);
                    if (e.button == 1) {
                        item.triggerLinkAt(offset);
                        StyleRange selectionRange = WelcomeEditor.this.getCurrentLink(text);
                        text.setSelectionRange(selectionRange.start, selectionRange.length);
                        text.setCursor(null);
                    }
                }
            }
        });
        styledText.addMouseMoveListener(e -> {
            if (this.mouseDown) {
                if (!this.dragEvent) {
                    StyledText text1 = (StyledText)e.widget;
                    text1.setCursor(null);
                }
                this.dragEvent = true;
                return;
            }
            StyledText text2 = (StyledText)e.widget;
            WelcomeItem item = (WelcomeItem)e.widget.getData();
            int offset = -1;
            try {
                offset = text2.getOffsetAtLocation(new Point(e.x, e.y));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (offset == -1) {
                text2.setCursor(null);
            } else if (item.isLinkAt(offset)) {
                text2.setCursor(this.handCursor);
            } else {
                text2.setCursor(null);
            }
        });
        styledText.addTraverseListener(e -> {
            StyledText text = (StyledText)e.widget;
            switch (e.detail) {
                case 2: {
                    e.doit = true;
                    break;
                }
                case 16: {
                    if ((e.stateMask & 0x40000) != 0) {
                        if (e.widget == this.lastText) {
                            return;
                        }
                        e.doit = false;
                        this.nextTabAbortTraversal = true;
                        this.lastText.traverse(16);
                        return;
                    }
                    if (this.nextTabAbortTraversal) {
                        this.nextTabAbortTraversal = false;
                        return;
                    }
                    StyleRange nextLink = this.findNextLink(text);
                    if (nextLink == null) {
                        StyledText nextText = this.nextText(text);
                        nextText.setSelection(0);
                        this.focusOn(nextText, 0);
                    } else {
                        this.focusOn(text, text.getSelection().x);
                        text.setSelectionRange(nextLink.start, nextLink.length);
                    }
                    e.detail = 0;
                    e.doit = true;
                    break;
                }
                case 8: {
                    if ((e.stateMask & 0x40000) != 0) {
                        if (e.widget == this.firstText) {
                            return;
                        }
                        e.doit = false;
                        this.previousTabAbortTraversal = true;
                        this.firstText.traverse(8);
                        return;
                    }
                    if (this.previousTabAbortTraversal) {
                        this.previousTabAbortTraversal = false;
                        return;
                    }
                    StyleRange previousLink = this.findPreviousLink(text);
                    if (previousLink == null) {
                        if (text.getSelection().x == 0) {
                            StyledText previousText = this.previousText(text);
                            previousText.setSelection(previousText.getCharCount());
                            previousLink = this.findPreviousLink(previousText);
                            if (previousLink == null) {
                                this.focusOn(previousText, 0);
                            } else {
                                this.focusOn(previousText, previousText.getSelection().x);
                                previousText.setSelectionRange(previousLink.start, previousLink.length);
                            }
                        } else {
                            this.focusOn(text, 0);
                        }
                    } else {
                        this.focusOn(text, text.getSelection().x);
                        text.setSelectionRange(previousLink.start, previousLink.length);
                    }
                    e.detail = 0;
                    e.doit = true;
                    break;
                }
            }
        });
        styledText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent event) {
                StyledText text = (StyledText)event.widget;
                if (event.character == ' ' || event.character == '\r') {
                    int offset;
                    WelcomeItem item;
                    if (text != null && (item = (WelcomeItem)text.getData()).isLinkAt(offset = text.getSelection().x + 1)) {
                        text.setCursor(WelcomeEditor.this.busyCursor);
                        item.triggerLinkAt(offset);
                        StyleRange selectionRange = WelcomeEditor.this.getCurrentLink(text);
                        text.setSelectionRange(selectionRange.start, selectionRange.length);
                        text.setCursor(null);
                    }
                    return;
                }
                if (event.keyCode == 0x1000006) {
                    WelcomeEditor.this.focusOn(WelcomeEditor.this.nextText(text), 0);
                    return;
                }
                if (event.keyCode == 0x1000005) {
                    WelcomeEditor.this.focusOn(WelcomeEditor.this.previousText(text), 0);
                    return;
                }
            }
        });
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WelcomeEditor.this.lastNavigatedText = (StyledText)e.widget;
            }

            public void focusGained(FocusEvent e) {
                WelcomeEditor.this.currentText = (StyledText)e.widget;
                if (WelcomeEditor.this.currentText != WelcomeEditor.this.lastNavigatedText && WelcomeEditor.this.lastNavigatedText != null) {
                    WelcomeEditor.this.lastNavigatedText.setSelection(((WelcomeEditor)WelcomeEditor.this).lastNavigatedText.getSelection().x);
                }
                WelcomeEditor.this.copyAction.setEnabled(WelcomeEditor.this.currentText.isTextSelected());
            }
        });
        styledText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledText text = (StyledText)e.widget;
                WelcomeEditor.this.copyAction.setEnabled(text.isTextSelected());
            }
        });
    }

    private Composite createInfoArea(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(1808));
        Composite infoArea = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.numColumns = 2;
        infoArea.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        infoArea.setLayoutData((Object)data);
        boolean wrapped = this.parser.isFormatWrapped();
        int HINDENT = 20;
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        Color foreground = JFaceColors.getBannerForeground((Display)display);
        infoArea.setBackground(background);
        int textStyle = 10;
        if (wrapped) {
            textStyle |= 0x40;
        }
        StyledText sampleStyledText = null;
        WelcomeItem item = this.getIntroItem();
        if (item != null) {
            StyledText styledText = new StyledText(infoArea, textStyle);
            this.texts.add(styledText);
            sampleStyledText = styledText;
            styledText.setCursor(null);
            JFaceColors.setColors((Control)styledText, (Color)foreground, (Color)background);
            styledText.setText(this.getIntroItem().getText());
            this.setBoldRanges(styledText, item.getBoldRanges());
            this.setLinkRanges(styledText, item.getActionRanges());
            this.setLinkRanges(styledText, item.getHelpRanges());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.horizontalIndent = HINDENT;
            gd.verticalAlignment = 2;
            styledText.setLayoutData((Object)gd);
            styledText.setData((Object)item);
            this.addListeners(styledText);
            Label spacer = new Label(infoArea, 0);
            spacer.setBackground(background);
            gd = new GridData(2);
            gd.horizontalSpan = 2;
            spacer.setLayoutData((Object)gd);
        }
        this.firstText = sampleStyledText;
        Label imageLabel = null;
        WelcomeItem[] welcomeItemArray = this.getItems();
        int n = welcomeItemArray.length;
        int spacer = 0;
        while (spacer < n) {
            WelcomeItem welcomeItem = welcomeItemArray[spacer];
            Label label = new Label(infoArea, 0);
            label.setBackground(background);
            label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WELCOME_ITEM"));
            GridData gd = new GridData();
            gd.horizontalIndent = HINDENT;
            gd.verticalAlignment = 2;
            label.setLayoutData((Object)gd);
            if (imageLabel == null) {
                imageLabel = label;
            }
            StyledText styledText = new StyledText(infoArea, textStyle);
            this.texts.add(styledText);
            sampleStyledText = styledText;
            styledText.setCursor(null);
            JFaceColors.setColors((Control)styledText, (Color)foreground, (Color)background);
            styledText.setText(welcomeItem.getText());
            this.setBoldRanges(styledText, welcomeItem.getBoldRanges());
            this.setLinkRanges(styledText, welcomeItem.getActionRanges());
            this.setLinkRanges(styledText, welcomeItem.getHelpRanges());
            gd = new GridData(768);
            gd.verticalAlignment = 2;
            gd.verticalSpan = 2;
            styledText.setLayoutData((Object)gd);
            styledText.setData((Object)welcomeItem);
            this.addListeners(styledText);
            Label spacer2 = new Label(infoArea, 0);
            spacer2.setBackground(background);
            gd = new GridData(2);
            gd.horizontalSpan = 2;
            spacer2.setLayoutData((Object)gd);
            MenuManager menuMgr = new MenuManager("#PopUp");
            menuMgr.add((IAction)this.copyAction);
            styledText.setMenu(menuMgr.createContextMenu((Control)styledText));
            ++spacer;
        }
        this.lastText = sampleStyledText;
        this.scrolledComposite.setContent((Control)infoArea);
        Point p = infoArea.computeSize(-1, -1, true);
        this.scrolledComposite.setMinHeight(p.y);
        if (wrapped) {
            this.scrolledComposite.setMinWidth(150);
        } else {
            this.scrolledComposite.setMinWidth(p.x);
        }
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        if (wrapped && imageLabel != null) {
            Rectangle bounds = imageLabel.getBounds();
            int adjust = HINDENT + bounds.width + layout.verticalSpacing + layout.marginWidth * 2;
            int adjustFirst = HINDENT + layout.marginWidth * 2;
            infoArea.addListener(11, event -> {
                int w = this.scrolledComposite.getClientArea().width;
                if (w < 150) {
                    w = 150;
                }
                int i = 0;
                while (i < this.texts.size()) {
                    int extent = i == 0 ? w - adjustFirst : w - adjust;
                    StyledText text = (StyledText)this.texts.get(i);
                    Point p1 = text.computeSize(extent, -1, false);
                    ((GridData)text.getLayoutData()).widthHint = p1.x;
                    ++i;
                }
                Point p2 = infoArea.computeSize(-1, -1, true);
                this.scrolledComposite.setMinHeight(p2.y);
            });
        }
        if (sampleStyledText == null) {
            this.scrolledComposite.getHorizontalBar().setIncrement(20);
            this.scrolledComposite.getVerticalBar().setIncrement(20);
        } else {
            GC gc = new GC((Drawable)sampleStyledText);
            int width = gc.getFontMetrics().getAverageCharWidth();
            gc.dispose();
            this.scrolledComposite.getHorizontalBar().setIncrement(width);
            this.scrolledComposite.getVerticalBar().setIncrement(sampleStyledText.getLineHeight());
        }
        return infoArea;
    }

    public void createPartControl(Composite parent) {
        this.readFile();
        if (this.parser == null) {
            return;
        }
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.busyCursor = new Cursor((Device)parent.getDisplay(), 1);
        this.editorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.editorComposite.setLayout((Layout)layout);
        this.createTitleArea(this.editorComposite);
        Label titleBarSeparator = new Label(this.editorComposite, 258);
        GridData gd = new GridData(768);
        titleBarSeparator.setLayoutData((Object)gd);
        this.createInfoArea(this.editorComposite);
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)this.editorComposite, "org.eclipse.ui.ide.welcome_editor_context");
        this.colorListener = event -> {
            if (event.getProperty().equals("HYPERLINK_COLOR")) {
                Color fg = JFaceColors.getHyperlinkText((Display)this.editorComposite.getDisplay());
                for (StyleRange range : this.hyperlinkRanges) {
                    range.foreground = fg;
                }
            }
        };
        JFacePreferences.getPreferenceStore().addPropertyChangeListener(this.colorListener);
    }

    private Composite createTitleArea(Composite parent) {
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        Color foreground = JFaceColors.getBannerForeground((Display)display);
        Composite titleArea = new Composite(parent, 524288);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        titleArea.setLayout((Layout)layout);
        titleArea.setLayoutData((Object)new GridData(768));
        titleArea.setBackground(background);
        CLabel messageLabel = new CLabel(titleArea, 16384){

            protected String shortenText(GC gc, String text, int width) {
                if (gc.textExtent((String)text, (int)8).x <= width) {
                    return text;
                }
                String ellipsis = "...";
                int ellipseWidth = gc.textExtent((String)"...", (int)8).x;
                int length = text.length();
                int end = length - 1;
                while (end > 0) {
                    text = text.substring(0, end);
                    int l1 = gc.textExtent((String)text, (int)8).x;
                    if (l1 + ellipseWidth <= width) {
                        return String.valueOf(text) + "...";
                    }
                    --end;
                }
                return String.valueOf(text) + "...";
            }
        };
        JFaceColors.setColors((Control)messageLabel, (Color)foreground, (Color)background);
        messageLabel.setText(this.getBannerTitle());
        messageLabel.setFont(JFaceResources.getHeaderFont());
        IPropertyChangeListener fontListener = event -> {
            if ("org.eclipse.jface.headerfont".equals(event.getProperty())) {
                messageLabel.setFont(JFaceResources.getHeaderFont());
            }
        };
        messageLabel.addDisposeListener(event -> JFaceResources.getFontRegistry().removeListener(fontListener));
        JFaceResources.getFontRegistry().addListener(fontListener);
        GridData gd = new GridData(1808);
        messageLabel.setLayoutData((Object)gd);
        Label titleImage = new Label(titleArea, 16384);
        titleImage.setBackground(background);
        titleImage.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WELCOME_BANNER"));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        titleImage.setLayoutData((Object)gd);
        return titleArea;
    }

    public void dispose() {
        super.dispose();
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        if (this.colorListener != null) {
            JFacePreferences.getPreferenceStore().removePropertyChangeListener(this.colorListener);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    private String getBannerTitle() {
        if (this.parser.getTitle() == null) {
            return "";
        }
        return this.parser.getTitle();
    }

    private WelcomeItem getIntroItem() {
        return this.parser.getIntroItem();
    }

    private WelcomeItem[] getItems() {
        return this.parser.getItems();
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof WelcomeEditorInput)) {
            throw new PartInitException("Invalid Input: Must be WelcomeEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void read(InputStream is) throws IOException {
        try {
            this.parser = new WelcomeParser();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        this.parser.parse(is);
    }

    public void readFile() {
        URL url = ((WelcomeEditorInput)this.getEditorInput()).getAboutInfo().getWelcomePageURL();
        if (url == null) {
            return;
        }
        InputStream is = null;
        try {
            try {
                is = url.openStream();
                this.read(is);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.WelcomeEditor_accessException, (Throwable)e);
                IDEWorkbenchPlugin.log(IDEWorkbenchMessages.WelcomeEditor_readFileError, (IStatus)status);
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void setBoldRanges(StyledText styledText, int[][] boldRanges) {
        int[][] nArray = boldRanges;
        int n = boldRanges.length;
        int n2 = 0;
        while (n2 < n) {
            int[] boldRange = nArray[n2];
            StyleRange r = new StyleRange(boldRange[0], boldRange[1], null, null, 1);
            styledText.setStyleRange(r);
            ++n2;
        }
    }

    public void setFocus() {
        if (this.editorComposite != null && this.lastNavigatedText == null && this.currentText == null) {
            this.editorComposite.setFocus();
        }
    }

    private void setLinkRanges(StyledText styledText, int[][] linkRanges) {
        Color fg = JFaceColors.getHyperlinkText((Display)styledText.getShell().getDisplay());
        int[][] nArray = linkRanges;
        int n = linkRanges.length;
        int n2 = 0;
        while (n2 < n) {
            int[] linkRange = nArray[n2];
            StyleRange r = new StyleRange(linkRange[0], linkRange[1], fg, null);
            styledText.setStyleRange(r);
            this.hyperlinkRanges.add(r);
            ++n2;
        }
    }
}

