/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.Messages;

public class BreakpointHitCountAction
implements IObjectActionDelegate,
IActionDelegate2 {
    private static final String INITIAL_VALUE = "1";
    static IInputValidator validator = new IInputValidator(){
        int hitCount = -1;

        public String isValid(String value) {
            try {
                this.hitCount = Integer.valueOf(value.trim());
            }
            catch (NumberFormatException nfe) {
                this.hitCount = -1;
            }
            if (this.hitCount < 1) {
                return Messages.hit_count_must_be_positive;
            }
            return null;
        }
    };

    /*
     * Unable to fully structure code
     */
    public void run(IAction action) {
        selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        itr = selection.iterator();
        if (itr.hasNext()) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            breakpoint = (IJavaScriptBreakpoint)itr.next();
            try {
                oldHitCount = breakpoint.getHitCount();
                newHitCount = this.hitCountDialog(breakpoint);
                if (newHitCount == -1) continue;
                if (oldHitCount == newHitCount && newHitCount == 0) {
                    return;
                }
                breakpoint.setHitCount(newHitCount);
                continue;
            }
            catch (CoreException ce) {
                JavaScriptDebugUIPlugin.log(ce);
            }
lbl18:
            // 4 sources

            ** while (itr.hasNext())
        }
lbl19:
        // 1 sources

    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected int hitCountDialog(IJavaScriptBreakpoint breakpoint) {
        Shell activeShell;
        HitCountDialog dialog;
        int currentHitCount = 0;
        try {
            currentHitCount = breakpoint.getHitCount();
        }
        catch (CoreException e) {
            JavaScriptDebugUIPlugin.log(e);
        }
        String initialValue = INITIAL_VALUE;
        if (currentHitCount > 0) {
            initialValue = Integer.toString(currentHitCount);
        }
        if ((dialog = new HitCountDialog(activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), initialValue)).open() == 0 && dialog.isHitCountEnabled()) {
            return Integer.parseInt(dialog.getValue().trim());
        }
        return -1;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    class HitCountDialog
    extends InputDialog {
        private boolean fHitCountEnabled;

        protected HitCountDialog(Shell parentShell, String initialValue) {
            super(parentShell, Messages.set_bp_hit_count, Messages.enter_new_hit_count, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Button checkbox = new Button(area, 32);
            GridData data = new GridData(768);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            checkbox.setLayoutData((Object)data);
            checkbox.setFont(parent.getFont());
            checkbox.setText(Messages.enable_hit_count);
            checkbox.setSelection(true);
            this.fHitCountEnabled = true;
            checkbox.addSelectionListener(new SelectionListener(this, checkbox){
                final /* synthetic */ HitCountDialog this$1;
                private final /* synthetic */ Button val$checkbox;
                {
                    this.this$1 = hitCountDialog;
                    this.val$checkbox = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    HitCountDialog.access$0(this.this$1, this.val$checkbox.getSelection());
                    HitCountDialog.access$1(this.this$1).setEnabled(HitCountDialog.access$2(this.this$1));
                    if (HitCountDialog.access$2(this.this$1)) {
                        HitCountDialog.access$3(this.this$1);
                    } else {
                        this.this$1.setErrorMessage(null);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return area;
        }

        protected boolean isHitCountEnabled() {
            return this.fHitCountEnabled;
        }

        static /* synthetic */ void access$0(HitCountDialog hitCountDialog, boolean bl) {
            hitCountDialog.fHitCountEnabled = bl;
        }

        static /* synthetic */ Text access$1(HitCountDialog hitCountDialog) {
            return hitCountDialog.getText();
        }

        static /* synthetic */ boolean access$2(HitCountDialog hitCountDialog) {
            return hitCountDialog.fHitCountEnabled;
        }

        static /* synthetic */ void access$3(HitCountDialog hitCountDialog) {
            hitCountDialog.validateInput();
        }
    }
}

