/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConfigurationV2;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.ConfigurationV2;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Target
extends BuildObject
implements ITarget {
    private static final String EMPTY_STRING = "";
    private String artifactName;
    private String binaryParserId;
    private String cleanCommand;
    private List<IConfigurationV2> configList;
    private Map<String, IConfigurationV2> configMap;
    private String defaultExtension;
    private String errorParserIds;
    private String extension;
    private boolean isAbstract = false;
    private boolean isDirty = false;
    private boolean isTest = false;
    private String makeArguments;
    private String makeCommand;
    private IResource owner;
    private ITarget parent;
    private boolean resolved = true;
    private List<String> targetArchList;
    private List<String> targetOSList;
    private List<ITool> toolList;
    private Map<String, ITool> toolMap;
    private List<ToolReference> toolReferences;
    private ProjectType createdProjectType;
    private String scannerInfoCollectorId;

    public Target(IManagedConfigElement element, String managedBuildRevision) {
        String arch;
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setManagedBuildRevision(SafeStringInterner.safeIntern((String)managedBuildRevision));
        ManagedBuildManager.addExtensionTarget(this);
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        this.artifactName = SafeStringInterner.safeIntern((String)element.getAttribute("artifactName"));
        this.binaryParserId = SafeStringInterner.safeIntern((String)element.getAttribute("binaryParser"));
        this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        this.defaultExtension = SafeStringInterner.safeIntern((String)element.getAttribute("defaultExtension"));
        this.isAbstract = Boolean.parseBoolean(element.getAttribute("isAbstract"));
        this.isTest = Boolean.parseBoolean(element.getAttribute("isTest"));
        this.cleanCommand = SafeStringInterner.safeIntern((String)element.getAttribute("cleanCommand"));
        this.makeCommand = SafeStringInterner.safeIntern((String)element.getAttribute("makeCommand"));
        this.makeArguments = SafeStringInterner.safeIntern((String)element.getAttribute("makeArguments"));
        this.scannerInfoCollectorId = SafeStringInterner.safeIntern((String)element.getAttribute("scannerInfoCollector"));
        String os = element.getAttribute("osList");
        if (os != null) {
            this.targetOSList = new ArrayList<String>();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.targetOSList.add(SafeStringInterner.safeIntern((String)osTokens[i].trim()));
                ++i;
            }
        }
        if ((arch = element.getAttribute("archList")) != null) {
            this.targetArchList = new ArrayList<String>();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.targetArchList.add(SafeStringInterner.safeIntern((String)archTokens[j].trim()));
                ++j;
            }
        }
        IManagedConfigElement[] toolRefs = element.getChildren("toolReference");
        int k = 0;
        while (k < toolRefs.length) {
            new ToolReference((BuildObject)this, toolRefs[k]);
            ++k;
        }
        IManagedConfigElement[] tools = element.getChildren("tool");
        int m = 0;
        while (m < tools.length) {
            Tool newTool = new Tool((IBuildObject)this, tools[m], managedBuildRevision);
            this.addTool(newTool);
            ++m;
        }
        IManagedConfigElement[] configs = element.getChildren("configuration");
        int n = 0;
        while (n < configs.length) {
            new ConfigurationV2(this, configs[n]);
            ++n;
        }
    }

    protected Target(IResource owner) {
        this.owner = owner;
    }

    public Target(IResource owner, ITarget parent) {
        this(owner);
        this.parent = parent;
        int id = ManagedBuildManager.getRandomNumber();
        this.setId(String.valueOf(owner.getName()) + "." + parent.getId() + "." + id);
        this.setName(parent.getName());
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        this.setArtifactName(parent.getArtifactName());
        this.binaryParserId = parent.getBinaryParserId();
        this.errorParserIds = parent.getErrorParserIds();
        this.defaultExtension = parent.getArtifactExtension();
        this.isTest = parent.isTestTarget();
        this.cleanCommand = parent.getCleanCommand();
        this.scannerInfoCollectorId = ((Target)parent).scannerInfoCollectorId;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(owner);
        buildInfo.addTarget(this);
    }

    public Target(ManagedBuildInfo buildInfo, Element element) {
        this(buildInfo.getOwner());
        String parentId;
        this.setId(element.getAttribute("id"));
        buildInfo.addTarget(this);
        this.setName(element.getAttribute("name"));
        this.artifactName = element.getAttribute("artifactName");
        if (element.hasAttribute("extension")) {
            this.extension = element.getAttribute("extension");
        }
        if ((parentId = element.getAttribute("parent")) != null) {
            this.parent = ManagedBuildManager.getTarget(null, parentId);
        }
        if (Boolean.parseBoolean(element.getAttribute("isAbstract"))) {
            this.isAbstract = true;
        }
        this.isTest = Boolean.parseBoolean(element.getAttribute("isTest"));
        if (element.hasAttribute("cleanCommand")) {
            this.cleanCommand = element.getAttribute("cleanCommand");
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("makeCommand")) {
            this.makeCommand = element.getAttribute("makeCommand");
        }
        if (element.hasAttribute("makeArguments")) {
            this.makeArguments = element.getAttribute("makeArguments");
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("configuration")) {
                new ConfigurationV2(this, (Element)child);
            }
            child = child.getNextSibling();
        }
    }

    public void addConfiguration(IConfigurationV2 configuration) {
        this.getConfigurationList().add(configuration);
        this.getConfigurationMap().put(configuration.getId(), configuration);
    }

    public void addTool(ITool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    public void addToolReference(ToolReference toolRef) {
        this.getLocalToolReferences().add(toolRef);
    }

    private void addToolsToArray(Vector<ITool> toolArray) {
        if (this.parent != null) {
            ((Target)this.parent).addToolsToArray(toolArray);
        }
        toolArray.addAll(this.getToolList());
        toolArray.addAll(this.getLocalToolReferences());
    }

    @Override
    public IConfigurationV2 createConfiguration(IConfigurationV2 parent, String id) {
        this.isDirty = true;
        return new ConfigurationV2(this, parent, id);
    }

    @Override
    public IConfigurationV2 createConfiguration(String id) {
        return new ConfigurationV2(this, id);
    }

    @Override
    public String getArtifactExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.defaultExtension == null) {
            if (this.parent != null) {
                return this.parent.getArtifactExtension();
            }
            return EMPTY_STRING;
        }
        return this.defaultExtension;
    }

    @Override
    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    @Override
    public String getBinaryParserId() {
        if (this.binaryParserId == null) {
            if (this.parent != null) {
                return this.parent.getBinaryParserId();
            }
            return EMPTY_STRING;
        }
        return this.binaryParserId;
    }

    @Override
    public String getCleanCommand() {
        if (this.cleanCommand == null) {
            if (this.parent != null) {
                return this.parent.getCleanCommand();
            }
            if (Platform.getOS().equals("win32")) {
                return "del";
            }
            return "rm";
        }
        return this.cleanCommand;
    }

    @Override
    public IConfigurationV2 getConfiguration(String id) {
        return this.getConfigurationMap().get(id);
    }

    private List<IConfigurationV2> getConfigurationList() {
        if (this.configList == null) {
            this.configList = new ArrayList<IConfigurationV2>();
        }
        return this.configList;
    }

    private Map<String, IConfigurationV2> getConfigurationMap() {
        if (this.configMap == null) {
            this.configMap = new HashMap<String, IConfigurationV2>();
        }
        return this.configMap;
    }

    @Override
    public IConfigurationV2[] getConfigurations() {
        return this.getConfigurationList().toArray(new IConfigurationV2[this.getConfigurationList().size()]);
    }

    @Override
    public String getDefaultExtension() {
        return this.defaultExtension == null ? EMPTY_STRING : this.defaultExtension;
    }

    @Override
    public String getErrorParserIds() {
        if (this.errorParserIds == null && this.parent != null) {
            return this.parent.getErrorParserIds();
        }
        return this.errorParserIds;
    }

    @Override
    public String[] getErrorParserList() {
        String parserIDs = this.getErrorParserIds();
        String[] errorParsers = null;
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{EMPTY_STRING};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = ErrorParserManager.getErrorParserAvailableIdsInContext((String)"build");
        }
        return errorParsers;
    }

    protected List<ToolReference> getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList<ToolReference>();
        }
        return this.toolReferences;
    }

    @Override
    public String getMakeArguments() {
        if (this.makeArguments == null) {
            if (this.parent != null) {
                return this.parent.getMakeArguments();
            }
            return EMPTY_STRING;
        }
        return this.makeArguments;
    }

    @Override
    public String getMakeCommand() {
        if (this.makeCommand == null) {
            if (this.parent != null) {
                return this.parent.getMakeCommand();
            }
            return "make";
        }
        return this.makeCommand;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.parent != null) {
                return this.parent.getName();
            }
            return EMPTY_STRING;
        }
        return this.name;
    }

    protected List<OptionReference> getOptionReferences(ITool tool) {
        ArrayList<OptionReference> references = new ArrayList<OptionReference>();
        ToolReference toolRef = this.getToolReference(tool);
        if (toolRef != null) {
            references.addAll(toolRef.getOptionReferenceList());
        }
        if (this.parent != null) {
            List<OptionReference> refs = ((Target)this.parent).getOptionReferences(tool);
            for (OptionReference ref : refs) {
                if (references.contains(ref)) continue;
                references.add(ref);
            }
        }
        return references;
    }

    @Override
    public IResource getOwner() {
        return this.owner;
    }

    @Override
    public ITarget getParent() {
        return this.parent;
    }

    @Override
    public String[] getTargetArchList() {
        if (this.targetArchList == null) {
            if (this.parent != null) {
                return this.parent.getTargetArchList();
            }
            return new String[]{"all"};
        }
        return this.targetArchList.toArray(new String[this.targetArchList.size()]);
    }

    @Override
    public String[] getTargetOSList() {
        if (this.targetOSList == null) {
            if (this.parent != null) {
                return this.parent.getTargetOSList();
            }
            return new String[]{"all"};
        }
        return this.targetOSList.toArray(new String[this.targetOSList.size()]);
    }

    @Override
    public ITool getTool(String id) {
        ITool result = null;
        result = this.getToolMap().get(id);
        if (result == null && this.parent != null) {
            result = ((Target)this.parent).getTool(id);
        }
        if (result == null) {
            result = ManagedBuildManager.getExtensionTool(id);
        }
        return result;
    }

    private List<ITool> getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList<ITool>();
        }
        return this.toolList;
    }

    private Map<String, ITool> getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap<String, ITool>();
        }
        return this.toolMap;
    }

    private ToolReference getToolReference(ITool tool) {
        ToolReference ref = null;
        if (tool == null) {
            return ref;
        }
        List<ToolReference> localToolReferences = this.getLocalToolReferences();
        for (ToolReference temp : localToolReferences) {
            if (!temp.references(tool)) continue;
            ref = temp;
            break;
        }
        return ref;
    }

    @Override
    public ITool[] getTools() {
        Vector<ITool> toolArray = new Vector<ITool>();
        this.addToolsToArray(toolArray);
        return toolArray.toArray(new ITool[toolArray.size()]);
    }

    @Override
    public boolean hasOverridenMakeCommand() {
        return this.makeCommand != null && !this.makeCommand.equals(this.parent.getMakeCommand()) || this.makeArguments != null && !this.makeArguments.equals(this.parent.getMakeArguments());
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        List<IConfigurationV2> configurationList = this.getConfigurationList();
        for (IConfigurationV2 cfgV2 : configurationList) {
            if (!cfgV2.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTestTarget() {
        return this.isTest;
    }

    @Override
    public boolean needsRebuild() {
        List<IConfigurationV2> configurationList = this.getConfigurationList();
        for (IConfigurationV2 cfgV2 : configurationList) {
            if (!cfgV2.needsRebuild()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeConfiguration(String id) {
        List<IConfigurationV2> configurationList = this.getConfigurationList();
        for (IConfigurationV2 config : configurationList) {
            if (!config.getId().equals(id)) continue;
            configurationList.remove(config);
            this.getConfigurationMap().remove(id);
            this.isDirty = true;
            break;
        }
    }

    public void resetMakeCommand() {
        if (this.makeCommand != null) {
            this.setDirty(true);
        }
        this.makeCommand = null;
        this.makeArguments = null;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            String parentId = SafeStringInterner.safeIntern((String)element.getAttribute("parent"));
            if (parentId != null) {
                this.parent = ManagedBuildManager.getTarget(null, parentId);
                ((Target)this.parent).resolveReferences();
                IConfigurationV2[] parentConfigs = this.parent.getConfigurations();
                IConfigurationV2[] iConfigurationV2Array = parentConfigs;
                int n = parentConfigs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationV2 cfgV2 = iConfigurationV2Array[n2];
                    this.addConfiguration(cfgV2);
                    ++n2;
                }
            }
            List<ITool> toolList = this.getToolList();
            for (ITool current : toolList) {
                ((Tool)current).resolveReferences();
            }
            List<ToolReference> localToolReferences = this.getLocalToolReferences();
            for (ToolReference current : localToolReferences) {
                current.resolveReferences();
            }
            List<IConfigurationV2> configurationList = this.getConfigurationList();
            for (IConfigurationV2 current : configurationList) {
                ((ConfigurationV2)current).resolveReferences();
            }
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.getId());
        element.setAttribute("name", this.getName());
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        element.setAttribute("isAbstract", this.isAbstract ? "true" : "false");
        element.setAttribute("artifactName", this.getArtifactName());
        if (this.extension != null) {
            element.setAttribute("extension", this.extension);
        }
        element.setAttribute("isTest", this.isTest ? "true" : "false");
        if (this.makeCommand != null) {
            element.setAttribute("makeCommand", this.makeCommand);
        }
        if (this.makeArguments != null) {
            element.setAttribute("makeArguments", this.makeArguments);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        List<IConfigurationV2> configurationList = this.getConfigurationList();
        for (IConfigurationV2 config : configurationList) {
            Element configElement = doc.createElement("configuration");
            element.appendChild(configElement);
            ((ConfigurationV2)config).serialize(doc, configElement);
        }
        this.isDirty = false;
    }

    @Override
    public void setArtifactExtension(String extension) {
        if (extension != null) {
            this.extension = extension;
            this.isDirty = true;
        }
    }

    @Override
    public void setArtifactName(String name) {
        if (name != null) {
            this.artifactName = name;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        List<IConfigurationV2> configurationList = this.getConfigurationList();
        for (IConfigurationV2 config : configurationList) {
            config.setDirty(isDirty);
        }
    }

    @Override
    public void setErrorParserIds(String ids) {
        if (ids == null) {
            return;
        }
        String currentIds = this.getErrorParserIds();
        if (currentIds == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    @Override
    public void setMakeArguments(String makeArgs) {
        if (makeArgs != null && !this.getMakeArguments().equals(makeArgs)) {
            this.makeArguments = makeArgs;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    @Override
    public void setMakeCommand(String command) {
        if (command != null && !this.getMakeCommand().equals(command)) {
            this.makeCommand = command;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        List<IConfigurationV2> configurationList = this.getConfigurationList();
        for (IConfigurationV2 config : configurationList) {
            config.setRebuildState(rebuild);
        }
    }

    @Override
    public void updateOwner(IResource resource) {
        if (!resource.equals((Object)this.owner)) {
            this.owner = resource;
        }
    }

    @Override
    public void convertToProjectType(String managedBuildRevision) {
        ProjectType projectType;
        ProjectType parentProj = null;
        if (this.parent != null && (parentProj = this.parent.getCreatedProjectType()) == null) {
            this.parent.convertToProjectType(managedBuildRevision);
            parentProj = this.parent.getCreatedProjectType();
        }
        this.createdProjectType = projectType = new ProjectType(parentProj, this.getId(), this.getName(), managedBuildRevision);
        projectType.setIsAbstract(this.isAbstract);
        projectType.setIsTest(this.isTest);
        List<IConfigurationV2> configurationList = this.getConfigurationList();
        for (IConfigurationV2 configV2 : configurationList) {
            int i;
            IToolReference[] toolRefs;
            if (configV2.getCreatedConfig() != null) continue;
            IConfiguration configSuperClass = null;
            IConfigurationV2 parentV2 = configV2.getParent();
            if (parentV2 != null) {
                configSuperClass = parentV2.getCreatedConfig();
            }
            String id = configV2.getId();
            String name = configV2.getName();
            IConfiguration config = projectType.createConfiguration(configSuperClass, id, name);
            configV2.setCreatedConfig(config);
            config.setArtifactName(this.getArtifactName());
            config.setArtifactExtension(this.getArtifactExtension());
            config.setCleanCommand(this.getCleanCommand());
            config.setErrorParserIds(this.getErrorParserIds());
            String subId = String.valueOf(id) + ".toolchain";
            String subName = String.valueOf(name) + ".toolchain";
            IToolChain toolChain = config.createToolChain(null, subId, subName, true);
            toolChain.setIsAbstract(this.isAbstract);
            toolChain.setOSList(this.getTargetOSList());
            toolChain.setArchList(this.getTargetArchList());
            if (this.scannerInfoCollectorId != null && this.scannerInfoCollectorId.equals("org.eclipse.cdt.managedbuilder.internal.scannerconfig.DefaultGCCScannerInfoCollector")) {
                toolChain.setScannerConfigDiscoveryProfileId(ManagedBuildCPathEntryContainer.MM_PP_DISCOVERY_PROFILE_ID);
            }
            subId = String.valueOf(id) + ".builder";
            subName = String.valueOf(name) + ".builder";
            IBuilder builder = toolChain.createBuilder(null, subId, subName, true);
            builder.setIsAbstract(this.isAbstract);
            builder.setCommand(this.getMakeCommand());
            builder.setArguments(this.getMakeArguments());
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            if (element instanceof DefaultManagedConfigElement) {
                ((Builder)builder).setBuildFileGeneratorElement(((DefaultManagedConfigElement)element).getConfigurationElement());
            }
            subId = String.valueOf(id) + ".targetplatform";
            subName = String.valueOf(name) + ".targetplatform";
            ITargetPlatform targetPlatform = toolChain.createTargetPlatform(null, subId, subName, true);
            targetPlatform.setIsAbstract(this.isAbstract);
            targetPlatform.setOSList(this.getTargetOSList());
            targetPlatform.setArchList(this.getTargetArchList());
            targetPlatform.setBinaryParserList(new String[]{this.getBinaryParserId()});
            IToolReference[] configToolRefs = configV2.getToolReferences();
            Vector targetToolRefs = new Vector();
            this.addTargetToolReferences(targetToolRefs);
            if (targetToolRefs.size() > 0) {
                toolRefs = new IToolReference[targetToolRefs.size() + configToolRefs.length];
                i = 0;
                while (i < configToolRefs.length) {
                    toolRefs[i] = configToolRefs[i];
                    ++i;
                }
                for (IToolReference toolRef : targetToolRefs) {
                    toolRefs[i++] = toolRef;
                }
            } else {
                toolRefs = configToolRefs;
            }
            i = 0;
            while (i < toolRefs.length) {
                IToolReference toolRef;
                toolRef = toolRefs[i];
                subId = String.valueOf(id) + "." + toolRef.getId();
                ITool newTool = toolChain.createTool(toolRef.getTool(), subId, toolRef.getName(), true);
                newTool.setToolCommand(toolRef.getRawToolCommand());
                newTool.setOutputPrefix(toolRef.getRawOutputPrefix());
                newTool.setOutputFlag(toolRef.getRawOutputFlag());
                newTool.setOutputsAttribute(toolRef.getRawOutputExtensions());
                List<OptionReference> optionReferenceList = toolRef.getOptionReferenceList();
                for (OptionReference optRef : optionReferenceList) {
                    subId = String.valueOf(id) + "." + optRef.getId();
                    IOption newOption = newTool.createOption(optRef.getOption(), subId, optRef.getName(), true);
                    newOption.setValue(optRef.getValue());
                    newOption.setValueType(optRef.getValueType());
                    ((Option)newOption).setWasOptRef(true);
                }
                ++i;
            }
            ITool[] configTools = configV2.getTools();
            int i2 = 0;
            while (i2 < configTools.length) {
                ITool tool = configTools[i2];
                if (!(tool instanceof ToolReference)) {
                    boolean found = false;
                    ITool[] tools = toolChain.getTools();
                    int j = 0;
                    while (j < tools.length) {
                        ITool currentTool = tools[j];
                        ITool supercurrentTool = currentTool.getSuperClass();
                        if (supercurrentTool != null && supercurrentTool.getId() == tool.getId()) {
                            found = true;
                            ((Tool)tool).setToolParent(null);
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        ((ToolChain)toolChain).addTool((Tool)tool);
                    }
                }
                ++i2;
            }
            ((ToolChain)toolChain).normalizeOutputExtensions();
        }
    }

    public void addTargetToolReferences(Vector toolRefs) {
        toolRefs.addAll(this.getLocalToolReferences());
        if (this.parent != null) {
            Target targetParent = (Target)this.parent;
            targetParent.addTargetToolReferences(toolRefs);
        }
    }

    @Override
    public ProjectType getCreatedProjectType() {
        return this.createdProjectType;
    }

    @Override
    public Version getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
    }
}

