/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.html.core.internal.htmlcss.AbstractStyleSheetAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.HTMLDocumentAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StyleElementAdapter
extends AbstractStyleSheetAdapter
implements IStructuredDocumentListener {
    private boolean replaceModel = true;
    private boolean ignoreNotification = false;

    protected StyleElementAdapter() {
    }

    private void changeStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        IStructuredDocumentRegion last;
        int count;
        if (flatNode == null) {
            return;
        }
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        ICSSModel model = this.getExistingModel();
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        Node child = element.getFirstChild();
        if (child == null || child.getNodeType() != 3) {
            return;
        }
        IDOMNode content = (IDOMNode)child;
        int oldLength = content.getEndOffset() - content.getStartOffset();
        int newLength = 0;
        IStructuredDocumentRegionList flatNodes = structuredDocument.getRegionList();
        if (flatNodes != null && (count = flatNodes.getLength()) > 0 && (last = flatNodes.item(count - 1)) != null) {
            newLength = last.getEnd();
        }
        int offset = flatNode.getStart();
        int end = flatNode.getEnd();
        int diff = oldLength - newLength;
        int length = end - offset + diff;
        String data = flatNode.getText();
        this.replaceData(offset, length, data);
    }

    /*
     * Unable to fully structure code
     */
    private void contentChanged() {
        block10: {
            block9: {
                element = this.getElement();
                if (element == null) {
                    return;
                }
                model = this.getExistingModel();
                if (model == null) {
                    return;
                }
                structuredDocument = model.getStructuredDocument();
                if (structuredDocument == null) {
                    return;
                }
                data = null;
                child = element.getFirstChild();
                if (child != null && child.getNodeType() == 3 && child.getNextSibling() == null) {
                    data = child.getNodeValue();
                }
                if (data == null) {
                    data = "";
                }
                start = 0;
                end = 0;
                oldData = structuredDocument.get();
                if (oldData == null) {
                    oldData = "";
                }
                while (start < oldData.length() && start < data.length()) {
                    if (oldData.charAt(start) != data.charAt(start)) break;
                    ++start;
                }
                if (start == oldData.length() && start == data.length()) {
                    return;
                }
                if (start != oldData.length()) break block9;
                structuredDocument.replaceText(this.getRequesterH2C(), start, 0, data.substring(start));
                break block10;
            }
            if (start != data.length()) ** GOTO lbl38
            structuredDocument.replaceText(this.getRequesterH2C(), start, oldData.length() - start, "");
            break block10;
            while (oldData.charAt(oldData.length() - end - 1) == data.charAt(data.length() - end - 1)) {
                ++end;
lbl38:
                // 2 sources

                if (start < oldData.length() - end && start < data.length() - end) continue;
            }
            structuredDocument.replaceText(this.getRequesterH2C(), start, oldData.length() - end - start, data.substring(start, data.length() - end));
        }
    }

    public ICSSModel getModel() {
        ICSSModel model = this.getExistingModel();
        if (this.replaceModel) {
            IModelProvideAdapter adapter;
            ICSSModel oldModel = model;
            model = this.createModel(false);
            this.setModel(model, false);
            this.contentChanged();
            IModelProvideAdapter modelProvideAdapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class);
            if (modelProvideAdapter != null) {
                modelProvideAdapter.modelProvided((IStructuredModel)model);
            }
            IStructuredDocument structuredDocument = null;
            if (model != null) {
                structuredDocument = model.getStructuredDocument();
            }
            if (structuredDocument == null) {
                return null;
            }
            structuredDocument.addDocumentChangedListener((IStructuredDocumentListener)this);
            if (oldModel != null) {
                oldModel.removeStyleListener((ICSSStyleListener)this);
            }
            if (model != null) {
                model.addStyleListener((ICSSStyleListener)this);
            }
            if (oldModel != null && (adapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class)) != null) {
                adapter.modelRemoved((IStructuredModel)oldModel);
            }
            this.replaceModel = false;
        }
        return model;
    }

    protected boolean isValidAttribute() {
        Element element = this.getElement();
        if (element == null) {
            return false;
        }
        String type = element.getAttribute("type");
        return !element.hasAttribute("type") || type.length() <= 0 || type.equalsIgnoreCase("text/css");
    }

    protected ICSSModel createModel() {
        return this.createModel(true);
    }

    protected ICSSModel createModel(boolean addListener) {
        if (!this.isValidAttribute()) {
            return null;
        }
        ICSSModel model = super.createModel(addListener);
        if (!addListener) {
            return model;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return null;
        }
        structuredDocument.addDocumentChangedListener((IStructuredDocumentListener)this);
        return model;
    }

    private Object getRequesterH2C() {
        return this.getElement() != null && ((IDOMNode)this.getElement()).getModel() != null ? ((IDOMNode)this.getElement()).getModel() : this;
    }

    private Object getRequesterC2H() {
        return this.getModel() != null ? this.getModel() : this;
    }

    public void newModel(NewDocumentEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this.getRequesterH2C()) {
            return;
        }
        IStructuredDocument structuredDocument = event.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        IStructuredDocumentRegionList flatNodes = structuredDocument.getRegionList();
        if (flatNodes == null) {
            return;
        }
        this.replaceStructuredDocumentRegions(flatNodes, null);
    }

    public void noChange(NoChangeEvent structuredDocumentEvent) {
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this.getRequesterH2C()) {
            return;
        }
        IStructuredDocumentRegionList oldStructuredDocumentRegions = event.getOldStructuredDocumentRegions();
        IStructuredDocumentRegionList newStructuredDocumentRegions = event.getNewStructuredDocumentRegions();
        if (oldStructuredDocumentRegions == null && newStructuredDocumentRegions == null) {
            return;
        }
        this.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.ignoreNotification) {
            return;
        }
        if (eventType == 2 || eventType == 3 || eventType == 5) {
            this.contentChanged();
        } else if (eventType == 1) {
            Attr attr = (Attr)changedFeature;
            if (attr == null) {
                return;
            }
            String name = attr.getName();
            if (name.equalsIgnoreCase("type")) {
                this.replaceModel = true;
                Element element = this.getElement();
                if (element == null) {
                    return;
                }
                Document document = element.getOwnerDocument();
                if (document == null) {
                    return;
                }
                HTMLDocumentAdapter adapter = (HTMLDocumentAdapter)((INodeNotifier)document).getAdapterFor(IStyleSheetListAdapter.class);
                if (adapter != null) {
                    adapter.childReplaced();
                }
            }
        }
    }

    public void regionChanged(RegionChangedEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this.getRequesterH2C()) {
            return;
        }
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        this.changeStructuredDocumentRegion(flatNode);
    }

    public void regionsReplaced(RegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this.getRequesterH2C()) {
            return;
        }
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        this.changeStructuredDocumentRegion(flatNode);
    }

    private void replaceData(int offset, int length, String data) {
        IDOMNode element = (IDOMNode)this.getElement();
        if (element == null) {
            return;
        }
        IDOMModel ownerModel = element.getModel();
        if (ownerModel == null) {
            return;
        }
        IStructuredDocument structuredDocument = ownerModel.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = element.getStartStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        int contentOffset = flatNode.getEndOffset();
        if (data == null) {
            data = "";
        }
        this.ignoreNotification = true;
        structuredDocument.replaceText(this.getRequesterC2H(), contentOffset + offset, length, data);
        this.ignoreNotification = false;
    }

    private void replaceStructuredDocumentRegions(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        int count;
        int count2;
        int offset = 0;
        int length = 0;
        if (oldStructuredDocumentRegions != null && (count2 = oldStructuredDocumentRegions.getLength()) > 0) {
            IStructuredDocumentRegion last;
            IStructuredDocumentRegion first = oldStructuredDocumentRegions.item(0);
            if (first != null) {
                offset = first.getStart();
            }
            if ((last = oldStructuredDocumentRegions.item(count2 - 1)) != null) {
                length = last.getEnd() - offset;
            }
        }
        String data = null;
        if (newStructuredDocumentRegions != null && (count = newStructuredDocumentRegions.getLength()) > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion flatNode = newStructuredDocumentRegions.item(i);
                if (flatNode != null) {
                    buffer.append(flatNode.getText());
                    if (i == 0) {
                        offset = flatNode.getStart();
                    }
                }
                ++i;
            }
            data = buffer.toString();
        }
        this.replaceData(offset, length, data);
    }

    protected void setModel(ICSSModel model) {
        this.setModel(model, true);
    }

    protected void setModel(ICSSModel model, boolean setupListener) {
        ICSSModel oldModel = this.getExistingModel();
        if (model == oldModel) {
            return;
        }
        super.setModel(model);
        if (!setupListener) {
            return;
        }
        if (oldModel != null) {
            oldModel.removeStyleListener((ICSSStyleListener)this);
        }
        if (model != null) {
            model.addStyleListener((ICSSStyleListener)this);
        }
    }
}

