/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class ProjectRecord {
    private final File projectSystemFile;
    private String projectName;
    private IProjectDescription description;

    public ProjectRecord(File file) {
        this.projectSystemFile = file;
        Path path = new Path(this.projectSystemFile.getPath());
        try {
            if (this.isDefaultLocation((IPath)path)) {
                this.projectName = path.segment(path.segmentCount() - 2);
                this.description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
            } else {
                this.description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
                this.projectName = this.description.getName();
            }
        }
        catch (CoreException coreException) {
            this.description = null;
            this.projectName = path.lastSegment();
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectLabel() {
        String path = this.projectSystemFile.getParent();
        return NLS.bind((String)"{0} ({1})", (Object)this.projectName, (Object)path);
    }

    public IProjectDescription getProjectDescription() {
        return this.description;
    }

    public void setProjectDescription(IProjectDescription description) {
        this.description = description;
    }

    public File getProjectSystemFile() {
        return this.projectSystemFile;
    }

    public String toString() {
        return this.projectName;
    }

    private boolean isDefaultLocation(IPath path) {
        if (path.segmentCount() < 2) {
            return false;
        }
        return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
    }
}

