/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import org.eclipse.egit.core.op.FetchOperationResult;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.TitleAndImageDialog;
import org.eclipse.egit.ui.internal.fetch.FetchResultTable;
import org.eclipse.egit.ui.internal.fetch.SimpleConfigureFetchDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FetchResultDialog
extends TitleAndImageDialog {
    private static final int CONFIGURE = 99;
    private final Repository localDb;
    private final FetchOperationResult result;
    private final String sourceString;
    private boolean hideConfigure;

    public FetchResultDialog(Shell parentShell, Repository localDb, FetchOperationResult result, String sourceString) {
        super(parentShell, UIIcons.WIZBAN_FETCH);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF | 0x10);
        this.setBlockOnOpen(false);
        this.localDb = localDb;
        this.result = result;
        this.sourceString = sourceString;
    }

    public FetchResultDialog(Shell parentShell, Repository localDb, FetchResult result, String sourceString) {
        this(parentShell, localDb, new FetchOperationResult(result.getURI(), result), sourceString);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.hideConfigure && SimpleConfigureFetchDialog.getConfiguredRemote(this.localDb) != null) {
            this.createButton(parent, 99, UIText.FetchResultDialog_ConfigureButton, false);
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 99) {
            super.buttonPressed(0);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Dialog dlg = SimpleConfigureFetchDialog.getDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), FetchResultDialog.this.localDb);
                    dlg.open();
                }
            });
        }
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(NLS.bind((String)UIText.FetchResultDialog_labelNonEmptyResult, (Object)this.sourceString));
        if (this.result.getErrorMessage() != null) {
            this.setErrorMessage(this.result.getErrorMessage());
        } else if (this.result.getFetchResult() != null && this.result.getFetchResult().getTrackingRefUpdates().isEmpty()) {
            this.setMessage(NLS.bind((String)UIText.FetchResultDialog_labelEmptyResult, (Object)this.sourceString));
        }
        this.createFetchResultTable(composite);
        FetchResultDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public Control createFetchResultTable(Composite parent) {
        FetchResultTable table = new FetchResultTable(parent);
        if (this.result.getFetchResult() != null) {
            table.setData(this.localDb, this.result.getFetchResult());
        }
        Control tableControl = table.getControl();
        GridDataFactory.fillDefaults().grab(true, true).hint(600, 300).applyTo(tableControl);
        return table.getControl();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)UIText.FetchResultDialog_title, (Object)this.sourceString));
    }

    public void showConfigureButton(boolean show) {
        this.hideConfigure = !show;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogBoundSettings(((Object)((Object)this)).getClass());
    }
}

