/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.DecorationOverlayDescriptor;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.WorkbenchStyledLabelProvider;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;

class FetchResultTable {
    private final Composite treePanel;
    private final TreeViewer treeViewer;
    private Repository repo;
    private ObjectReader reader;
    private Map<ObjectId, String> abbrevations;

    FetchResultTable(Composite parent) {
        this.treePanel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.treePanel);
        this.treeViewer = new TreeViewer(this.treePanel);
        this.treeViewer.setAutoExpandLevel(2);
        this.addToolbar(this.treePanel);
        WorkbenchStyledLabelProvider styleProvider = new WorkbenchStyledLabelProvider(){

            @Override
            public StyledString getStyledText(Object element) {
                if (element instanceof FetchResultAdapter) {
                    return ((FetchResultAdapter)((Object)element)).getStyledText(element);
                }
                if (element instanceof RepositoryCommit) {
                    return ((RepositoryCommit)((Object)element)).getStyledText(element);
                }
                return super.getStyledText(element);
            }
        };
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(styleProvider){

            public String getToolTipText(Object element) {
                if (element instanceof FetchResultAdapter) {
                    switch (((FetchResultAdapter)((Object)element)).update.getResult()) {
                        case FAST_FORWARD: {
                            return UIText.FetchResultTable_statusDetailFastForward;
                        }
                        case FORCED: 
                        case REJECTED: {
                            return UIText.FetchResultTable_statusDetailNonFastForward;
                        }
                        case IO_FAILURE: {
                            return UIText.FetchResultTable_statusDetailIOError;
                        }
                        case LOCK_FAILURE: {
                            return UIText.FetchResultTable_statusDetailCouldntLock;
                        }
                    }
                    return super.getToolTipText(element);
                }
                return super.getToolTipText(element);
            }
        });
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof FetchResultAdapter && e2 instanceof FetchResultAdapter) {
                    FetchResultAdapter f1 = (FetchResultAdapter)((Object)e1);
                    FetchResultAdapter f2 = (FetchResultAdapter)((Object)e2);
                    if (f1.getChildren((Object)f1).length > 0 && f2.getChildren((Object)f2).length == 0) {
                        return 1;
                    }
                    if (f1.getChildren((Object)f1).length == 0 && f2.getChildren((Object)f2).length > 0) {
                        return -1;
                    }
                    return f1.getLabel((Object)f1).compareToIgnoreCase(f2.getLabel((Object)f2));
                }
                if (e1 instanceof RepositoryCommit && e2 instanceof RepositoryCommit) {
                    return 0;
                }
                if (e1 instanceof FileDiff && e2 instanceof FileDiff) {
                    FileDiff f1 = (FileDiff)((Object)e1);
                    FileDiff f2 = (FileDiff)((Object)e2);
                    return f1.getPath().compareTo(f2.getPath());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        Tree tree = this.treeViewer.getTree();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        this.treePanel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FetchResultTable.this.reader != null) {
                    FetchResultTable.this.reader.close();
                }
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new FetchResultAdapter[0];
                }
                FetchResult result = (FetchResult)inputElement;
                TrackingRefUpdate[] updates = result.getTrackingRefUpdates().toArray(new TrackingRefUpdate[0]);
                FetchResultAdapter[] elements = new FetchResultAdapter[updates.length];
                int i = 0;
                while (i < elements.length) {
                    elements[i] = new FetchResultAdapter(updates[i]);
                    ++i;
                }
                return elements;
            }

            public Object[] getChildren(Object element) {
                if (element instanceof RepositoryCommit) {
                    return ((RepositoryCommit)((Object)element)).getDiffs();
                }
                return super.getChildren(element);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof RepositoryCommit) {
                    return true;
                }
                return super.hasChildren(element);
            }
        });
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.treeViewer){

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                this.handleOpen(selection, OpenStrategy.activateOnOpen());
            }

            protected void activate(ISelection selection) {
                this.handleOpen(selection, true);
            }

            private void handleOpen(ISelection selection, boolean activateOnOpen) {
                if (selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof RepositoryCommit) {
                            CommitEditor.openQuiet((RepositoryCommit)((Object)element), activateOnOpen);
                        }
                        ++n2;
                    }
                }
            }
        };
    }

    private void addToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 512);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)toolbar);
        UIUtils.addExpansionItems(toolbar, (AbstractTreeViewer)this.treeViewer);
    }

    void setData(Repository db, FetchResult fetchResult) {
        this.treeViewer.setInput(null);
        this.repo = db;
        this.reader = db.newObjectReader();
        this.abbrevations = new HashMap<ObjectId, String>();
        this.treeViewer.setInput((Object)fetchResult);
    }

    private String safeAbbreviate(ObjectId id) {
        String abbrev = this.abbrevations.get(id);
        if (abbrev == null) {
            try {
                abbrev = this.reader.abbreviate((AnyObjectId)id).name();
            }
            catch (IOException iOException) {
                abbrev = id.name();
            }
            this.abbrevations.put(id, abbrev);
        }
        return abbrev;
    }

    Control getControl() {
        return this.treePanel;
    }

    private class FetchResultAdapter
    extends WorkbenchAdapter {
        private final TrackingRefUpdate update;
        private Object[] children;

        public FetchResultAdapter(TrackingRefUpdate update) {
            this.update = update;
        }

        public String getLabel(Object object) {
            return this.getStyledText(object).getString();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            switch (this.update.getResult()) {
                case LOCK_FAILURE: 
                case REJECTED: 
                case REJECTED_CURRENT_BRANCH: 
                case IO_FAILURE: {
                    return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
                }
                case FORCED: {
                    if (this.isPruned()) {
                        ImageDescriptor icon = UIIcons.BRANCH;
                        if (this.update.getLocalName().startsWith("refs/tags/")) {
                            icon = UIIcons.TAG;
                        }
                        if (this.update.getLocalName().startsWith("refs/notes/")) {
                            icon = UIIcons.NOTE;
                        }
                        return new DecorationOverlayDescriptor(icon, UIIcons.OVR_STAGED_REMOVE, 1);
                    }
                }
                case FAST_FORWARD: 
                case RENAMED: {
                    if (this.update.getRemoteName().startsWith("refs/heads/")) {
                        return UIIcons.BRANCH;
                    }
                    if (this.update.getLocalName().startsWith("refs/tags/")) {
                        return UIIcons.TAG;
                    }
                    if (!this.update.getLocalName().startsWith("refs/notes/")) break;
                    return UIIcons.NOTE;
                }
                case NEW: {
                    if (this.update.getRemoteName().startsWith("refs/heads/")) {
                        return UIIcons.CREATE_BRANCH;
                    }
                    if (this.update.getLocalName().startsWith("refs/tags/")) {
                        return UIIcons.CREATE_TAG;
                    }
                    if (!this.update.getLocalName().startsWith("refs/notes/")) break;
                    return UIIcons.NOTE;
                }
                default: {
                    return super.getImageDescriptor(object);
                }
            }
            return super.getImageDescriptor(object);
        }

        private void addCommits(StyledString styled, String separator) {
            styled.append('[', StyledString.DECORATIONS_STYLER);
            styled.append(FetchResultTable.this.safeAbbreviate(this.update.getNewObjectId()), StyledString.DECORATIONS_STYLER);
            styled.append(separator, StyledString.DECORATIONS_STYLER);
            styled.append(FetchResultTable.this.safeAbbreviate(this.update.getOldObjectId()), StyledString.DECORATIONS_STYLER);
            styled.append(']', StyledString.DECORATIONS_STYLER);
            styled.append(MessageFormat.format(UIText.FetchResultTable_counterCommits, this.getChildren((Object)this).length), StyledString.COUNTER_STYLER);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object[] getChildren(Object object) {
            if (this.children != null) {
                return this.children;
            }
            switch (this.update.getResult()) {
                case FORCED: {
                    if (this.isPruned()) {
                        return NO_CHILDREN;
                    }
                }
                case FAST_FORWARD: {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try {
                            RevWalk walk = new RevWalk(FetchResultTable.this.reader);
                            try {
                                walk.setRetainBody(true);
                                walk.markStart(walk.parseCommit((AnyObjectId)this.update.getNewObjectId()));
                                walk.markUninteresting(walk.parseCommit((AnyObjectId)this.update.getOldObjectId()));
                                ArrayList<RepositoryCommit> commits = new ArrayList<RepositoryCommit>();
                                for (RevCommit commit : walk) {
                                    commits.add(new RepositoryCommit(FetchResultTable.this.repo, commit));
                                }
                                this.children = commits.toArray();
                                return this.children;
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                            finally {
                                if (walk == null) return this.children;
                                walk.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            } else {
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        Activator.logError("Error parsing commits from fetch result", e);
                    }
                }
                default: {
                    this.children = super.getChildren(object);
                }
            }
            return this.children;
        }

        protected String shortenRef(String ref) {
            return NoteMap.shortenRefName((String)Repository.shortenRefName((String)ref));
        }

        public StyledString getStyledText(Object object) {
            StyledString styled = new StyledString();
            String remote = this.update.getRemoteName();
            String local = this.update.getLocalName();
            styled.append(this.shortenRef(remote));
            styled.append(" : ", StyledString.QUALIFIER_STYLER);
            styled.append(this.shortenRef(local), StyledString.QUALIFIER_STYLER);
            styled.append(' ');
            switch (this.update.getResult()) {
                case LOCK_FAILURE: {
                    styled.append(UIText.FetchResultTable_statusLockFailure, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case IO_FAILURE: {
                    styled.append(UIText.FetchResultTable_statusIOError, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case NEW: {
                    if (remote.startsWith("refs/heads/")) {
                        styled.append(UIText.FetchResultTable_statusNewBranch, StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    if (local.startsWith("refs/tags/")) {
                        styled.append(UIText.FetchResultTable_statusNewTag, StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    styled.append(UIText.FetchResultTable_statusNew, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case FORCED: {
                    if (this.isPruned()) {
                        styled.append(UIText.FetchResultTable_statusPruned, StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    this.addCommits(styled, "...");
                    break;
                }
                case FAST_FORWARD: {
                    this.addCommits(styled, "..");
                    break;
                }
                case REJECTED: {
                    styled.append(UIText.FetchResultTable_statusRejected, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case NO_CHANGE: {
                    styled.append(UIText.FetchResultTable_statusUpToDate, StyledString.DECORATIONS_STYLER);
                    break;
                }
            }
            return styled;
        }

        private boolean isPruned() {
            return this.update.getNewObjectId().equals((AnyObjectId)ObjectId.zeroId());
        }
    }
}

