/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.RepositorySearchWizard;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.team.core.RepositoryProvider;

public class AddCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositorySearchWizard wizard = new RepositorySearchWizard(this.util.getConfiguredRepositories(), true);
        WizardDialog dialog = new WizardDialog(this.getShell(event), (IWizard)wizard);
        if (dialog.open() == 0) {
            for (String dir : wizard.getDirectories()) {
                File repositoryDir = FileUtils.canonicalize((File)new File(dir));
                this.addRepository(repositoryDir);
            }
        }
        return null;
    }

    private void addRepository(File repositoryDir) {
        GerritUtil.tryToAutoConfigureForGerrit((File)repositoryDir);
        this.util.addConfiguredRepository(repositoryDir);
        if (this.doAutoShare()) {
            this.autoShareProjects(repositoryDir);
        }
    }

    private void autoShareProjects(File repositoryDir) {
        IProject[] projects;
        Path workingDirPath;
        try {
            Repository repo = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().lookupRepository(repositoryDir);
            if (repo.isBare()) {
                return;
            }
            workingDirPath = new Path(repo.getWorkTree().getAbsolutePath());
        }
        catch (IOException e) {
            Activator.logError(e.getLocalizedMessage(), e);
            return;
        }
        HashMap<IProject, File> connections = new HashMap<IProject, File>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            RepositoryProvider provider;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project)) == null && (location = project.getLocation()) != null && workingDirPath.isPrefixOf(location)) {
                RepositoryFinder f = new RepositoryFinder(project);
                f.setFindInChildren(false);
                try {
                    IPath gitDir;
                    List mappings = f.find((IProgressMonitor)new NullProgressMonitor());
                    if (!mappings.isEmpty() && (gitDir = ((RepositoryMapping)mappings.get(0)).getGitDirAbsolutePath()) != null) {
                        connections.put(project, gitDir.toFile());
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        if (!connections.isEmpty()) {
            ConnectProviderOperation operation = new ConnectProviderOperation(connections);
            operation.setRefreshResources(false);
            JobUtil.scheduleUserJob((IEGitOperation)operation, (String)CoreText.Activator_AutoShareJobName, (Object)JobFamilies.AUTO_SHARE);
        }
    }

    private boolean doAutoShare() {
        IEclipsePreferences d = DefaultScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId());
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId());
        return p.getBoolean("core_autoShareProjects", d.getBoolean("core_autoShareProjects", true));
    }
}

