/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.UnmergedBranchDialog;
import org.eclipse.egit.ui.internal.repository.tree.BranchHierarchyNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class DeleteBranchCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        final Map<Ref, Repository> refs = this.getRefsToDelete(nodes);
        final AtomicReference unmergedNodesRef = new AtomicReference();
        Shell shell = this.getShell(event);
        try {
            new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Map unmergedNodes = DeleteBranchCommand.this.deleteBranches(refs, false, monitor);
                    unmergedNodesRef.set(unmergedNodes);
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException interruptedException) {}
        if (((Map)unmergedNodesRef.get()).isEmpty()) {
            return null;
        }
        UnmergedBranchDialog messageDialog = new UnmergedBranchDialog(shell, new ArrayList(((Map)unmergedNodesRef.get()).keySet()));
        if (messageDialog.open() != 0) {
            return null;
        }
        try {
            new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DeleteBranchCommand.this.deleteBranches((Map)unmergedNodesRef.get(), true, monitor);
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private Map<Ref, Repository> getRefsToDelete(List<RepositoryTreeNode> nodes) {
        LinkedHashMap<Ref, Repository> refs = new LinkedHashMap<Ref, Repository>();
        for (RepositoryTreeNode node : nodes) {
            if (node instanceof BranchHierarchyNode) {
                try {
                    for (Ref ref : ((BranchHierarchyNode)node).getChildRefsRecursive()) {
                        refs.put(ref, node.getRepository());
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            if (!(node instanceof RefNode)) continue;
            refs.put((Ref)node.getObject(), node.getRepository());
        }
        return refs;
    }

    private Map<Ref, Repository> deleteBranches(final Map<Ref, Repository> refs, final boolean forceDeletionOfUnmergedBranches, IProgressMonitor progressMonitor) throws InvocationTargetException {
        final LinkedHashMap<Ref, Repository> unmergedNodes = new LinkedHashMap<Ref, Repository>();
        try {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        monitor.beginTask(UIText.DeleteBranchCommand_DeletingBranchesProgress, refs.size());
                        for (Map.Entry entry : refs.entrySet()) {
                            Ref ref;
                            Repository repository = (Repository)entry.getValue();
                            int result = DeleteBranchCommand.this.deleteBranch(repository, ref = (Ref)entry.getKey(), forceDeletionOfUnmergedBranches);
                            if (result == 1) {
                                throw new CoreException(Activator.createErrorStatus(UIText.DeleteBranchCommand_CannotDeleteCheckedOutBranch, null));
                            }
                            if (result == 2) {
                                unmergedNodes.put(ref, repository);
                                continue;
                            }
                            monitor.worked(1);
                        }
                    }
                }, progressMonitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }
        finally {
            progressMonitor.done();
        }
        return unmergedNodes;
    }

    private int deleteBranch(Repository repo, Ref ref, boolean force) throws CoreException {
        DeleteBranchOperation dbop = new DeleteBranchOperation(repo, ref, force);
        dbop.execute(null);
        return dbop.getStatus();
    }
}

