/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class EditLaunchConfigurationAction
extends SelectionListenerAction {
    private ILaunchConfiguration fConfiguration = null;
    private String fMode = null;
    private boolean fTerminated = false;

    public EditLaunchConfigurationAction() {
        super("");
        this.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.edit_launch_configuration_action_context");
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ILaunchConfiguration config;
        this.setLaunchConfiguration(null);
        this.setMode(null);
        if (selection.size() == 1) {
            ILaunchConfiguration configuration;
            Object object = selection.getFirstElement();
            ILaunch launch = null;
            if (object instanceof IAdaptable) {
                launch = (ILaunch)((IAdaptable)object).getAdapter(ILaunch.class);
            }
            if (launch == null) {
                if (object instanceof ILaunch) {
                    launch = (ILaunch)object;
                } else if (object instanceof IDebugElement) {
                    launch = ((IDebugElement)object).getLaunch();
                } else if (object instanceof IProcess) {
                    launch = ((IProcess)object).getLaunch();
                }
            }
            if (launch != null && (configuration = launch.getLaunchConfiguration()) != null) {
                try {
                    ILaunchConfiguration underlyingConfig;
                    String underlyingHandle = configuration.getAttribute(DebugUIPlugin.ATTR_LAUNCHING_CONFIG_HANDLE, "");
                    if (underlyingHandle.length() > 0 && (underlyingConfig = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(underlyingHandle)) != null) {
                        configuration = underlyingConfig;
                    }
                }
                catch (CoreException underlyingHandle) {
                    // empty catch block
                }
                this.setLaunchConfiguration(configuration);
                this.setMode(launch.getLaunchMode());
                this.setIsTerminated(launch.isTerminated());
                this.setText(MessageFormat.format((String)ActionMessages.EditLaunchConfigurationAction_1, (Object[])new Object[]{configuration.getName()}));
                ImageDescriptor descriptor = null;
                try {
                    descriptor = DebugPluginImages.getImageDescriptor(configuration.getType().getIdentifier());
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                this.setImageDescriptor(descriptor);
            }
        }
        if ((config = this.getLaunchConfiguration()) == null) {
            return false;
        }
        return !DebugUITools.isPrivate(config);
    }

    protected void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfiguration;
    }

    protected void setMode(String mode) {
        this.fMode = mode;
    }

    protected String getMode() {
        return this.fMode;
    }

    protected boolean isTerminated() {
        return this.fTerminated;
    }

    protected void setIsTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public void run() {
        ILaunchGroup group = DebugUITools.getLaunchGroup(this.getLaunchConfiguration(), this.getMode());
        if (group != null) {
            if (this.isTerminated()) {
                DebugUITools.openLaunchConfigurationDialog(DebugUIPlugin.getShell(), this.getLaunchConfiguration(), group.getIdentifier(), null);
            } else {
                DebugUIPlugin.openLaunchConfigurationEditDialog(DebugUIPlugin.getShell(), this.getLaunchConfiguration(), group.getIdentifier(), null, false);
            }
        }
    }
}

