/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class MIStringHandler {
    private static Map<Character, Integer> fSpecialCharactersToCodePointMap = new LinkedHashMap<Character, Integer>();

    static {
        fSpecialCharactersToCodePointMap.put(Character.valueOf('a'), 7);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('b'), 8);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('e'), 27);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('E'), 27);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('f'), 12);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('n'), 10);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('r'), 13);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('t'), 9);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('v'), 11);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('\''), 39);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('\"'), 34);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('\\'), 92);
        fSpecialCharactersToCodePointMap.put(Character.valueOf('?'), 63);
    }

    public static String translateCString(String str, boolean escapeChars) {
        str = escapeChars ? MIStringHandler.parseString(str, EnumSet.complementOf(EnumSet.of(ParseFlags.SPECIAL_CHARS))) : MIStringHandler.parseString(str);
        str = MIStringHandler.transcodeString(str);
        str = escapeChars ? MIStringHandler.escapeString(str, false) : str.replace("\n", System.getProperty("line.separator", "\n"));
        return str;
    }

    public static boolean isSpecialChar(char c) {
        return fSpecialCharactersToCodePointMap.containsKey(Character.valueOf(c));
    }

    public static boolean isSpecialCodePoint(int codePoint) {
        return fSpecialCharactersToCodePointMap.containsValue(codePoint);
    }

    public static int parseSpecialChar(char c) throws ParseException {
        Integer codePoint = fSpecialCharactersToCodePointMap.get(Character.valueOf(c));
        if (codePoint != null) {
            return codePoint;
        }
        throw new ParseException("The given character '" + c + "' is not a special character.", 0);
    }

    public static char parseSpecialCodePoint(int codePoint) throws ParseException {
        for (Map.Entry<Character, Integer> entry : fSpecialCharactersToCodePointMap.entrySet()) {
            if (!entry.getValue().equals(codePoint)) continue;
            return entry.getKey().charValue();
        }
        throw new ParseException("The given Unicode code point " + codePoint + " is not a special code point.", 0);
    }

    public static String parseString(String str) {
        return MIStringHandler.parseString(str, EnumSet.allOf(ParseFlags.class));
    }

    public static String parseString(String str, EnumSet<ParseFlags> parseFlags) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder escapeBuffer = new StringBuilder();
        EscapeStatus escStatus = EscapeStatus.NONE;
        int i = 0;
        while (i < str.length()) {
            boolean isLastChar;
            char c = str.charAt(i);
            boolean consumeChar = true;
            boolean bl = isLastChar = i == str.length() - 1;
            if (escStatus == EscapeStatus.NONE) {
                if (c == '\\') {
                    escapeBuffer.setLength(0);
                    escapeBuffer.append(c);
                    escStatus = EscapeStatus.BEGIN;
                }
            } else if (escStatus == EscapeStatus.BEGIN) {
                if (parseFlags.contains((Object)ParseFlags.SPECIAL_CHARS) && MIStringHandler.isSpecialChar(c)) {
                    try {
                        buffer.appendCodePoint(MIStringHandler.parseSpecialChar(c));
                        escStatus = EscapeStatus.VALID;
                    }
                    catch (ParseException e) {
                        escapeBuffer.append(c);
                        escStatus = EscapeStatus.INVALID;
                    }
                } else if (parseFlags.contains((Object)ParseFlags.OCTAL_NUMBERS) && c >= '0' && c <= '7') {
                    escStatus = EscapeStatus.OCTAL_NUMBER;
                    consumeChar = false;
                } else {
                    escStatus = parseFlags.contains((Object)ParseFlags.HEX_NUMBERS) && c == 'x' ? EscapeStatus.HEX_NUMBER : (parseFlags.contains((Object)ParseFlags.UNICODE_SHORT_NUMBERS) && c == 'u' ? EscapeStatus.UNICODE_SHORT_NUMBER : (parseFlags.contains((Object)ParseFlags.UNICODE_LONG_NUMBERS) && c == 'U' ? EscapeStatus.UNICODE_LONG_NUMBER : EscapeStatus.INVALID));
                }
                if (consumeChar) {
                    escapeBuffer.append(c);
                }
            } else if (escStatus == EscapeStatus.HEX_NUMBER) {
                boolean bl2 = consumeChar = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
                if (consumeChar) {
                    escapeBuffer.append(c);
                }
                if (!consumeChar || isLastChar || escapeBuffer.length() == 6) {
                    escStatus = EscapeStatus.INVALID;
                    if (escapeBuffer.length() > 2) {
                        try {
                            int codePoint = Integer.parseInt(escapeBuffer.toString().substring(2), 16);
                            if (codePoint <= 0x10FFFF) {
                                buffer.appendCodePoint(codePoint);
                                escStatus = EscapeStatus.VALID;
                            }
                        }
                        catch (NumberFormatException codePoint) {}
                    }
                }
            } else if (escStatus == EscapeStatus.UNICODE_SHORT_NUMBER || escStatus == EscapeStatus.UNICODE_LONG_NUMBER) {
                int finalLength;
                boolean bl3 = consumeChar = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
                if (consumeChar) {
                    escapeBuffer.append(c);
                }
                int n = finalLength = escStatus == EscapeStatus.UNICODE_SHORT_NUMBER ? 6 : 10;
                if (escapeBuffer.length() == finalLength) {
                    escStatus = EscapeStatus.INVALID;
                    try {
                        int codePoint = Integer.parseInt(escapeBuffer.toString().substring(2), 16);
                        if (codePoint <= 0x10FFFF) {
                            buffer.appendCodePoint(codePoint);
                            escStatus = EscapeStatus.VALID;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (!consumeChar || isLastChar) {
                    escStatus = EscapeStatus.INVALID;
                }
            } else if (escStatus == EscapeStatus.OCTAL_NUMBER) {
                boolean bl4 = consumeChar = c >= '0' && c <= '7';
                if (consumeChar) {
                    escapeBuffer.append(c);
                }
                if (!consumeChar || isLastChar || escapeBuffer.length() == 4) {
                    escStatus = EscapeStatus.INVALID;
                    if (escapeBuffer.length() > 1) {
                        try {
                            int codePoint = Integer.parseInt(escapeBuffer.toString().substring(1), 8);
                            if (codePoint <= 255) {
                                buffer.appendCodePoint(codePoint);
                                escStatus = EscapeStatus.VALID;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (escStatus == EscapeStatus.NONE) {
                buffer.append(c);
            } else if (escStatus == EscapeStatus.VALID) {
                escStatus = EscapeStatus.NONE;
            } else if (escStatus == EscapeStatus.INVALID) {
                buffer.append((CharSequence)escapeBuffer);
                escStatus = EscapeStatus.NONE;
            }
            if (!consumeChar) {
                --i;
            }
            ++i;
        }
        if (escStatus != EscapeStatus.NONE) {
            buffer.append((CharSequence)escapeBuffer);
        }
        return buffer.toString();
    }

    public static String transcodeString(String str) {
        try {
            CharsetEncoder latin1Encoder = Charset.forName("ISO-8859-1").newEncoder();
            ByteBuffer stringBytes = latin1Encoder.encode(CharBuffer.wrap(str.toCharArray()));
            CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder();
            str = utf8Decoder.decode(stringBytes).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static String escapeString(String str) {
        return MIStringHandler.escapeString(str, true);
    }

    public static String escapeString(String str, boolean escapePrintableSpecialChars) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            int codePoint = str.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                ++i;
            }
            int codePointType = Character.getType(codePoint);
            switch (codePointType) {
                case 0: 
                case 13: 
                case 14: 
                case 15: 
                case 18: 
                case 19: {
                    if (MIStringHandler.isSpecialCodePoint(codePoint)) {
                        buffer.append('\\');
                        try {
                            buffer.append(MIStringHandler.parseSpecialCodePoint(codePoint));
                        }
                        catch (ParseException e) {
                            buffer.appendCodePoint(codePoint);
                        }
                        break;
                    }
                    if (codePoint == 0) {
                        buffer.append("\\0");
                        break;
                    }
                    if (codePoint <= 255) {
                        buffer.append(String.format("\\%03o", codePoint));
                        break;
                    }
                    if (codePoint <= 65535) {
                        buffer.append(String.format("\\u%04x", codePoint));
                        break;
                    }
                    buffer.append(String.format("\\U%08x", codePoint));
                    break;
                }
                default: {
                    if (escapePrintableSpecialChars && MIStringHandler.isSpecialCodePoint(codePoint)) {
                        buffer.append('\\');
                        try {
                            buffer.append(MIStringHandler.parseSpecialCodePoint(codePoint));
                        }
                        catch (ParseException e) {
                            buffer.appendCodePoint(codePoint);
                        }
                        break;
                    }
                    buffer.appendCodePoint(codePoint);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static enum EscapeStatus {
        NONE,
        BEGIN,
        OCTAL_NUMBER,
        HEX_NUMBER,
        UNICODE_SHORT_NUMBER,
        UNICODE_LONG_NUMBER,
        VALID,
        INVALID;

    }

    public static enum ParseFlags {
        SPECIAL_CHARS,
        OCTAL_NUMBERS,
        HEX_NUMBERS,
        UNICODE_SHORT_NUMBERS,
        UNICODE_LONG_NUMBERS;

    }
}

