/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;
import org.eclipse.team.internal.core.subscribers.SubscriberChangeSetManager;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelProvider;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class ActiveChangeSetCollector
implements IDiffChangeListener {
    private final ISynchronizePageConfiguration configuration;
    private final Map activeSets = new HashMap();
    private SyncInfoTree rootSet = new SyncInfoTree();
    private final ChangeSetModelProvider provider;
    private IChangeSetChangeListener activeChangeSetListener = new IChangeSetChangeListener(){

        public void setAdded(final ChangeSet set) {
            ActiveChangeSetCollector.this.provider.performUpdate(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    ActiveChangeSetCollector.this.remove(set.getResources());
                    ActiveChangeSetCollector.this.createSyncInfoSet(set);
                }
            }, true, true);
        }

        public void defaultSetChanged(final ChangeSet previousDefault, final ChangeSet set) {
            ActiveChangeSetCollector.this.provider.performUpdate(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    if (ActiveChangeSetCollector.this.listener != null) {
                        ActiveChangeSetCollector.this.listener.defaultSetChanged(previousDefault, set);
                    }
                }
            }, true, true);
        }

        public void setRemoved(final ChangeSet set) {
            ActiveChangeSetCollector.this.provider.performUpdate(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    ActiveChangeSetCollector.this.remove(set);
                    if (!set.isEmpty()) {
                        ActiveChangeSetCollector.this.add(ActiveChangeSetCollector.this.getSyncInfos(set).getSyncInfos());
                    }
                }
            }, true, true);
        }

        public void nameChanged(final ChangeSet set) {
            ActiveChangeSetCollector.this.provider.performUpdate(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    if (ActiveChangeSetCollector.this.listener != null) {
                        ActiveChangeSetCollector.this.listener.nameChanged(set);
                    }
                }
            }, true, true);
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
            final ArrayList<SyncInfo> outOfSync = new ArrayList<SyncInfo>();
            int i = 0;
            while (i < paths.length) {
                SyncInfo info;
                IPath path = paths[i];
                if (!((DiffChangeSet)set).contains(path) && (info = ActiveChangeSetCollector.this.getSyncInfo(path)) != null && info.getKind() != 0) {
                    outOfSync.add(info);
                }
                ++i;
            }
            if (!outOfSync.isEmpty()) {
                ActiveChangeSetCollector.this.provider.performUpdate(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        ActiveChangeSetCollector.this.add(outOfSync.toArray(new SyncInfo[outOfSync.size()]));
                    }
                }, true, true);
            }
        }
    };
    private IChangeSetChangeListener listener;

    public ActiveChangeSetCollector(ISynchronizePageConfiguration configuration, ChangeSetModelProvider provider) {
        this.configuration = configuration;
        this.provider = provider;
        this.getActiveChangeSetManager().addListener(this.activeChangeSetListener);
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public ActiveChangeSetManager getActiveChangeSetManager() {
        ISynchronizeParticipant participant = this.getConfiguration().getParticipant();
        if (participant instanceof IChangeSetProvider) {
            return ((IChangeSetProvider)((Object)participant)).getChangeSetCapability().getActiveChangeSetManager();
        }
        return null;
    }

    public void reset(SyncInfoSet seedSet) {
        ChangeSet set;
        this.rootSet.clear();
        ChangeSet[] sets = this.activeSets.keySet().toArray(new ChangeSet[this.activeSets.size()]);
        int i = 0;
        while (i < sets.length) {
            set = sets[i];
            this.remove(set);
            ++i;
        }
        this.activeSets.clear();
        if (seedSet != null) {
            if (this.getConfiguration().getComparisonType() == "three-way") {
                sets = this.getActiveChangeSetManager().getSets();
                i = 0;
                while (i < sets.length) {
                    set = sets[i];
                    this.add(set);
                    ++i;
                }
                SyncInfo[] syncInfos = seedSet.getSyncInfos();
                int i2 = 0;
                while (i2 < syncInfos.length) {
                    ChangeSet[] containingSets;
                    SyncInfo info = syncInfos[i2];
                    if (this.isLocalChange(info) && (containingSets = this.findChangeSets(info)).length == 0) {
                        this.rootSet.add(info);
                    }
                    ++i2;
                }
            } else {
                this.add(seedSet.getSyncInfos());
            }
        }
    }

    public void handleChange(ISyncInfoSetChangeEvent event) {
        ArrayList<IResource> removals = new ArrayList<IResource>();
        ArrayList<SyncInfo> additions = new ArrayList<SyncInfo>();
        removals.addAll(Arrays.asList(event.getRemovedResources()));
        additions.addAll(Arrays.asList(event.getAddedResources()));
        SyncInfo[] changed = event.getChangedResources();
        int i = 0;
        while (i < changed.length) {
            SyncInfo info = changed[i];
            additions.add(info);
            removals.add(info.getLocal());
            ++i;
        }
        if (!removals.isEmpty()) {
            this.remove(removals.toArray(new IResource[removals.size()]));
        }
        if (!additions.isEmpty()) {
            this.add(additions.toArray(new SyncInfo[additions.size()]));
        }
    }

    protected void remove(IResource[] resources) {
        for (SyncInfoSet set : this.activeSets.values()) {
            set.removeAll(resources);
        }
        this.rootSet.removeAll(resources);
    }

    protected void add(SyncInfo[] infos) {
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            if (this.isLocalChange(info) && this.select(info)) {
                ChangeSet[] sets = this.findChangeSets(info);
                if (sets.length == 0) {
                    this.rootSet.add(info);
                } else {
                    int j = 0;
                    while (j < sets.length) {
                        ChangeSet set = sets[j];
                        SyncInfoTree targetSet = this.getSyncInfoSet(set);
                        if (targetSet == null) {
                            this.createSyncInfoSet(set);
                        } else {
                            targetSet.add(info);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private ChangeSet[] findChangeSets(SyncInfo info) {
        ActiveChangeSetManager manager = this.getActiveChangeSetManager();
        ChangeSet[] sets = manager.getSets();
        ArrayList<ChangeSet> result = new ArrayList<ChangeSet>();
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (set.contains(info.getLocal())) {
                result.add(set);
            }
            ++i;
        }
        return result.toArray(new ChangeSet[result.size()]);
    }

    private boolean isLocalChange(SyncInfo info) {
        if (!info.getComparator().isThreeWay()) {
            try {
                info = ((SubscriberChangeSetManager)this.getActiveChangeSetManager()).getSubscriber().getSyncInfo(info.getLocal());
            }
            catch (TeamException e) {
                TeamUIPlugin.log((CoreException)((Object)e));
            }
        }
        return info.getComparator().isThreeWay() && ((info.getKind() & 0xC) == 4 || (info.getKind() & 0xC) == 12);
    }

    public SyncInfoTree getRootSet() {
        return this.rootSet;
    }

    public void add(ChangeSet set) {
        SyncInfoTree targetSet = this.getSyncInfoSet(set);
        if (targetSet == null) {
            this.createSyncInfoSet(set);
        }
        if (this.listener != null) {
            this.listener.setAdded(set);
        }
    }

    private SyncInfoTree createSyncInfoSet(ChangeSet set) {
        SyncInfoTree sis = this.getSyncInfoSet(set);
        boolean added = false;
        try {
            if (sis == null) {
                sis = new SyncInfoTree();
                this.activeSets.put(set, sis);
                added = true;
            }
            sis.beginInput();
            if (!sis.isEmpty()) {
                sis.removeAll(sis.getResources());
            }
            sis.addAll(this.getSyncInfos(set));
        }
        finally {
            if (sis != null) {
                sis.endInput(null);
            }
        }
        if (added) {
            ((DiffChangeSet)set).getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
            if (this.listener != null) {
                this.listener.setAdded(set);
            }
        }
        return sis;
    }

    private SyncInfoSet getSyncInfos(ChangeSet set) {
        IDiff[] diffs = ((ResourceDiffTree)((DiffChangeSet)set).getDiffTree()).getDiffs();
        return this.asSyncInfoSet(diffs);
    }

    private SyncInfoSet asSyncInfoSet(IDiff[] diffs) {
        SyncInfoSet result = new SyncInfoSet();
        int i = 0;
        while (i < diffs.length) {
            SyncInfo info;
            IDiff diff = diffs[i];
            if (this.select(diff) && (info = this.asSyncInfo(diff)) != null) {
                result.add(info);
            }
            ++i;
        }
        return result;
    }

    private SyncInfo asSyncInfo(IDiff diff) {
        try {
            return ((SubscriberParticipant)this.getConfiguration().getParticipant()).getSubscriber().getSyncInfo(ResourceDiffTree.getResourceFor((IDiff)diff));
        }
        catch (TeamException e) {
            TeamUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    private boolean select(IDiff diff) {
        return this.getSeedSet().getSyncInfo(ResourceDiffTree.getResourceFor((IDiff)diff)) != null;
    }

    SyncInfo getSyncInfo(IPath path) {
        return this.getSyncInfo(this.getSeedSet(), path);
    }

    IResource[] getResources(SyncInfoSet set, IPath[] paths) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            SyncInfo info = this.getSyncInfo(set, path);
            if (info != null) {
                result.add(info.getLocal());
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private SyncInfo getSyncInfo(SyncInfoSet set, IPath path) {
        SyncInfo[] infos = set.getSyncInfos();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            if (info.getLocal().getFullPath().equals((Object)path)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public void remove(ChangeSet set) {
        ((DiffChangeSet)set).getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        this.activeSets.remove(set);
        if (this.listener != null) {
            this.listener.setRemoved(set);
        }
    }

    public SyncInfoTree getSyncInfoSet(ChangeSet set) {
        return (SyncInfoTree)this.activeSets.get(set);
    }

    private ChangeSet getChangeSet(IDiffTree tree) {
        for (ChangeSet changeSet : this.activeSets.keySet()) {
            if (((DiffChangeSet)changeSet).getDiffTree() != tree) continue;
            return changeSet;
        }
        return null;
    }

    private boolean select(SyncInfo info) {
        return this.getSeedSet().getSyncInfo(info.getLocal()) != null;
    }

    private SyncInfoSet getSeedSet() {
        return this.provider.getSyncInfoSet();
    }

    public void dispose() {
        this.getActiveChangeSetManager().removeListener(this.activeChangeSetListener);
    }

    public void setChangeSetChangeListener(IChangeSetChangeListener listener) {
        this.listener = listener;
        if (listener == null) {
            this.getActiveChangeSetManager().removeListener(this.activeChangeSetListener);
        } else {
            this.getActiveChangeSetManager().addListener(this.activeChangeSetListener);
        }
    }

    public void diffsChanged(final IDiffChangeEvent event, IProgressMonitor monitor) {
        this.provider.performUpdate(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                SyncInfoTree targetSet;
                ChangeSet changeSet = ActiveChangeSetCollector.this.getChangeSet(event.getTree());
                if (changeSet != null && (targetSet = ActiveChangeSetCollector.this.getSyncInfoSet(changeSet)) != null) {
                    targetSet.removeAll(ActiveChangeSetCollector.this.getResources((SyncInfoSet)targetSet, event.getRemovals()));
                    targetSet.addAll(ActiveChangeSetCollector.this.asSyncInfoSet(event.getAdditions()));
                    targetSet.addAll(ActiveChangeSetCollector.this.asSyncInfoSet(event.getChanges()));
                    ActiveChangeSetCollector.this.rootSet.removeAll(((IResourceDiffTree)event.getTree()).getAffectedResources());
                }
            }
        }, true, true);
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }
}

