/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public final class BasicMarkerUpdater
implements IMarkerUpdater {
    private static final String[] ATTRIBUTES = new String[]{"charStart", "charEnd", "lineNumber"};

    @Override
    public String[] getAttribute() {
        return ATTRIBUTES;
    }

    @Override
    public String getMarkerType() {
        return null;
    }

    @Override
    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        if (position == null) {
            return true;
        }
        if (position.isDeleted()) {
            return false;
        }
        boolean offsetsInitialized = false;
        boolean offsetsChanged = false;
        int markerStart = MarkerUtilities.getCharStart(marker);
        int markerEnd = MarkerUtilities.getCharEnd(marker);
        if (markerStart != -1 && markerEnd != -1) {
            offsetsInitialized = true;
            int offset = position.getOffset();
            if (markerStart != offset) {
                MarkerUtilities.setCharStart(marker, offset);
                offsetsChanged = true;
            }
            if (markerEnd != (offset += position.getLength())) {
                MarkerUtilities.setCharEnd(marker, offset);
                offsetsChanged = true;
            }
        }
        if (!offsetsInitialized || offsetsChanged && MarkerUtilities.getLineNumber(marker) != -1) {
            try {
                MarkerUtilities.setLineNumber(marker, document.getLineOfOffset(position.getOffset()) + 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return true;
    }
}

