/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;

class JavaBrowsingContentProvider
extends StandardJavaScriptElementContentProvider
implements IElementChangedListener {
    private StructuredViewer fViewer;
    private Object fInput;
    private JavaBrowsingPart fBrowsingPart;
    private int fReadsInDisplayThread;

    public JavaBrowsingContentProvider(boolean provideMembers, JavaBrowsingPart browsingPart) {
        super(provideMembers);
        this.fBrowsingPart = browsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        JavaScriptCore.addElementChangedListener((IElementChangedListener)this);
    }

    public boolean hasChildren(Object element) {
        this.startReadInDisplayThread();
        try {
            boolean bl = super.hasChildren(element);
            return bl;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        this.startReadInDisplayThread();
        try {
            if (element instanceof Collection) {
                Collection elements = (Collection)element;
                if (elements.isEmpty()) {
                    Object[] objectArray = NO_CHILDREN;
                    return objectArray;
                }
                Object[] result = new Object[]{};
                Iterator iter = ((Collection)element).iterator();
                while (iter.hasNext()) {
                    Object[] children = this.getChildren(iter.next());
                    if (children == NO_CHILDREN) continue;
                    result = JavaBrowsingContentProvider.concatenate(result, children);
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IPackageFragment) {
                Object[] objectArray = this.getPackageContents((IPackageFragment)element);
                return objectArray;
            }
            if (this.fProvideMembers && element instanceof IType) {
                Object[] objectArray = this.getChildren((IType)element);
                return objectArray;
            }
            if (this.fProvideMembers && element instanceof ISourceReference && element instanceof IParent) {
                Object[] objectArray = this.removeImportAndPackageDeclarations(super.getChildren(element));
                return objectArray;
            }
            if (element instanceof IJavaScriptProject) {
                Object[] objectArray = this.getPackageFragmentRoots((IJavaScriptProject)element);
                return objectArray;
            }
            Object[] objectArray = super.getChildren(element);
            return objectArray;
        }
        catch (JavaScriptModelException e) {
            Object[] objectArray = NO_CHILDREN;
            return objectArray;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    private Object[] getPackageContents(IPackageFragment fragment) throws JavaScriptModelException {
        IJavaScriptUnit[] sourceRefs;
        if (fragment.getKind() == 1) {
            sourceRefs = fragment.getJavaScriptUnits();
        } else {
            IClassFile[] classFiles = fragment.getClassFiles();
            ArrayList<IClassFile> topLevelClassFile = new ArrayList<IClassFile>();
            int i = 0;
            while (i < classFiles.length) {
                IType type = classFiles[i].getType();
                if (type != null && type.getDeclaringType() == null && !type.isAnonymous() && !type.isLocal()) {
                    topLevelClassFile.add(classFiles[i]);
                }
                ++i;
            }
            sourceRefs = topLevelClassFile.toArray(new ISourceReference[topLevelClassFile.size()]);
        }
        Object[] result = new Object[]{};
        int i = 0;
        while (i < sourceRefs.length) {
            result = JavaBrowsingContentProvider.concatenate(result, this.removeImportAndPackageDeclarations(this.getChildren(sourceRefs[i])));
            ++i;
        }
        return JavaBrowsingContentProvider.concatenate(result, fragment.getNonJavaScriptResources());
    }

    private Object[] removeImportAndPackageDeclarations(Object[] members) {
        ArrayList<Object> tempResult = new ArrayList<Object>(members.length);
        int i = 0;
        while (i < members.length) {
            if (!(members[i] instanceof IImportContainer)) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        return tempResult.toArray();
    }

    private Object[] getChildren(IType type) throws JavaScriptModelException {
        Object parent = type.isBinary() ? type.getClassFile() : type.getJavaScriptUnit();
        if (type.getDeclaringType() != null) {
            return type.getChildren();
        }
        IJavaScriptElement[] members = parent.getChildren();
        ArrayList<IJavaScriptElement> tempResult = new ArrayList<IJavaScriptElement>(members.length);
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof IImportContainer) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        tempResult.addAll(Arrays.asList(type.getChildren()));
        return tempResult.toArray();
    }

    protected Object[] getPackageFragmentRoots(IJavaScriptProject project) throws JavaScriptModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isExternal()) {
                IJavaScriptElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                list.add(root);
            }
            ++i;
        }
        return JavaBrowsingContentProvider.concatenate(list.toArray(), project.getNonJavaScriptResources());
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof Collection) {
            Collection col = (Collection)newInput;
            newInput = !col.isEmpty() ? col.iterator().next() : null;
        }
        this.fInput = newInput;
    }

    public void dispose() {
        super.dispose();
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e.getStatus());
        }
    }

    protected void processDelta(IJavaScriptElementDelta delta) throws JavaScriptModelException {
        IJavaScriptElementDelta[] affectedChildren;
        IJavaScriptElement inputsParent;
        IPackageFragmentRoot pkgRoot;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IJavaScriptElement element = delta.getElement();
        boolean isElementValidForView = this.fBrowsingPart.isValidElement(element);
        if (!this.getProvideWorkingCopy() && element instanceof IJavaScriptUnit && ((IJavaScriptUnit)element).isWorkingCopy()) {
            return;
        }
        if (element != null && element.getElementType() == 5 && !this.isOnClassPath((IJavaScriptUnit)element)) {
            return;
        }
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(null);
            return;
        }
        if (kind == 2) {
            Object parent = this.internalGetParent(element);
            if (isElementValidForView) {
                if (element instanceof IClassFile) {
                    this.postRemove(((IClassFile)element).getType());
                } else if (element instanceof IJavaScriptUnit && !((IJavaScriptUnit)element).isWorkingCopy()) {
                    this.postRefresh(null);
                } else if (element instanceof IJavaScriptUnit && ((IJavaScriptUnit)element).isWorkingCopy()) {
                    if (this.getProvideWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (parent instanceof IJavaScriptUnit && this.getProvideWorkingCopy() && !((IJavaScriptUnit)parent).isWorkingCopy()) {
                    if (element instanceof IJavaScriptUnit && ((IJavaScriptUnit)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (element instanceof IJavaScriptUnit && ((IJavaScriptUnit)element).isWorkingCopy() && parent != null && parent.equals(this.fInput)) {
                    this.postRefresh(null);
                } else {
                    this.postRemove(element);
                }
            }
            if (this.fBrowsingPart.isAncestorOf(element, this.fInput)) {
                if (element instanceof IJavaScriptUnit && ((IJavaScriptUnit)element).isWorkingCopy()) {
                    this.postAdjustInputAndSetSelection(((IJavaScriptElement)this.fInput).getPrimaryElement());
                } else {
                    this.postAdjustInputAndSetSelection(null);
                }
            }
            if (this.fInput != null && this.fInput.equals(element)) {
                this.postRefresh(null);
            }
            if (parent instanceof IPackageFragment && this.fBrowsingPart.isValidElement(parent) && this.isPackageFragmentEmpty((IJavaScriptElement)((IPackageFragment)parent)) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(null);
            }
            return;
        }
        if (kind == 1 && delta.getMovedFromElement() != null && element instanceof IJavaScriptUnit) {
            return;
        }
        if (kind == 1) {
            if (isElementValidForView) {
                Object parent = this.internalGetParent(element);
                if (element instanceof IClassFile) {
                    this.postAdd(parent, ((IClassFile)element).getType());
                } else if (element instanceof IJavaScriptUnit && !((IJavaScriptUnit)element).isWorkingCopy()) {
                    this.postAdd(parent, ((IJavaScriptUnit)element).getTypes());
                } else if (!(parent instanceof IJavaScriptUnit) || !this.getProvideWorkingCopy() || ((IJavaScriptUnit)parent).isWorkingCopy()) {
                    if (element instanceof IJavaScriptUnit && ((IJavaScriptUnit)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    } else {
                        this.postAdd(parent, element);
                    }
                }
            } else if (this.fInput == null) {
                IJavaScriptElement newInput = this.fBrowsingPart.findInputForJavaElement(element);
                if (newInput != null) {
                    this.postAdjustInputAndSetSelection(element);
                }
            } else if (element instanceof IType && this.fBrowsingPart.isValidInput(element)) {
                IJavaScriptElement cu1 = element.getAncestor(5);
                IJavaScriptElement cu2 = ((IJavaScriptElement)this.fInput).getAncestor(5);
                if (cu1 != null && cu2 != null && cu1.equals(cu2)) {
                    this.postAdjustInputAndSetSelection(element);
                }
            }
            return;
        }
        if (kind == 4) {
            if (this.fInput != null && this.fInput.equals(element) && (flags & 8) != 0 && (flags & 0x4000) != 0) {
                this.postRefresh(null, true);
                return;
            }
            if (isElementValidForView && (flags & 2) != 0) {
                this.postUpdateIcon(element);
            }
        }
        if (this.isClassPathChange(delta)) {
            this.postRefresh(null);
        }
        if ((flags & 0x8000) != 0 && this.fInput instanceof IJavaScriptElement && (pkgRoot = (IPackageFragmentRoot)element).equals(inputsParent = ((IJavaScriptElement)this.fInput).getAncestor(3))) {
            this.postRefresh(null);
        }
        if (element instanceof IPackageFragmentRoot && ((flags & 0x1000) != 0 || (flags & 0x2000) != 0)) {
            this.postUpdateIcon(element);
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            if (element instanceof IPackageFragment) {
                IJavaScriptElement parent = (IJavaScriptElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element);
                } else {
                    this.postRefresh(parent);
                }
            }
            if (element instanceof IPackageFragmentRoot && isElementValidForView) {
                this.postRefresh(this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)element));
                return;
            }
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnClassPath(IJavaScriptUnit element) throws JavaScriptModelException {
        IJavaScriptProject project = element.getJavaScriptProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnIncludepath((IJavaScriptElement)element);
    }

    private void postUpdateIcon(final IJavaScriptElement element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaBrowsingContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void postRefresh(final Object root, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaBrowsingContentProvider.this.fViewer.refresh(root, updateLabels);
                }
            }
        });
    }

    private void postRefresh(Object root) {
        this.postRefresh(root, false);
    }

    private void postAdd(Object parent, Object element) {
        this.postAdd(parent, new Object[]{element});
    }

    private void postAdd(final Object parent, final Object[] elements) {
        if (elements == null || elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Object[] newElements = JavaBrowsingContentProvider.this.getNewElements(elements);
                    if (JavaBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        if (JavaBrowsingContentProvider.this.fViewer.testFindItem(parent) == null) {
                            Object root = ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).getInput();
                            if (root != null) {
                                ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).add(root, newElements);
                            }
                        } else {
                            ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).add(parent, newElements);
                        }
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)JavaBrowsingContentProvider.this.fViewer).add(newElements);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)JavaBrowsingContentProvider.this.fViewer).add(newElements);
                    }
                    if (JavaBrowsingContentProvider.this.fViewer.testFindItem(elements[0]) != null) {
                        JavaBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(elements[0]);
                    }
                }
            }
        });
    }

    private Object[] getNewElements(Object[] elements) {
        int elementsLength = elements.length;
        ArrayList<Object> result = new ArrayList<Object>(elementsLength);
        int i = 0;
        while (i < elementsLength) {
            Object element = elements[i];
            if (this.fViewer.testFindItem(element) == null) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray();
    }

    private void postRemove(Object element) {
        this.postRemove(new Object[]{element});
    }

    private void postRemove(final Object[] elements) {
        if (elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (JavaBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)JavaBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)JavaBrowsingContentProvider.this.fViewer).remove(elements);
                    }
                }
            }
        });
    }

    private void postAdjustInputAndSetSelection(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.setRedraw(false);
                    JavaBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(element);
                    ctrl.setRedraw(true);
                }
            }
        });
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    private boolean isDisplayThread() {
        Control ctrl = this.fViewer.getControl();
        if (ctrl == null) {
            return false;
        }
        Display currentDisplay = Display.getCurrent();
        return currentDisplay != null && currentDisplay.equals(ctrl.getDisplay());
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.fBrowsingPart.setProcessSelectionEvents(false);
            try {
                if (this.isDisplayThread() && this.fReadsInDisplayThread == 0) {
                    ctrl.getDisplay().syncExec(r);
                } else {
                    ctrl.getDisplay().asyncExec(r);
                }
            }
            finally {
                this.fBrowsingPart.setProcessSelectionEvents(true);
            }
        }
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IJavaScriptProject) {
            return ((IJavaScriptProject)element).getJavaScriptModel();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaScriptElement jParent = JavaScriptCore.create((IResource)parent);
            if (jParent != null) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragmentRoot parent = (IPackageFragmentRoot)((IPackageFragment)element).getParent();
            return this.skipProjectPackageFragmentRoot(parent);
        }
        if (element instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)element).getParent();
        }
        return null;
    }
}

